/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#include "TAboutWindow.h"

TAboutWindow::TAboutWindow(QWidget *parent) : QDialog(parent)
{
	QLabel *headerLogo = new QLabel();
	QPixmap pixLogo(":/img/logo.svg");
	headerLogo->setPixmap(pixLogo.scaled(QSize(64, 64)));
	QLabel *headerName = new QLabel("<b>" + QString(APPLICATION_NAME) + "-" + QString(VERSION) + "</b>");
	if(STATUS != "release")
	{
		headerName->setText(headerName->text() + "-" + QString(STATUS));
	}
	headerName->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	QHBoxLayout *headerLayout = new QHBoxLayout();
	headerLayout->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	headerLayout->addWidget(headerLogo);
	headerLayout->addWidget(headerName);
	
	tabWidget = new QTabWidget(this);
	tabWidget->setMinimumSize(QSize(400, 300));
	tab1 = new QWidget(this);
	tab2 = new QWidget(this);
	tab3 = new QWidget(this);
	tab4 = new QWidget(this);
	tabWidget->addTab(tab1, tr("About"));
	tabWidget->addTab(tab2, tr("Authors"));
	tabWidget->addTab(tab3, tr("Thanks To"));
	tabWidget->addTab(tab4, tr("License Agreement"));
	
	//tab1
	QTextBrowser *l1 = new QTextBrowser(this);
	l1->setText(this->loadText(":/ABOUT"));
	
	QVBoxLayout *tab1VLayout = new QVBoxLayout();
	tab1VLayout->addWidget(l1);
	QHBoxLayout *tab1HLayout = new QHBoxLayout();
	tab1HLayout->addLayout(tab1VLayout);
	tab1->setLayout(tab1HLayout);
	
	//tab2
	QTextBrowser *l2 = new QTextBrowser(this);
	l2->setText(this->loadText(":/AUTHORS"));
	
	QVBoxLayout *tab2VLayout = new QVBoxLayout();
	tab2VLayout->addWidget(l2);
	QHBoxLayout *tab2HLayout = new QHBoxLayout();
	tab2HLayout->addLayout(tab2VLayout);
	tab2->setLayout(tab2HLayout);
	
	//tab3
	QTextBrowser *l3 = new QTextBrowser(this);
	l3->setText(this->loadText(":/THANKSTO"));
	
	QVBoxLayout *tab3VLayout = new QVBoxLayout();
	tab3VLayout->addWidget(l3);
	QHBoxLayout *tab3HLayout = new QHBoxLayout();
	tab3HLayout->addLayout(tab3VLayout);
	tab3->setLayout(tab3HLayout);
	
	//tab4
	QTextBrowser *l4 = new QTextBrowser(this);
	l4->setText(this->loadText(":/LICENSE"));
	
	QVBoxLayout *tab4VLayout = new QVBoxLayout();
	tab4VLayout->addWidget(l4);
	QHBoxLayout *tab4HLayout = new QHBoxLayout();
	tab4HLayout->addLayout(tab4VLayout);
	tab4->setLayout(tab4HLayout);
	
	
	okButton = new QPushButton(tr("Close"));
	QHBoxLayout *buttonLayout = new QHBoxLayout();
	buttonLayout->addStretch(1);
	buttonLayout->addWidget(okButton);
	connect(okButton, SIGNAL(clicked()), this, SLOT(accept()));
	
	QVBoxLayout *vbox = new QVBoxLayout();
	vbox->addLayout(headerLayout);
	vbox->addWidget(tabWidget);
	vbox->addLayout(buttonLayout);
	QHBoxLayout *hbox = new QHBoxLayout();
	hbox->addLayout(vbox);
	this->setLayout(hbox);
	
	this->setModal(true);
	this->setWindowTitle(tr("About " APPLICATION_NAME));
}

QString TAboutWindow::loadText(QString filename)
{
	if (!QFile::exists(filename))
		return "";
	
	QFile file(filename);
	if (!file.open(QFile::ReadOnly))
		return "";
	
	QByteArray data = file.readAll();
	QTextCodec *codec = Qt::codecForHtml(data);
	return codec->toUnicode(data);
}
