/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.PropertyListMapping;
import org.apache.fop.fo.SVGTreeBuilder;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.messaging.MessageHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.svg.SVGDocument;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class SVGDriver {
    protected SVGTreeBuilder treeBuilder = new SVGTreeBuilder();
    protected PrintWriter writer;

    public void addElementMapping(String string) {
        this.createElementMapping(string).addToBuilder(this.treeBuilder);
    }

    public void addElementMapping(ElementMapping elementMapping) {
        elementMapping.addToBuilder(this.treeBuilder);
    }

    public void addPropertyList(String string) {
        this.createPropertyList(string).addToBuilder(this.treeBuilder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buildSVGTree(Document document) throws FOPException {
        char[] cArray = null;
        AttributesImpl attributesImpl = new AttributesImpl();
        Object object = document;
        try {
            block12: while (true) {
                Object object2;
                if (object == null) {
                    return;
                }
                block1 : switch (object.getNodeType()) {
                    case 9: {
                        this.treeBuilder.startDocument();
                        break;
                    }
                    case 3: 
                    case 4: {
                        object2 = object.getNodeValue();
                        int n = ((String)object2).length();
                        if (cArray == null || cArray.length < n) {
                            cArray = new char[n];
                        }
                        ((String)object2).getChars(0, n, cArray, 0);
                        this.treeBuilder.characters(cArray, 0, n);
                        break;
                    }
                    case 7: {
                        this.treeBuilder.processingInstruction(object.getNodeName(), object.getNodeValue());
                        break;
                    }
                    case 1: {
                        NamedNodeMap namedNodeMap = object.getAttributes();
                        attributesImpl.clear();
                        int n = namedNodeMap.getLength() - 1;
                        while (true) {
                            if (n < 0) {
                                this.treeBuilder.startElement("", object.getNodeName(), "", attributesImpl);
                                break block1;
                            }
                            Attr attr = (Attr)namedNodeMap.item(n);
                            attributesImpl.addAttribute("", attr.getName(), "", "CDATA", attr.getValue());
                            --n;
                        }
                    }
                }
                object2 = object.getFirstChild();
                if (object2 != null) {
                    object = object2;
                    continue;
                }
                while (true) {
                    if (object == null) continue block12;
                    switch (object.getNodeType()) {
                        case 9: {
                            this.treeBuilder.endDocument();
                            break;
                        }
                        case 1: {
                            this.treeBuilder.endElement("", object.getNodeName(), "");
                            break;
                        }
                    }
                    object2 = object.getNextSibling();
                    if (object2 != null) {
                        object = object2;
                        continue block12;
                    }
                    object = object.getParentNode();
                }
                break;
            }
        }
        catch (SAXException sAXException) {
            throw new FOPException(sAXException.getMessage());
        }
    }

    public void buildSVGTree(XMLReader xMLReader, InputSource inputSource) throws FOPException {
        xMLReader.setContentHandler(this.treeBuilder);
        try {
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            if (sAXException.getException() instanceof FOPException) {
                throw (FOPException)sAXException.getException();
            }
            throw new FOPException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new FOPException(iOException.getMessage());
        }
    }

    protected ElementMapping createElementMapping(String string) {
        MessageHandler.logln("using element mapping " + string);
        try {
            return (ElementMapping)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageHandler.errorln("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            MessageHandler.errorln("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            MessageHandler.errorln("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            MessageHandler.errorln(String.valueOf(string) + " is not an element mapping");
        }
        return null;
    }

    protected PropertyListMapping createPropertyList(String string) {
        MessageHandler.logln("using property list mapping " + string);
        try {
            return (PropertyListMapping)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageHandler.errorln("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            MessageHandler.errorln("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            MessageHandler.errorln("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            MessageHandler.errorln(String.valueOf(string) + " is not an property list");
        }
        return null;
    }

    public void format() throws FOPException {
        FontInfo fontInfo = new FontInfo();
    }

    public ContentHandler getContentHandler() {
        return this.treeBuilder;
    }

    public SVGDocument getSVGDocument() {
        return this.treeBuilder.getSVGDocument();
    }
}

