/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.Enumeration;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.ColumnArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.Page;
import org.apache.fop.render.Renderer;

public class SpanArea
extends AreaContainer {
    private int columnCount;
    private int currentColumn = 1;
    private int columnGap = 0;
    private boolean isBalanced = false;

    public SpanArea(FontState fontState, int n, int n2, int n3, int n4, int n5, int n6) {
        super(fontState, n, n2, n3, n4, 3);
        this.contentRectangleWidth = n3;
        this.columnCount = n5;
        this.columnGap = n6;
        int n7 = (n3 - n6 * (n5 - 1)) / n5;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n + n8 * (n7 + n6);
            int n10 = n2;
            ColumnArea columnArea = new ColumnArea(fontState, n9, n10, n7, n4, n5);
            this.addChild(columnArea);
            columnArea.setColumnIndex(n8 + 1);
            ++n8;
        }
    }

    public void end() {
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    public AreaContainer getCurrentColumnArea() {
        return (AreaContainer)this.getChildren().elementAt(this.currentColumn - 1);
    }

    public int getMaxContentHeight() {
        int n = 0;
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            AreaContainer areaContainer = (AreaContainer)enumeration.nextElement();
            if (areaContainer.getContentHeight() <= n) continue;
            n = areaContainer.getContentHeight();
        }
        return n;
    }

    public int getTotalContentHeight() {
        int n = 0;
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            n += ((AreaContainer)enumeration.nextElement()).getContentHeight();
        }
        return n;
    }

    public boolean isBalanced() {
        return this.isBalanced;
    }

    public boolean isLastColumn() {
        return this.currentColumn == this.columnCount;
    }

    public void render(Renderer renderer) {
        renderer.renderSpanArea(this);
    }

    public void setCurrentColumn(int n) {
        this.currentColumn = n <= this.columnCount ? n : this.columnCount;
    }

    public void setIsBalanced() {
        this.isBalanced = true;
    }

    public void setPage(Page page) {
        this.page = page;
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            ((AreaContainer)enumeration.nextElement()).setPage(page);
        }
    }

    public int spaceLeft() {
        return this.maxHeight - this.currentHeight;
    }

    public void start() {
    }
}

