/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableFooter;
import org.apache.fop.fo.flow.TableHeader;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.messaging.MessageHandler;

public class Table
extends FObj {
    FontState fs;
    int breakBefore;
    int breakAfter;
    int spaceBefore;
    int spaceAfter;
    ColorType backgroundColor;
    int width;
    int height;
    ColorType borderColor;
    int borderWidth;
    int borderStyle;
    String id;
    TableHeader tableHeader = null;
    TableFooter tableFooter = null;
    boolean omitHeaderAtBreak = false;
    boolean omitFooterAtBreak = false;
    Vector columns = new Vector();
    int currentColumnNumber = 0;
    int bodyCount = 0;
    AreaContainer areaContainer;

    public Table(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table";
    }

    public int getAreaHeight() {
        return this.areaContainer.getHeight();
    }

    public int getContentWidth() {
        if (this.areaContainer != null) {
            return this.areaContainer.getContentWidth();
        }
        return 0;
    }

    public Status layout(Area area) throws FOPException {
        FONode fONode;
        int n;
        int n2;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            String string3 = this.properties.get("font-weight").getString();
            n2 = this.properties.get("font-size").getLength().mvalue();
            n = this.properties.get("font-variant").getEnum();
            this.fs = new FontState(area.getFontInfo(), string, string2, string3, n2, n);
            this.breakBefore = this.properties.get("break-before").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.width = this.properties.get("width").getLength().mvalue();
            this.height = this.properties.get("height").getLength().mvalue();
            this.borderColor = this.properties.get("border-color").getColorType();
            this.borderWidth = this.properties.get("border-width").getLength().mvalue();
            this.borderStyle = this.properties.get("border-style").getEnum();
            this.id = this.properties.get("id").getString();
            this.omitHeaderAtBreak = this.properties.get("table-omit-header-at-break").getEnum() == 1;
            boolean bl = this.omitFooterAtBreak = this.properties.get("table-omit-footer-at-break").getEnum() == 1;
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.areaContainer == null) {
                area.getIDReferences().createID(this.id);
            }
            this.marker = 0;
            if (this.breakBefore == 3) {
                return new Status(4);
            }
            if (this.breakBefore == 5) {
                return new Status(6);
            }
            if (this.breakBefore == 4) {
                return new Status(5);
            }
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        if (this.marker == 0 && this.areaContainer == null) {
            area.getIDReferences().configureID(this.id, area);
        }
        this.areaContainer = new AreaContainer(this.fs, 0, 0, area.getAllocationWidth(), area.spaceLeft(), 1);
        this.areaContainer.foCreator = this;
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setBorderStyle(this.borderStyle, this.borderStyle, this.borderStyle, this.borderStyle);
        this.areaContainer.setBorderWidth(this.borderWidth, this.borderWidth, this.borderWidth, this.borderWidth);
        this.areaContainer.setBorderColor(this.borderColor, this.borderColor, this.borderColor, this.borderColor);
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        this.currentColumnNumber = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        n2 = this.children.size();
        n = 0;
        while (n < n2) {
            FONode fONode2 = (FONode)this.children.elementAt(n);
            if (fONode2 instanceof TableColumn) {
                fONode = (TableColumn)fONode2;
                int n4 = ((TableColumn)fONode).getColumnNumber();
                if (n4 == 0) {
                    n4 = this.currentColumnNumber + 1;
                }
                this.currentColumnNumber = n4;
                if (n4 > this.columns.size()) {
                    this.columns.setSize(n4);
                }
                this.columns.setElementAt(fONode, n4 - 1);
                ((TableColumn)fONode).setColumnOffset(n3);
                fONode2.layout(this.areaContainer);
                n3 += ((TableColumn)fONode).getColumnWidth();
            }
            ++n;
        }
        this.areaContainer.setAllocationWidth(n3);
        int n5 = this.marker;
        while (n5 < n2) {
            fONode = (FONode)this.children.elementAt(n5);
            if (fONode instanceof TableHeader) {
                if (this.columns.size() == 0) {
                    MessageHandler.errorln("WARNING: current implementation of tables requires a table-column for each column, indicating column-width");
                    return new Status(1);
                }
                this.tableHeader = (TableHeader)fONode;
                this.tableHeader.setColumns(this.columns);
            } else if (fONode instanceof TableFooter) {
                if (this.columns.size() == 0) {
                    MessageHandler.errorln("WARNING: current implementation of tables requires a table-column for each column, indicating column-width");
                    return new Status(1);
                }
                this.tableFooter = (TableFooter)fONode;
                this.tableFooter.setColumns(this.columns);
            } else if (fONode instanceof TableBody) {
                if (this.columns.size() == 0) {
                    MessageHandler.errorln("WARNING: current implementation of tables requires a table-column for each column, indicating column-width");
                    return new Status(1);
                }
                if (this.tableHeader != null && !bl) {
                    Status status = this.tableHeader.layout(this.areaContainer);
                    if (status.isIncomplete()) {
                        return new Status(2);
                    }
                    bl = true;
                    this.tableHeader.resetMarker();
                }
                if (this.tableFooter != null && !this.omitFooterAtBreak && !bl2) {
                    Status status = this.tableFooter.layout(this.areaContainer);
                    if (status.isIncomplete()) {
                        return new Status(2);
                    }
                    bl2 = true;
                    this.tableFooter.resetMarker();
                }
                fONode.setWidows(this.widows);
                fONode.setOrphans(this.orphans);
                ((TableBody)fONode).setColumns(this.columns);
                Status status = fONode.layout(this.areaContainer);
                if (status.isIncomplete()) {
                    this.marker = n5;
                    if (this.bodyCount == 0 && status.getCode() == 2) {
                        if (this.tableHeader != null) {
                            this.tableHeader.removeLayout(this.areaContainer);
                        }
                        if (this.tableFooter != null) {
                            this.tableFooter.removeLayout(this.areaContainer);
                        }
                        this.resetMarker();
                    }
                    if (this.areaContainer.getContentHeight() > 0) {
                        area.addChild(this.areaContainer);
                        area.increaseHeight(this.areaContainer.getHeight());
                        area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
                        if (this.omitHeaderAtBreak) {
                            this.tableHeader = null;
                        }
                        if (this.tableFooter != null && !this.omitFooterAtBreak) {
                            ((TableBody)fONode).setYPosition(this.tableFooter.getYPosition());
                            this.tableFooter.setYPosition(this.tableFooter.getYPosition() + ((TableBody)fONode).getHeight());
                        }
                        this.setupColumnHeights();
                        status = new Status(3);
                    }
                    return status;
                }
                ++this.bodyCount;
                if (this.tableFooter != null && !this.omitFooterAtBreak) {
                    ((TableBody)fONode).setYPosition(this.tableFooter.getYPosition());
                    this.tableFooter.setYPosition(this.tableFooter.getYPosition() + ((TableBody)fONode).getHeight());
                }
            }
            ++n5;
        }
        if (this.tableFooter != null && this.omitFooterAtBreak && this.tableFooter.layout(this.areaContainer).isIncomplete()) {
            MessageHandler.errorln("WARNING: footer could not fit on page, moving last body row to next page");
            area.addChild(this.areaContainer);
            area.increaseHeight(this.areaContainer.getHeight());
            area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
            if (this.omitHeaderAtBreak) {
                this.tableHeader = null;
            }
            this.tableFooter.removeLayout(this.areaContainer);
            this.tableFooter.resetMarker();
            return new Status(3);
        }
        if (this.height != 0) {
            this.areaContainer.setHeight(this.height);
        }
        this.setupColumnHeights();
        this.areaContainer.end();
        area.addChild(this.areaContainer);
        area.increaseHeight(this.areaContainer.getHeight());
        area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        if (this.breakAfter == 3) {
            this.marker = -1001;
            return new Status(4);
        }
        if (this.breakAfter == 5) {
            this.marker = -1001;
            return new Status(6);
        }
        if (this.breakAfter == 4) {
            this.marker = -1001;
            return new Status(5);
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected void setupColumnHeights() {
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            FONode fONode = (FONode)this.children.elementAt(n2);
            if (fONode instanceof TableColumn) {
                ((TableColumn)fONode).setHeight(this.areaContainer.getHeight());
            }
            ++n2;
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Table(fObj, propertyList);
        }
    }
}

