/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Version;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.PreviewDialog;
import org.apache.fop.viewer.SecureResourceBundle;
import org.apache.fop.viewer.Translator;
import org.apache.fop.viewer.UserMessage;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AWTCommandLine {
    public static String TRANSLATION_PATH = "/org/apache/fop/viewer/resources/";
    private Translator resource;

    public AWTCommandLine(String string, String string2) {
        if (string2 == null) {
            string2 = System.getProperty("user.language");
        }
        this.resource = this.getResourceBundle(String.valueOf(TRANSLATION_PATH) + "resources." + string2);
        UserMessage.setTranslator(this.getResourceBundle(String.valueOf(TRANSLATION_PATH) + "messages." + string2));
        this.resource.setMissingEmphasized(false);
        AWTRenderer aWTRenderer = new AWTRenderer(this.resource);
        PreviewDialog previewDialog = this.createPreviewDialog(aWTRenderer, this.resource);
        aWTRenderer.setProgressListener(previewDialog);
        aWTRenderer.setComponent(previewDialog);
        MessageHandler.setOutputMethod(2);
        MessageHandler.addListener(previewDialog);
        previewDialog.progress(String.valueOf(this.resource.getString("Init parser")) + " ...");
        XMLReader xMLReader = AWTCommandLine.createParser();
        if (xMLReader == null) {
            MessageHandler.errorln("ERROR: Unable to create SAX parser");
            System.exit(1);
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException sAXException) {
            MessageHandler.errorln("Error in setting up parser feature namespace-prefixes");
            MessageHandler.errorln("You need a parser which supports SAX version 2");
            System.exit(1);
        }
        try {
            Driver driver = new Driver();
            driver.setRenderer(aWTRenderer);
            previewDialog.progress(String.valueOf(this.resource.getString("Init mappings")) + " ...");
            driver.addElementMapping("org.apache.fop.fo.StandardElementMapping");
            driver.addElementMapping("org.apache.fop.svg.SVGElementMapping");
            driver.addPropertyList("org.apache.fop.fo.StandardPropertyListMapping");
            driver.addPropertyList("org.apache.fop.svg.SVGPropertyListMapping");
            previewDialog.progress(String.valueOf(this.resource.getString("Build FO tree")) + " ...");
            driver.buildFOTree(xMLReader, AWTCommandLine.fileInputSource(string));
            previewDialog.progress(String.valueOf(this.resource.getString("Layout FO tree")) + " ...");
            driver.format();
            previewDialog.progress(String.valueOf(this.resource.getString("Render")) + " ...");
            driver.render();
            previewDialog.progress(this.resource.getString("Show"));
            previewDialog.showPage();
        }
        catch (Exception exception) {
            MessageHandler.errorln("FATAL ERROR: " + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static XMLReader createParser() {
        String string = System.getProperty("org.xml.sax.parser");
        if (string == null) {
            string = "org.apache.xerces.parsers.SAXParser";
        }
        MessageHandler.logln("using SAX parser " + string);
        try {
            return (XMLReader)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageHandler.errorln("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            MessageHandler.errorln("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            MessageHandler.errorln("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            MessageHandler.errorln(String.valueOf(string) + " is not a SAX driver");
        }
        return null;
    }

    protected PreviewDialog createPreviewDialog(AWTRenderer aWTRenderer, Translator translator) {
        PreviewDialog previewDialog = new PreviewDialog(aWTRenderer, translator);
        previewDialog.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = previewDialog.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        ((Component)previewDialog).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)previewDialog).setVisible(true);
        return previewDialog;
    }

    protected static InputSource fileInputSource(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = String.valueOf('/') + string2;
        }
        try {
            return new InputSource(new URL("file", null, string2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    private SecureResourceBundle getResourceBundle(String string) {
        InputStream inputStream = null;
        try {
            URL uRL = this.getClass().getResource(string);
            inputStream = uRL.openStream();
        }
        catch (Exception exception) {
            MessageHandler.logln("Can't find URL to: <" + string + "> " + exception.getMessage());
        }
        return new SecureResourceBundle(inputStream);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = null;
        String string2 = null;
        Object var3_4 = null;
        MessageHandler.errorln(Version.getVersion());
        if (stringArray.length < 1 || stringArray.length > 3) {
            MessageHandler.errorln("usage: java AWTCommandLine formatting-object-file [language] ");
            System.exit(1);
        }
        string = stringArray[0];
        if (stringArray.length > 1) {
            string2 = stringArray[1];
        }
        new AWTCommandLine(string, string2);
    }
}

