/*
 * ===========================
 * VDK Visual Development Kit
 * xdb subsystem
 * Version 0.1
 * Revision 0.0
 * April 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <vdkxdb/vdkxmemo.h>


VDKXMemo::VDKXMemo(VDKForm* owner,bool editable):
  VDKText(owner,editable), VDKXControl()
{
}

bool 
VDKXMemo::AssignTableField(VDKXTable* t,
			    char* fname)
{
  if(t)
    {
      xbShort id = t->GetFieldNo(fname);
      xbShort type = t->GetFieldType(id);
      if((type == 'M') )
	return VDKXControl::AssignTableField(t, fname);
      else
	return false;
    }
  else
    return false;
}
/*
 */
xbShort
VDKXMemo::Read()
{
  xbShort rc = XB_NOT_OPEN; 
  if(table)
    {
      char* p = NULL;
      Clear();
      xbLong l = table->MemoFieldExists(field_id) ? 
	table->GetMemoFieldLen(field_id): 0;
      if(l)
	{
	  p = new char[l+1];
	  rc = table->GetMemoField(field_id,l,p,F_SETLK);
	  p[l] = '\0';
	  TextInsert(p);
	  delete[] p;
	}
      
    }
  return rc;
}
/*
 */
xbShort
VDKXMemo::Write()
{
  xbShort rc = XB_NOT_OPEN; 
  if(table)
    {
      // writes memo field
      char* p = NULL;
      int l = Length;
      if(l)
	{
	  p = new char[l+1];
	  strcpy(p,GetChars(0,-1));
	  rc = table->UpdateMemoData(field_id, l, p, F_SETLKW );
	  delete[] p;
	}
    }
  return rc;
}
