/*
 * ===========================
 * VDK Visual Development Kit
 * xdb subsystem
 * Version 0.1
 * Revision 0.0
 * April 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _vdkxentry_h
#define _vdkxentry_h
#include <vdkxdb/vdkxctrl.h>
#include <vdk/entry.h>


/*!
  \class VDKXEntry
  \brief data-aware VDKEntry widget.

  This control interfaces a table field. 
 */
class VDKXEntry: public VDKEntry, public VDKXControl
{
 protected:

 public:

  /*! 
    Constructor
    \param owner forms that owns the widget
    \param maxLen max editable chars
    \param def default value
  */
  VDKXEntry(VDKForm* owner, int maxLen = 0, char* def = NULL);
  //! Destructor
  virtual ~VDKXEntry() {}
  /*!
    Read field to control
   */
  virtual xbShort Read();
  /*!
    Writes control content to field.
   */
  virtual xbShort Write(); 
  /*!
    Assign a table field to the control
    \param table table that owns the field
    \param fname field name as in table VDKXRecordTemplate
    descriptor structure (see it into xdb/dbf.h)
    It can hold:
    \arg character type
    \arg numeric types
    \arg date types
  */
  virtual bool AssignTableField(VDKXTable* table,char* fname);
  bool AssignTableField(VDKXDatabase* xdb,
				char* tablename,
				char* fieldname)
    { 
      return VDKXControl::AssignTableField(xdb,tablename,fieldname);
    }


};
#endif
