/*
 * ===========================
 * VDK Visual Development Kit
 * xdb subsystem
 * Version 0.1
 * Revision 0.0
 * April 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
/*!
  \mainpage VDKXdb version 0.0.1

  \section introduction What is VDKXdb
  VDKXdb is a wrapper on xdb library. It provides a set of VDK
  data-aware widgets and some database classes: 
  - VDKXDatabase 
  - VDKXTable
  - VDKXTableIndex

  \section manual User notes
  Since VDKXDatabase, VDKXTable and VDKXTableIndex are
  subclasses of xdb object user should have some knowledge on
  using xdb, refer to xdb documentation for further informations 
  and behaviours. More informations on xdb can be achieved visiting
  http://xdb.sourceforge.net

  \section  general General considerations
  As usual in VDK all vdkxdb objects should be constructed
  on the heap with new operator. An exception is VDKXdb class that can be
  a static/automatic object.
  Is not necessary to explicitely close and destroy VDKXTable and 
  VDKXTableIndex since when a VDKXDatabase object is destroyed all associated 
  tables and indices  will be flushed, closed and destroyed as well.
  All new'ed vdxdb objects will be automatically deleted before program
  termination or with GC.
  
  \author
  \arg Mario Motta  mmotta@guest.net
  \par Note
  This manual is a living document and changes with the development of VDK.
  I hope that the hints and tips will be useful. More information can be 
  obtained from the examples source files in ./testvdk. Comments and 
  suggestions are welcome.

  \par Copyright 1998,1999,2000 Mario Motta and VDK Team
  Permission is granted to make and distribute verbatim copies of this manual
  provided that the copyright notice and this permission notice are preserved 
  in all copies. Permission is granted to copy and distribute modified 
  version, including translation in other languages, of this manual under 
  the conditions for verbatim copying, provided that the entire resulting 
  derived work is distributed under the terms of a permission notice 
  identical to this one. Any translated version of this permission notice 
  must have been approved by Mario Motta. 
 */
#ifndef _vdkxdb_support_h
#define _vdkxdb_support_h

#include <vdkxdb/vdkxdb.h> 
#include <vdkxdb/vdkxtable.h>
#include <vdkxdb/vdkxentry.h>
#include <vdkxdb/vdkxcheckbutton.h>
#include <vdkxdb/vdkxclist.h>
#include <vdkxdb/vdkxmemo.h>

#endif
