/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.5.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vdkb/vdkeditor.h>
#include <vdk/colors.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb.h>

//
VDKEditor::VDKEditor(VDKForm* owner, bool editable):
  VDKSyntaxEditor(owner)
{ 
  Editable = editable ? true : false;
}
/*
 */
VDKEditor::~VDKEditor()
{
}

/*
 */
void  VDKEditor::SetFont(VDKFont* font)
{
if(font)
  VDKExText::SetFont(font);
} 
/*
SYNTAX STUFF
 */
void
VDKEditor::InstallSyntaxTable (VDKColor* comment_color,
			       VDKFont*  comment_font,
			       VDKColor* string_const_color,
			       VDKFont*  string_const_font,
			       VDKColor* chars_const_color,
			       VDKFont*  chars_const_font)
{
  
  AddSyntax("C-comment","/\\*","\\*/",comment_font,comment_color,NULL);
  AddSyntax("C++-comment","//","\n",comment_font,comment_color,NULL);
  AddSyntax("string","\"","\"",string_const_font,string_const_color,NULL);
  AddSyntax("chars","'","'",chars_const_font,chars_const_color,NULL);
  
}

/*
 */
void 
VDKEditor::InstallPatternTable(VDKColor *key_color,
			       VDKFont  *key_font,
			       VDKColor *preprocess_color)
{
  AddPattern("vdk1",
    "\\b\\(do\\|while\\|for\\|if\\|else\\|bool\\|template\\|continue\\)\\b",
    key_font,key_color,NULL);
  AddPattern("vdk2",
    "\\b\\(case\\|switch\\|break\\|new\\|delete\\|default\\|return\\)\\b",
    key_font,key_color,NULL);
  AddPattern("vdk3",
    "\\b\\(char\\|short\\|int\\|long\\|float\\|double\\|unsigned\\|true\\|false\\)\\b",
    key_font,key_color,NULL);
  AddPattern("vdk4",
    "\\b\\(this\\|void\\|struct\\|union\\|enum\\|const\\|static\\)\\b",
    key_font,key_color,NULL);
  AddPattern("vdk5",
    "\\b\\(class\\|public\\|protected\\|private\\|friend\\|dynamic_cast\\)\\b",
    key_font,key_color,NULL);
  AddPattern("vdk6",
    "^#[ \t]*\\(include\\|undef\\|if\\|ifdef\\|ifndef\\|else\\|define\\|endif\\)\\b",
    key_font,preprocess_color,NULL);
  AddPattern("vdk7",
    "\\b\\(DEFINE_SIGNAL_MAP\\|ON_SIGNAL\\|END_SIGNAL_MAP\\|DECLARE_SIGNAL_MAP\\)\\b",
    key_font,key_color,NULL);
  AddPattern("vdk8",
    "\\b\\(DECLARE_SIGNAL_LIST\\|DEFINE_SIGNAL_LIST\\)\\b",
    key_font,key_color,NULL);
  AddPattern("vdk9",
    "\\b\\(DECLARE_EVENT_LIST\\|DEFINE_EVENT_LIST\\)\\b",
    key_font,key_color,NULL);
  AddPattern("vdk10",
    "\\b\\(\\<VDK[A-Z][A-Za-z]*\\)\\b",
    key_font,key_color,NULL);
  AddPattern("vdk11",
    "\\b\\(SignalConnect\\|EventConnect\\)\\b",
    key_font,key_color,NULL);
  AddPattern("C++-funcs",
   "^\\(\\([a-zA-Z_][a-zA-Z0-9_]*\\)::\\([~a-zA-Z_][a-zA-Z0-9_]*\\)\\)[ \t]*(",
    key_font,key_color,NULL);

}
