/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * December 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb_text.h>
#include <gdk/gdkkeysyms.h>
#include <vdkb/vdkb_utils.h>
#include <stdio.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <vdkb/vdkb.h>
#include <vdkb/vdkb_utils.h>

#define vdkeCourier "-*-courier-medium-r-*-*-12-*-*-*-*-*-*-*"
#define vdkeCourierBold "-*-courier-bold-r-*-*-12-*-*-*-*-*-*-*"
#define vdkeCourierSlant "-*-courier-medium-o-*-*-12-*-*-*-*-*-*-*"

DEFINE_SIGNAL_LIST(VDKBText,VDKEditor);
DEFINE_EVENT_LIST(VDKBText, VDKEditor);


//===================================
const unsigned int guessOffset = 1000;
static char buff[256];
extern VDKBuilder* TheApp;
extern char *source_prompts[];
/*
void
VDKBText::DeleteText(GtkWidget* wid, int start, int end, void* gp)
{

  VDKBText* text = reinterpret_cast<VDKBText*>(gp);
  text->Changed = true;
}

void
VDKBText::InsertText(GtkWidget* wid,
		     const char* buf,
		     int len, int pos, void* gp)

{

}

static void TextChanged(GtkWidget* wid, void* gp)
{
  VDKBText* text = reinterpret_cast<VDKBText*>(gp);
  text->Changed = true;
}
*/
/*
*/
bool
VDKBText::KeyEventAfter(VDKObject *sender,GdkEvent *event)
{
  GdkEventKey *ev = (GdkEventKey*) event;
  // dispatch directly to text parent (VDKBnotebook)
  if(Changed)
      Parent()->SignalEmit("text_changed");
  // others keys:
  switch(ev->keyval)
    {
    case GDK_Up:
    case GDK_Down:
    case GDK_Page_Up:
    case GDK_Page_Down:
      CurrentLine((int) Line+1);
      Parent()->SignalEmit("line_changed");
      break;
    case GDK_F3:
    case GDK_F20:
      Parent()->SignalEmit("repeat_search_text");
      break;
    }
  return true;
}
/*
 */
bool
VDKBText::KeyEventBefore(VDKObject *sender,GdkEvent *event)
{
    GdkEventKey *ev = (GdkEventKey*) event;
    bool isAlt = false;
    //    Action* action = NULL;
    if(! Editable)
	return true;
    switch(ev->keyval)
	{
	case GDK_F16:
	case GDK_F4:
	  if (! Undo())
	    Parent()->SignalEmit("no_more_undo");
	  break;

	case GDK_BackSpace:
	    isAlt = ev->state & GDK_MOD1_MASK;
	    if(isAlt && ! Undo())
		  Parent()->SignalEmit("no_more_undo");
	    break;
	
	case GDK_F5:
	  /*
	    printf("\nsorry, redo not yet implemented"); 
	    fflush(stdout);
	  */
      break;

	case GDK_F6:
	  if(Hilite)
	    Parent()->SignalEmit("hilite_text");
	  break;

	case GDK_F1:
	  Parent()->SignalEmit("editor_help");
	  break;
	default:	
	    break;
	}
    return true;
}
/*
*/
bool
VDKBText::ButtonPressEvent(VDKObject* , GdkEvent* )
{
  char* p = Filename();
  if(p)
    {
     struct stat finfo;
     if(!stat(p,&finfo))
       {
       if( (Mtime() != 0) &&
	  (finfo.st_mtime !=  Mtime()) )
	   {
	     sprintf(buff,"%s\n%s",p,_("Changed from disk, reload ?"));
	     if(Owner()->Application()
		->MessageBox(APPNAME,
			     buff,
			     MB_ICONQUESTION|MB_YESNO,
			     _(user_messages[user_ok]),
			     _(user_messages[user_no]))	== IDYES)
	       Load(p);
	   }
       else
	 {
	   CurrentLine(Line+1);
	   Parent()->SignalEmit("line_changed");
	 }
       }
    }
  return true;
}
/*
pop menu
*/
bool
VDKBText::ButtonReleaseEvent(VDKObject* sender, GdkEvent *event)
{
  // casts to button event
  GdkEventButton *ev = (GdkEventButton*) event;
  // pops menu on right button pressed
  if(ev->button == 3)
    {
      Parent()->SignalEmit("pop_menu");
      return TRUE;
    }
  return true;
}

/*
actually unused
bool
VDKBText::MappedEvent(VDKObject* sender, GdkEvent *event)
{

  if(!mapped)
    {
      mapped = true;
      Pointer = 0;
    }
  return true;
}
*/
/*
*/
bool
VDKBText::Realized(VDKObject* sender)
{
  char* cc_ext   = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  char* h_ext    = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  // this flag is set to false by constructor
  // so only one realized signal is catched
  if(!realized)
    {
      SetStyle();
      // load from file if found
      // and hilites it
      if(!access(Filename(),F_OK) && Load(Filename()) && Hilite)
	Syntax = true;
      // create a new unit file if not empty filename
      else if(*Filename())
	{
	  // is a new unit file ?
	  Changed = true;
	  char *local = new char[strlen(Filename())+1];
	  strcpy(local,Filename());
	  char* ext = get_extension(local);
	  // advance to jump '.'
	  if(ext)
	    {
	      *ext = '\0';
	      ext++;
	      // is a .cc file ?
	      if(!strcmp(ext,cc_ext))
		{
		  sprintf(buff,"#include <%s.h>\n",local);
		  TextInsert(buff);
		  sprintf(buff,source_prompts[1], SOURCE_END_MARK, local, cc_ext);
		  TextInsert(buff);
		}
	      // is .h file ?
	      else if(!strcmp(ext,h_ext))
		{
		  TextInsert("//\n");
		  sprintf(buff,"#ifndef _%s_h\n",local);
		  TextInsert(buff);
		  sprintf(buff,"#define _%s_h\n",local);
  		  TextInsert("// put your code below here\n");
		  TextInsert(buff);
		  TextInsert("\n\n");
  		  TextInsert("//\n");
		  TextInsert("#endif\n");
		  sprintf(buff,source_prompts[1], SOURCE_END_MARK, local, h_ext);
		  TextInsert(buff);
		}
	    }
	  delete[] local;
	}
      realized = true;
      Pointer = 0;
    }
 return true;
}

/*
  set syntax colouring style
*/
void
VDKBText::SetStyle()
{
  bool hilite = Hilite;
  char* font = (char*) VDKBuilder::ideDefaults.editor.font;
  if(font)
    {
      VDKFont* edit_font = new VDKFont(this,font);
      if( *edit_font != (GdkFont*) NULL)
	Font = edit_font;
      else
	edit_font->Destroy();
    }
  char* bg_color = (char*) VDKBuilder::ideDefaults.editor.bg;
  if(bg_color)
    NormalBackground = VDKRgb(bg_color);

  char* fg_color = (char*) VDKBuilder::ideDefaults.editor.fg;
  if(fg_color)
	  Foreground = VDKRgb(fg_color);
  VDKColor *comment_color = new VDKColor(this,
		(char*) VDKBuilder::ideDefaults.editor.comment_color);
  VDKFont  *comment_font  = new VDKFont(this,
		(char*) VDKBuilder::ideDefaults.editor.comment_font);
  VDKColor *string_const_color = new VDKColor(this,
		(char*) VDKBuilder::ideDefaults.editor.string_const_color);
  VDKFont  *string_const_font = new VDKFont(this,
		(char*) VDKBuilder::ideDefaults.editor.string_const_font);
  VDKColor *chars_const_color = new VDKColor(this,
		(char*) VDKBuilder::ideDefaults.editor.chars_const_color);
  VDKFont  *chars_const_font = new VDKFont(this,
		(char*) VDKBuilder::ideDefaults.editor.chars_const_font);
  InstallSyntaxTable (comment_color,
			  comment_font,
			  string_const_color,
			  string_const_font,
			  chars_const_color,
			  chars_const_font);

  VDKColor* siena = new VDKColor(this,
			(char*) VDKBuilder::ideDefaults.editor.key_color);
  VDKFont*  bold = new VDKFont(this,
	       (char*) VDKBuilder::ideDefaults.editor.key_font);
  VDKColor* forestg = new VDKColor(this,
			(char*) VDKBuilder::ideDefaults.editor.preprocess_color);
  InstallPatternTable(siena, bold,forestg);
}

//////////////////////////////////////
/*
 */
VDKBText::VDKBText(VDKForm* owner, bool editable, char* filename ):
  VDKEditor(owner,editable),filename(filename),
  CurrentLine("CurrentLine",this,1)
{
  mapped = false;
  lastGuessed = 0;
  realized = false;
  Hilite = false;
  // set max undo
  MaxUndo = 512;
  // setup event handler to intercept key press
  // intercepts undo/redo, stops signal in this case
  // and process undo/redo
  // "true" as last arg means connect after (default false)
  EventConnect("key_press_event",&VDKBText::KeyEventAfter,true);
  EventConnect("button_press_event",&VDKBText::ButtonPressEvent,true);
  EventConnect("button_release_event", &VDKBText::ButtonReleaseEvent,true);
  // EventConnect("map_event",&VDKBText::MappedEvent,true);
  SignalConnect("realize",&VDKBText::Realized,true,true);
  EventConnect("key_press_event",&VDKBText::KeyEventBefore);
  /*
  gtk_signal_connect(GTK_OBJECT(WrappedWidget()),"delete_text",
		     GTK_SIGNAL_FUNC(VDKBText::DeleteText),this);
  gtk_signal_connect(GTK_OBJECT(WrappedWidget()),"insert_text",
		     GTK_SIGNAL_FUNC(VDKBText::InsertText),this);
  gtk_signal_connect(GTK_OBJECT(WrappedWidget()),"changed",
		     GTK_SIGNAL_FUNC(::TextChanged),this);
  */
  // load file last modification time
  if(filename)
    {
     struct stat finfo;
     if(!stat(filename,&finfo))
       mtime = finfo.st_mtime;
     else
       mtime = 0;
    }
  else
    mtime = 0;
}
/*
 */
int
VDKBText::Save(char* filename)
{

  int result = FALSE;
  if(filename)
    {
      result = VDKExText::SaveToFile(filename);
      if(result)
	{
	  struct stat finfo;
	  if(!stat(filename,&finfo))
	    mtime = finfo.st_mtime;
	  else
	    mtime = 0;
	}
      else
	mtime = 0;
    }
  else
    mtime = 0;
  return result;
}
/*
 */
int
VDKBText::Load(char* filename)
{
  int result = VDKExText::LoadFromFile(filename);
  /*
    make a back-up file, using filename+~
  */
  VDKString Yes = CHECK_YES;
  if(result && filename &&
     (VDKBuilder::ideDefaults.editor.backup == Yes) )
    {
      char* ext = get_extension(filename);
      if(ext && (!strchr(ext,'~')))
	{
	  int success = 0;
	  VDKString backup = filename;
	  backup += "~";
	  success = VDKExText::SaveToFile((char*) backup);
	  if(! success)
	    {
	      sprintf(buff,_("Couldn't make %s backup file"),filename);
	      TheApp->MessageBox(
				 APPNAME,
				 buff,
				 MB_ICONINFORMATION|MB_OK,
				 _(user_messages[user_ok]),
				 NULL,
				 5000);
	    }
	}
    }

  if(result && filename)
    {
      struct stat finfo;
      if(!stat(filename,&finfo))
	mtime = finfo.st_mtime;
      else
	mtime = 0;
    }
  else
    mtime = 0;
  return result;
}
///////////////////////////////////////
/*
 */
VDKBText::~VDKBText()
{
  //action_stack.flush();
}

/*
 */
char* VDKBText::ShortName()
{
  char* p = (char*) filename;
  char* s = get_shortfilename(p);
  return s ? s : p;
}
/*
 */
char* VDKBText::Extension()
{
char* p = (char*) filename;
return get_extension(p);
}
/*
 */
char* VDKBText::Filename(char* name)
{
if(name)
  filename = name;
return (char*) filename;
}

bool
VDKBText::GoToLine(int line)
{
  Line = line-1;
  return true;
}
/*
 */
void
VDKBText::ScrollTo(int pos)
{
  Pointer = pos;
}

int
VDKBText::Search(char* st,int from, bool select, bool bell)
{
char* buf = GetChars(from,-1);
int pos = -1;
if(! buf)
  return 0;
char* p = strstr(buf,st);
if(p)
  {
    pos = from + (p-buf);
    ScrollTo(pos);
    Pointer = pos;
    if(select)
	gtk_editable_select_region (GTK_EDITABLE (WrappedWidget()), pos,
				pos + strlen (st));
  }
else if(bell)
  gdk_beep();
g_free(buf);
return pos;
}


