/*
 * ===========================
 * VDK Visual Development Kit
 * Version 1.0
 * Revision 7
 * January 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
/*
OVERVIEW
--------
This file has the aim to be a footstep that shows how to make a 
gtk+ widget wrapper in vdk.
We choose here to wrap GtkExTextHighlight widget.
*/

#ifndef VDKSYNTED_H
#define VDKSYNTED_H
#include <vdkb/vdkextext.h>
#include <vdk/value_sem_list.h>

class VDKSyntaxEditor;
/*
    syntax-pattern table
*/
class 
VDKHighlightTable 
{
        friend class VDKSyntaxEditor;
    protected:
        GList* list;
        GdsEditorHighlightTable* table;
        VDKSyntaxEditor * owner;
        VDKHighlightTable(VDKSyntaxEditor* owner);
        virtual ~VDKHighlightTable();
};
/*
    pattern table subclass
*/
class 
VDKPatternTable: public VDKHighlightTable
{
        friend class VDKSyntaxEditor;
    protected:
        VDKPatternTable(VDKSyntaxEditor* owner);
        virtual ~VDKPatternTable() {}
        void Add( char *name,
                  char *regex,
                  VDKFont* font,
                  VDKColor* fg,
                  VDKColor* bg);
        bool Install();
};

/*
    syntax table subclass
*/
class
VDKSyntaxTable: public VDKHighlightTable
{
        friend class VDKSyntaxEditor;
    protected:
        VDKSyntaxTable(VDKSyntaxEditor* owner);
        virtual ~VDKSyntaxTable() {}
        void Add( char *name,
                  char *start,
                  char *end,
                  VDKFont* font,
                  VDKColor* fg,
                  VDKColor* bg);
        bool Install();
};

/*
    Syntax editor class
*/
class VDKSyntaxEditor: public VDKExText
{
 protected:
  VDKPatternTable* pTable;
  VDKSyntaxTable*  sTable;
  GtkExTextProperty *CurrentProp;
  char* ProcessMark(void);
  bool MakeCompletion(char* word);
  char* MakeTip(char*);
  bool WriteTemplate(char* word);
  void ShowTipWindow(char* word);
  void AddToken();
  int ShowParenMatch(char keyval,GtkWidget* widget,bool insert);
 public:

  VDKSyntaxEditor(VDKForm* owner);
  ~VDKSyntaxEditor();
  void AddPattern(char *name,
		  char *regex, 
		  VDKFont* font,
		  VDKColor* fg,
		  VDKColor* bg)
    { pTable->Add(name,regex,font,fg,bg); }
  void AddSyntax(char *name,char *start, char* end, 
		 VDKFont* font,VDKColor* fg,VDKColor* bg)
    { sTable->Add(name,start, end,font,fg,bg); }
  void ClearSyntaxAndPatternsTables();
  VDKString UserBuffer;
  // properties section
 public:
  VDKReadWriteValueProp<VDKSyntaxEditor,bool>       Syntax;
  VDKReadWriteValueProp<VDKSyntaxEditor,int>        TabSpaces;
  //  bool Changed;
  // setting gettin function
  protected:
  void SetSyntax(bool flag);
  // signal section
 protected:
  virtual void LocalConnect();
  static int TabHandler (GtkWidget *widget,
			 GdkEvent *ev,
			 gpointer gp);
  static void MarkHandler (GtkWidget *widget,
			   GtkExTextProperty *prop,
			   gpointer gp);
  static int OnKeyRelease (GtkWidget *widget,
                             GdkEvent *ev,
		       gpointer gp);
  void DefaultIndent(void);
  void NaiveIndent(void);
  void NormalTab(void);
};

/*
showed hints forms
*/
class Tipwin: public VDKForm
{
  VDKLabel*  label;  
  char* tip;
public:
  Tipwin(VDKForm* owner, char* tip):
    VDKForm(owner,NULL,v_box,GTK_WINDOW_POPUP),tip(tip)
    {}
  ~Tipwin() {}
  void Setup(void);

};

#endif
