/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 1.0.3
 * March 1999, November 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_widpopmenu_h
#define _vdkb_widpopmenu_h

#include <vdkb/vdkb_evcontain.h>
#include <vdkb/vdkb_locale.h>
#include <vdk/vdk.h>
#include <vdkb/vdkb_widclip.h>


class VDKBWidgetPopMenu: public VDKMenu
{
 protected:
  VDKMenuItem *setsize,*delwidget,*widprops,
    *selectparent,*cutwidget,*pastewidget,*pasteothers,
    *copywidget; 
  VDKObject *parent_widget;
  bool DelWidget(VDKObject*);
  bool SetWidgetSize(VDKObject*);
  bool SelectParentContainer(VDKObject*);
  bool Cut(VDKObject*);
  bool Copy(VDKObject*);
  bool Paste(VDKObject*);
  bool PasteOthers(VDKObject*);
  bool MakeInspector(VDKObject*);
  
 public:
  VDKBWidgetPopMenu(VDKObject* widget);
  ~VDKBWidgetPopMenu() {}
  void Popup(guint button = 0,  guint32 activate_time = 0);
  DECLARE_SIGNAL_LIST(VDKBWidgetPopMenu);
};

/*
 */
class VDKBContainerPopMenu: public VDKMenu
{
 protected:
  VDKObject *parent_widget;
  VDKMenuItem *cutwidget,*pastewidget,*pasteothers,
    *copywidget; 
 public:
  VDKBContainerPopMenu(VDKObject* widget);
  ~VDKBContainerPopMenu() {}
  void Popup(guint button = 0,  guint32 activate_time = 0);
  bool Paste(VDKObject*);
  void Setup();
  bool Cut(VDKObject*);
  bool PasteOthers(VDKObject*);
  bool Copy(VDKObject*);
  DECLARE_SIGNAL_LIST(VDKBContainerPopMenu);
};

#endif
