/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_radiobutton_h
#define _vdkb_radiobutton_h
#include <vdk/vdk.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_widpopmenu.h>
#include <vdkb/vdkb_checkbutton.h>

class VDKBGuiForm;
class VDKBParser;
class VDKBRadioButton: public VDKBCheckButton
{

 public:

  static int OnButtonEvent(GtkWidget *w, GdkEvent* event, void* o);
  static int OnEnterEvent(GtkWidget *w, GdkEvent* event, void* o);
  static int OnLeaveEvent(GtkWidget *w, GdkEvent* event, void* o);

  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  void WriteOnFrm(FILE* fp, VDKBObject* parentobj);
  VDKBRadioButton(char* name,VDKForm* owner,
		  char* label, char* tip = NULL);
  virtual ~VDKBRadioButton() {}
  virtual int Type() { return vdkbclass_radiobutton; }
  virtual char* VDKName() { return "VDKRadioButton"; }
  virtual int isA() { return vdkbclass_radiobutton; }
};
#endif
