/*  Higlight code	
*  Copyright (C) 1999 by:
*Mikael Hermansson <mikeh@bahnhof.se>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef HIGLIGHT_H__
#define HIGLIGHT_H__
#ifdef __cplusplus
extern "C" {
#endif
#include "vdk/gtksourcetag.h"

#define GTK_TYPE_SOURCE_BUFFER                  (gtk_source_buffer_get_type ())
#define GTK_SOURCE_BUFFER(obj)                  (GTK_CHECK_CAST ((obj), GTK_TYPE_SOURCE_BUFFER, GtkSourceBuffer))
#define GTK_SOURCE_BUFFER_CLASS(klass)          (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_SOURCE_BUFFER, GtkSourceBufferClass))
#define GTK_IS_SOURCE_BUFFER(obj)               (GTK_CHECK_TYPE ((obj), GTK_TYPE_SOURCE_BUFFER))
#define GTK_IS_SOURCE_BUFFER_CLASS(klass)       (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_SOURCE_BUFFER))

#define UNDO_TYPE_INSERT_TEXT 1
#define UNDO_TYPE_INSERT_PIXBUF 2
#define UNDO_TYPE_REMOVE_RANGE 3

typedef struct _UndoObject
{
  gint type;
  gint offset;
  gint len;
  gpointer data;
}  UndoObject ;

typedef struct _GtkSourceBuffer
{
  GtkTextBuffer TextBuffer;
  gint highlight :1;
  gint check_brackets :1;

  gint refresh_start;
  gint refresh_length;
  Regex reg_syntax_all;
  GtkTextTag *exselect_tag;
  GtkTextMark *mark;
  
  gint redo_count; /* TODO: implement multiple redo??? */
  gint undo_count;
  gint undo_max;

  GPtrArray *undo_processing_array;
  GPtrArray *redo_array;

  GList *undo_list;
  GList *undo_current;
} GtkSourceBuffer;

typedef struct _GtkSourceBufferClass
{
  GtkTextBufferClass parent_class;

} GtkSourceBufferClass;

GtkTextBuffer* gtk_source_buffer_new(GtkTextTagTable *table);

/* pass created tables to widget */

gint gtk_source_buffer_regex_search(const char *text,gint pos,Regex *regex,gboolean forward,GtkSourceBufferMatch *m);
gint gtk_source_buffer_regex_match(const char *text,gint pos,gint end,Regex *regex);

void gtk_source_buffer_set_check_brackets(GtkSourceBuffer *text,gboolean check);
void gtk_source_buffer_set_highlight(GtkSourceBuffer *text,gboolean set);

GtkSyntaxTag* gtk_source_buffer_iter_has_syntax_tag (GtkTextIter *text);
gint gtk_source_buffer_get_tag_start (GtkTextIter *iter);
gint gtk_source_buffer_get_tag_end (GtkTextIter *iter);

GList * gtk_source_buffer_get_tags(GtkSourceBuffer *buf);
GList* gtk_source_buffer_get_first_pattern_tag (GtkSourceBuffer *buf);
GList* gtk_source_buffer_get_next_pattern_tag (GList *list);
GList* gtk_source_buffer_get_first_syntax_tag (GtkSourceBuffer *buf);
GList* gtk_source_buffer_get_next_syntax_tag (GList *list);
gint gtk_source_buffer_get_n_syntax_tag(GtkSourceBuffer *buf);

gchar *gtk_source_buffer_convert_to_html(GtkSourceBuffer *buf, const gchar*htmltitle);
gboolean gtk_source_buffer_find_bracket_match(GtkTextIter *orig);

void gtk_source_buffer_clear_undo_stack(GtkSourceBuffer *buf);
void gtk_source_buffer_set_max_undo_stack(GtkSourceBuffer *buf, gint max);
void gtk_source_buffer_undo(GtkSourceBuffer *buf);
void gtk_source_buffer_redo(GtkSourceBuffer *buf);
gint gtk_source_buffer_get_undo_count(GtkSourceBuffer *buf);
gint gtk_source_buffer_get_redo_count(GtkSourceBuffer *buf);


GtkType gtk_source_buffer_get_type(void);

#ifdef __cplusplus
}
#endif
#endif 
