/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * november 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _customtreecompo_h
#define _customtreecompo_h
#include <vdk/vdk.h>
class TreeComponent: public VDKBox
{
  VDKCustomTree *tree; 
  VDKCustomButton *remove,*build,*clear;
  VDKCustomButton *expand;
 public:
  TreeComponent(VDKForm* owner):
    VDKBox(owner)  {}
  ~TreeComponent() { }
  void Setup();
  bool ShowSelection(VDKObject*);
  bool ShowExtendedSelection(VDKObject* obj, GdkEvent*);
  bool ClearTree(VDKObject* obj);
  bool RemoveSelection(VDKObject*);
  bool BuildTree(VDKObject*);
  bool ExpandNode(VDKObject* );
  DECLARE_SIGNAL_LIST(TreeComponent);
  DECLARE_EVENT_LIST(TreeComponent);
  DECLARE_SIGNAL_MAP(TreeComponent);
};
#endif
