/*
file: signalwin.cc
*/
#include "signalwin.h"
static bool disabled1 = false;
static bool disabled2 = false;
/*   
signals map  
*/  
DEFINE_SIGNAL_MAP(SignalWin,VDKForm)
  ON_SIGNAL(button,clicked_signal,ButtonClicked),
  ON_SIGNAL(button,leave_signal,OnLeaveButton),
  ON_SIGNAL(cb1,toggled_signal,OnToggleCb1),
  ON_SIGNAL(cb2,toggled_signal,OnToggleCb2),
  ON_SIGNAL(button,clicked_signal,ButtonClicked1)
END_SIGNAL_MAP 
/* 
event map  
*/
DEFINE_EVENT_MAP(SignalWin,VDKForm)
  ON_EVENT(pixmap,double_click_event,OnPixmapDoubleClick),
  ON_EVENT(pixmap,double_click_event,OnPixmapDoubleClick1)
END_EVENT_MAP   
/*
 */
void SignalWin::Setup()
{
VDKBox* box = new VDKBox(this); 
VDKBox* vbox = new VDKBox(this);
label = new VDKLabel(this,"This is a label");
pixmap = new VDKPixmap(this,
		       "./pixmap/linuxGirl.xpm",
		       "by courtesy of B.Bellamy");
vbox->Add(label);
vbox->Add(new VDKSeparator(this,h_separator));
vbox->Add(pixmap);
box->Add(vbox);

box->Add(new VDKSeparator(this,h_separator));

VDKTable* table = new VDKTable(this,2,2);
cb1 = new VDKCheckButton(this,
			 (char *)(disabled1 ? // ionutz
			 "Dbl click on pixmap disabled":
			 "Dbl click on pixmap enabled"));
cb2 = new VDKCheckButton(this,
			 (char *)(disabled2 ? // ionutz
			 "Signal on button disabled":
			 "Signal on button enabled"));
button = new VDKLabelButton(this,"A Button");
table->Add(cb1,0,1,0,1);
table->Add(cb2,0,1,1,2);
table->Add(button,1,2,1,2);
box->Add(table);

Add(box);
}
/*
 */
bool SignalWin::ButtonClicked(VDKObject*)
{
label->Caption = "clicked_signal signalled";
printf("\nclicked_signal first callback");
fflush(stdout);
return true;
}
bool SignalWin::ButtonClicked1(VDKObject*)
{
label->Caption = "clicked_signal signalled";
printf("\nclicked_signal second callback");
fflush(stdout);
return true;
}

bool SignalWin::OnLeaveButton(VDKObject*)
{
label->Caption = "";
return true;
}
/*
 */
bool SignalWin::OnPixmapDoubleClick(VDKObject*,GdkEvent*)
{
label->Caption = "double_click_event on pixmap";
printf("\ndouble_click_even first callback");
fflush(stdout);
return true;
}
/*
 */
bool SignalWin::OnPixmapDoubleClick1(VDKObject*,GdkEvent*)
{
label->Caption = "double_click_event on pixmap";
printf("\ndouble_click_even second callback");
fflush(stdout);
return true;
}
/*
 */
bool SignalWin::OnToggleCb1(VDKObject*)
{
  static int slot = -1;
  disabled1 = cb1->Checked;
  if(disabled1)
    slot = EventDetach(pixmap,double_click_event);
  else if(slot != -1)
    EventAttach(slot);
  // ionutz
  cb1->Caption = (char *)(disabled1 ? 
	       "Dbl click on pixmap disabled (first cb)" :
	       "Dbl click on pixmap enabled") ;  
  return true;
}
/* 
 */
bool SignalWin::OnToggleCb2(VDKObject*)
{
  static int slot = -1;
  disabled2 = cb2->Checked;
  if(disabled2)
    slot = SignalDetach(button,clicked_signal);
  else if(slot != -1)
    SignalAttach(slot);
  cb2->Caption = (char *)(disabled2 ? // ionutz
	       "Signal on button disabled (first cb) " :
	       "Signal on button enabled") ;  
  return true;
}





