/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  TOOLBAR_H
#define  TOOLBAR_H


#include <vdk/vdkprops.h>
#include <vdk/widcontain.h>
#include <gtk/gtkenums.h>

class VDKForm;
class VDKBox;


typedef VDKList<VDKObject>           ToolWidgetList;
typedef VDKListiterator<VDKObject>   ToolWidgetListIterator;
typedef VDKList<GtkWidget>           GtkWidgetList;
typedef VDKListiterator<GtkWidget>   GtkWidgetListIterator;
/*!
  \class VDKToolbar
  \brief Provides a GtkToobar wrapper
  \par SIGNALS
  \arg \b clicked_signal received whenever a tool button was pressed
  \par EXAMPLES
  In ./testvdk/tbarwin.cc
 */
class VDKToolbar : public VDKObjectContainer 
{

  static void ButtonSignal(GtkWidget *wid, gpointer gp);
  ToolWidgetList toolWidgets;
  GtkWidgetList  widgets;
  VDKList<VDKObject>           tool_buttons;

public:
    // properties
  /*!
    Returns a list of VDKObject* other than buttons inserted into toolbar
   */
  VDKReadOnlyValueProp<VDKToolbar, ToolWidgetList*>  WidgetList;
  /*!
    Returns a list of GtkWidget* inserted into toolbar
   */
  VDKReadOnlyValueProp<VDKToolbar, GtkWidgetList*>   ButtonList;
  /*!
    Returns ordinal number of pressed button after a clicked_signal
  */
  VDKReadOnlyValueProp<VDKToolbar, int>              ButtonPressed;
  /*!
    Returns toolbar orientation, defaults to GTK_ORIENTATION_HORIZONTAL.
    Can be:
    \arg \b GTK_ORIENTATION_HORIZONTAL
    \arg \b GTK_ORIENTATION_VERTICAL
  */
  VDKReadWriteValueProp<VDKToolbar, GtkOrientation>  Orientation;
  /*!
    Sets/gets toolbar style, defaults to GTK_TOOLBAR_ICONS.
    Can be:
    \arg \b GTK_TOOLBAR_ICONS shows icons only
    \arg \b GTK_TOOLBAR_TEXT shows labels only
    \arg \b GTK_TOOLBAR_BOTH shiws both label and icons
  */
  VDKReadWriteValueProp<VDKToolbar, GtkToolbarStyle> Style;
  /*!
    Sets/gets toolbar space style,defaults to: GTK_TOOLBAR_SPACE_LINE. 
    Can be:
    \arg \b GTK_TOOLBAR_SPACE_EMPTY
    \arg \b GTK_TOOLBAR_SPACE_LINE
   */
  VDKReadWriteValueProp<VDKToolbar, GtkToolbarSpaceStyle> SpaceStyle;
  /*!
    Sets/gets border flag, defaults to true.
   */
  VDKReadWriteValueProp<VDKToolbar, bool>            Borderless;
  /*!
    Sets/gets button relief, defaults to: GTK_RELIEF_NONE.
    Can be:
    \arg \b GTK_RELIEF_NORMAL
    \arg \b GTK_RELIEF_HALF
    \arg \b GTK_RELIEF_NONE
   */
  VDKReadWriteValueProp<VDKToolbar, GtkReliefStyle>  Relief;
  /*!
    Sets/gets spacing between buttons.
   */
  VDKReadWriteValueProp<VDKToolbar, int>             Spacing;
    //
  /*!
    Constructor.
    \param owner
    \param orientation see Orientation() property
   */
    VDKToolbar(VDKForm* owner, 
	       GtkOrientation orientation = GTK_ORIENTATION_HORIZONTAL);
    /*!
      Destructor
     */
    virtual ~VDKToolbar() {}
    /*!
      Adds an object to toolbar
      \param obj object to be added
      \param others ignored
     */
    virtual void Add(VDKObject* obj, int , int , int , int )
      { AddWidget(obj); }
    /*!
      Adds an object to toolbar
      \param obj object to be added
      \param tip
     */
    void AddWidget(VDKObject* widget, char* tip = NULL);
    /*!
      Adds a button to toolbar
      \param pixdata
      \param tip assigned tip
      \param text assigned label
     */
    void AddButton(char** pixdata,
                   char* tip = NULL,
                   char* text = NULL);
    /*!
      Adds a button to toolbar
      \param pixfile
      \param tip assigned tip
      \param text assigned label
     */
    void AddButton(char* pixfile,
                   char* tip = NULL,
                   char* text = NULL);
    /*!
      Add a space to toolbar
    */
    void AddSpace() {
        gtk_toolbar_append_space(GTK_TOOLBAR(widget));
    }

    void SetOrientation( GtkOrientation orientation) {
        gtk_toolbar_set_orientation(GTK_TOOLBAR(widget),orientation);
    }

    void SetStyle(GtkToolbarStyle style) {
        gtk_toolbar_set_style(GTK_TOOLBAR(widget),style);
    }

    void SetBorderless(bool flag) {
        if(!flag)
            gtk_toolbar_set_button_relief (GTK_TOOLBAR (widget), GTK_RELIEF_NORMAL);
        else
            gtk_toolbar_set_button_relief (GTK_TOOLBAR (widget), GTK_RELIEF_NONE);
    }

    void SetSpacing(int s) {
        gtk_toolbar_set_space_size(GTK_TOOLBAR(widget),s);
    }

    void SetRelief(GtkReliefStyle style) {
        gtk_toolbar_set_button_relief (GTK_TOOLBAR(widget), style);
    }

    GtkReliefStyle GetRelief () {
        return gtk_toolbar_get_button_relief (GTK_TOOLBAR(widget));
    }

    void SetSpaceStyle(GtkToolbarSpaceStyle style) {
        gtk_toolbar_set_space_style (GTK_TOOLBAR (widget), style);
    }

    GtkToolbarSpaceStyle GetSpaceStyle() {
        return GTK_TOOLBAR(widget)->space_style;
    }
    
    VDKObject* operator[](int ndx) {
        if( (ndx >= 0) && (ndx < tool_buttons.size()) )
            return tool_buttons[ndx];
        else
            return NULL;
    }
};


#endif









