#include "cfloatspinbox.h"

/** */
CFloatSpinBox::CFloatSpinBox( QWidget * parent, const char * name )
	: QSpinBox(parent,name)
{
}

/** */
CFloatSpinBox::CFloatSpinBox( int minValue, int maxValue, int step, QWidget * parent, const char * name)
	: QSpinBox(minValue,maxValue,step,parent,name)
{
}

/** */
CFloatSpinBox::~CFloatSpinBox()
{
}

/** */
QString CFloatSpinBox::mapValueToText( int value )
{
	if ( value == -1 ) // special case
		return QString( "Auto" );

	return QString( "%1.%2" ) // 0.0 to 10.0
		.arg( value / 10 ).arg( value % 10 );
}

/** */
int CFloatSpinBox::mapTextToValue( bool * /*ok*/ )
{
	if ( text() == "Auto" ) // special case
		return -1;

	return (int) ( 10 * text().toFloat() ); // 0 to 100
}
