/***************************************************************************
                        dcuserslist.cpp  -  description
                             -------------------
    begin                : Thu Nov 21 2002
    copyright            : (C) 2002 by Franois Gannaz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>

#include <qlistview.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qpopupmenu.h>
#include <qcursor.h>
#include <qstatusbar.h>
#include <qlayout.h>

#include <dcconfig.h>
#include <dcevent.h>
#include <dcconnectionmanager.h>
#include <dcmenuhandler.h>
#include <dciconloader.h>

#include <dclib/core/cfile.h>
#include <dclib/core/cdir.h>
#include <dclib/core/cbytearray.h>

#include "dcuserslist.h"

DCUsersList * g_pUsersList = 0;

/** */
DCUsersList::DCUsersList(QWidget* parent, const char *name, int wflags) : DCDialogUsersList(parent, name, wflags)
{
	// set default icon
	//	setIcon( QPixmap( ??? ) );

	pWorkspace = (QWorkspace*)parent;

	InitDocument();

	g_pUsersList = this;
}

/** */
DCUsersList::~DCUsersList()
{
	g_pUsersList = NULL;

	if ( m_pFriendList )
	{
		delete m_pFriendList;
	}
}

/** */
int DCUsersList::selectedItems( QListView * list, QPtrList<QListViewItem> & lst )
{
	QListViewItemIterator it( (QListView *)list );

	for ( ; it.current(); it++ )
	{
		if ( it.current()->isSelected() )
		{
			lst.append(it.current());
		}
	}

	return lst.count();
}

/** */
void DCUsersList::InitDocument()
{
	StringMap * map;

	m_pStatusBar = new QStatusBar(this);

	layout()->add( m_pStatusBar ); //, 1, 0 );

	// restore settings
	if ( g_pConfig->GetMap("USERVIEW",map) == TRUE )
	{
		if ( ((*map)["WIDTH"].toInt() > 0) && ((*map)["HEIGHT"].toInt() > 0) )
		{
			setGeometry( (*map)["X"].toInt(), (*map)["Y"].toInt(), (*map)["WIDTH"].toInt(), (*map)["HEIGHT"].toInt() );
		}
	}
	
	ListView_FRIENDS->header()->hide();
	ListView_FRIENDS->setColumnAlignment(1,Qt::AlignRight);
	ListView_FRIENDS->setColumnWidthMode(0,QListView::Manual);
	ListView_FRIENDS->setColumnWidthMode(1,QListView::Manual);
	ListView_FRIENDS->setColumnWidth(1,32);

	connect( ListView_FRIENDS, SIGNAL(contextMenuRequested( QListViewItem *, const QPoint &, int )), this, SLOT(slotRightButtonClickedFriendList(QListViewItem*, const QPoint &, int )) );

	// friends list
	m_pFriendList = new CStringList();

	// load frienlist
	g_pConfig->LoadDCFriendList( m_pFriendList );

	ShowFriendsList();

	installEventFilter(this);
}

/** */
void DCUsersList::DeInitDocument()
{
	StringMap * map;

	// save search view settings
	g_pConfig->GetMap("USERVIEW",map);

	(*map)["X"]         = QString().setNum(x());
	(*map)["Y"]         = QString().setNum(y());
	(*map)["WIDTH"]     = QString().setNum(width());
	(*map)["HEIGHT"]    = QString().setNum(height());
	(*map)["VISIBLE"]   = QString().setNum(isVisible());
	(*map)["MAXIMIZED"] = QString().setNum(isMaximized());
	(*map)["MINIMIZED"] = QString().setNum(isMinimized());
	(*map)["ENABLED"]   = QString().setNum(isEnabled());
}

/** overridden so that the columns are resized on show() */
void DCUsersList::show()
{
	QWidget::show();

	int width = ListView_FRIENDS->width();

	ListView_FRIENDS->setColumnWidth(1,32);
	ListView_FRIENDS->setColumnWidth(0,width-32);
}

/** */
void DCUsersList::resizeEvent( QResizeEvent * )
{
	int width = ListView_FRIENDS->width();

	ListView_FRIENDS->setColumnWidth(1,32);
	ListView_FRIENDS->setColumnWidth(0,width-32);
}

/** event filter */
bool DCUsersList::eventFilter( QObject * object, QEvent * event )
{
	DCFriendObject * FriendObject;
	eUserAwayMode awaymode;

	if( event->type() == EVENT_UPDATE_FRIEND )
	{
		DC_FriendEvent * e = (DC_FriendEvent*)event;

		if ( (e->m_pFriendObject->m_sName == "") && (g_pConnectionManager) )
		{
			// check all friends online state
			FriendObject = 0;

			while( m_pFriendList->Next((CObject *&)FriendObject) == 1 )
			{
				if ( g_pConnectionManager->IsUserOnline( FriendObject->m_sName, "", "", 0 ) == TRUE )
				{
					awaymode = euamONLINE;
				}
				else
				{
					awaymode = euamOFFLINE;
				}

				SetAwayMode( FriendObject, awaymode );
			}
		}
		else if ( m_pFriendList->Get(e->m_pFriendObject->m_sName,(CObject*&)FriendObject) == 0 )
		{
			SetAwayMode( FriendObject, e->m_pFriendObject->m_eAwayMode );
		}
	}

	return QWidget::eventFilter( object, event );    // standard event processing
}

/** */
void DCUsersList::ShowFriendsList()
{
	QImage im;
	DCFriendObject * FriendObject;

	FriendObject = 0;

	while( m_pFriendList->Next((CObject *&)FriendObject) == 1 )
	{
		FriendObject->m_pItem = new QListViewItem( ListView_FRIENDS, FriendObject->m_sName.Data() );

		FriendObject->m_pItem->setPixmap(0,g_pIconLoader->GetPixmap(eiBALL_RED));

		if ( FriendObject->m_sImageFileName != "" )
		{
			if ( im.load(FriendObject->m_sImageFileName.Data()) == TRUE )
			{
				im = im.smoothScale(32,32,QImage::ScaleMin);
				FriendObject->m_pItem->setPixmap(1,im);
			}
		}
	}
}

/** */
void DCUsersList::DelFriend( CString name )
{
	DCFriendObject * FriendObject;

	if ( m_pFriendList->Get(name,(CObject*&)FriendObject) == 0 )
	{
		ListView_FRIENDS->takeItem(FriendObject->m_pItem);
		delete FriendObject->m_pItem;

		// remove from list
		m_pFriendList->Del(name);

		// save list
		g_pConfig->SaveDCFriendList( m_pFriendList );
	}
}

/** */
void DCUsersList::AddFriend( CString name, CString hubname, CString hubhost, CString description )
{
	DCFriendObject * FriendObject;
	eUserAwayMode awaymode = euamNONE;

	if ( m_pFriendList->Get(name,(CObject*&)FriendObject) != 0 )
	{
		FriendObject = new DCFriendObject();

		FriendObject->m_sName        = name;
		FriendObject->m_sHubName     = hubname;
		FriendObject->m_sHubHost     = hubhost;
		FriendObject->m_sDescription = description;

		FriendObject->m_pItem = new QListViewItem( ListView_FRIENDS, FriendObject->m_sName.Data() );

		m_pFriendList->Add(name,FriendObject);

		if ( g_pConnectionManager )
		{
			if ( g_pConnectionManager->IsUserOnline( FriendObject->m_sName, "", "", 0 ) == TRUE )
			{
				awaymode = euamONLINE;
			}
		}

		SetAwayMode( FriendObject, awaymode );

		// save friendlist
		g_pConfig->SaveDCFriendList( m_pFriendList );
	}
}

/** */
void DCUsersList::UpdateFriend( CString /*name*/, CString /*host*/, CString /*description*/ )
{
}

/** */
bool DCUsersList::AddFriendPhoto( CString name, CByteArray * data )
{
	bool res = FALSE;
	DCFriendObject * FriendObject;
	CFile f;
	CDir dir;
	CString s;
	int i;

	if ( m_pFriendList->Get(name,(CObject*&)FriendObject) == 0 )
	{
		s = FriendObject->m_sImageFileName;

		if ( s != "" )
		{
			if ( f.Open( s,	IO_RAW|IO_WRITEONLY|IO_TRUNCATE ) )
			{
				f.Write((char*)data->Data(),data->Size());
				f.Close();
			}
			else
			{
				s = "";
			}
		}

		if ( s == "" )
		{
			// create new image
			for(i=0;i<200;i++)
			{
				if ( dir.IsFile( g_pConfig->GetImagePath() + CString().setNum(i) + ".png", FALSE ) == FALSE )
					break;
			}

			if ( i < 200 )
			{
				if ( f.Open( g_pConfig->GetImagePath() + CString().setNum(i) + ".png",
						IO_RAW|IO_WRITEONLY|IO_CREAT,
						MO_IRUSR|MO_IWUSR|MO_IRGRP|MO_IROTH) )
				{
					f.Write((char*)data->Data(),data->Size());
					f.Close();

					FriendObject->m_sImageFileName = g_pConfig->GetImagePath() + CString().setNum(i) + ".png";
				}
				else
				{
					printf("cant open file\n");
				}
			}
		}

		// save friendlist
		g_pConfig->SaveDCFriendList( m_pFriendList );

		QImage im;

		if ( FriendObject->m_sImageFileName != "" )
		{
			if ( im.load(FriendObject->m_sImageFileName.Data()) == TRUE )
			{
				im = im.smoothScale(32,32,QImage::ScaleMin);
				FriendObject->m_pItem->setPixmap(1,im);
			}
		}
	}

	return res;
}

/** */
void DCUsersList::SetAwayMode( DCFriendObject * obj, eUserAwayMode e )
{
	if ( !obj || !obj->m_pItem )
	{
		return;
	}

	if ( obj->m_eAwayMode != e )
	{
		obj->m_eAwayMode = e;

		switch(obj->m_eAwayMode)
		{
			case euamNORMAL:
			case euamONLINE:
				obj->m_pItem->setPixmap(0,g_pIconLoader->GetPixmap(eiBALL_GREEN));
				break;
			case euamAWAY:
				obj->m_pItem->setPixmap(0,g_pIconLoader->GetPixmap(eiBALL_YELLOW));
				break;
			// case euamNONE:
			// case euamOFFLINE:
			default:
				obj->m_pItem->setPixmap(0,g_pIconLoader->GetPixmap(eiBALL_RED));
				break;
		}
	}
}

/** */
void DCUsersList::slotRightButtonClickedFriendList(QListViewItem*, const QPoint &, int )
{
	int id;
	QPopupMenu *m;
	QPtrList<QListViewItem> selitems;
	QListViewItem * curitem;

	if ( selectedItems(ListView_FRIENDS,selitems) == 0 )
	{
		return;
	}

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenu( m, emiREMOVE );

	id = m->exec(QCursor::pos());

	delete m;

	if ( id == -1 )
	{
		return;
	}

	if ( id == emiREMOVE )
	{
	        for ( curitem = selitems.first(); curitem; curitem = selitems.next() )
	        {
			DelFriend(curitem->text(0).ascii());
		}
	}
}
