/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#include "visu_basic.h"
#include "visu_commandLine.h"
#include "visu_tools.h"
#include "visu_basic.h"
#include "opengl.h"
#include "visu_plugins.h"
#include "visu_gtk.h"
#include "gtk_main.h"
#include "visu_data.h"
#include "extensions/scale.h"
#include "renderingMethods/renderingSpin.h"
#include "gtk_renderingWindowWidget.h"

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib.h>

#ifdef WITH_GOBJECT_INTROSPECTION
#include <girepository.h>
#endif
#ifdef HAVE_GTKGLEXT
#include <gdk/gdkgl.h>
#endif

#define VISU_MEM_CHECK 0

int main (int argc, char *argv[])
{
  int res;
  char *arg;
  VisuData *newData;
  gchar *dirname, *normDir;
#ifdef WITH_GOBJECT_INTROSPECTION
  GError *error;
#endif
  VisuRenderingWindow *window;

#if DEBUG == 1 && VISU_MEM_CHECK == 1
  g_mem_set_vtable(glib_mem_profiler_table);
#endif
  g_type_init();

  DBG_fprintf(stderr, "--- Get the default path ---\n");
  visu_basic_setExePath(argv[0]);

#ifdef G_THREADS_ENABLED
  DBG_fprintf(stderr, "--- Initialise threads ---\n");
  g_thread_init(NULL);
#endif

#ifdef ENABLE_NLS
  setlocale (LC_ALL, "");
  bindtextdomain (GETTEXT_PACKAGE, V_SIM_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  DBG_fprintf(stderr, "--- Parse the command line ---\n");
  res = commandLineParse(argc, argv);
  if (res)
    exit(1);
  /* 5444o still allocated by GLIB. */

  /* if arg is not null, v_sim is in export mode. */
  arg = commandLineGet_ExportFileName();
  if (arg)
    {
#ifdef HAVE_GTKGLEXT
      DBG_fprintf(stderr, "Visu Main: initialise Gtk.\n");
      gtk_init(&argc, &argv);

      DBG_fprintf(stderr, "Visu Main: initialise GtkGlExt.\n");
      gdk_gl_init(&argc, &argv);
#endif

      DBG_fprintf(stderr,"--- Initialising plugins ---\n");
      visu_plugins_init();

      DBG_fprintf(stderr, "Visu Main: test for help message.\n");
      if (visu_basic_showOptionHelp(FALSE))
        exit(0);

      DBG_fprintf(stderr, "Visu Main: V_Sim has been called in an export session,"
		  " with parameter '%s'.\n", arg);
      res = visu_basic_mainExport();

      return res;
    }

  /* Introspection case, must be called after g_object initialisation. */
  if (commandLineGet_introspect())
    {
#ifdef WITH_GOBJECT_INTROSPECTION
      /* Additional classes. */
      g_type_class_ref(VISU_RENDERING_TYPE);
      g_type_class_ref(VISU_DATA_TYPE);
      g_type_class_ref(VISU_GLEXT_SCALE_TYPE);
      g_type_class_ref(VISU_MARKS_TYPE);
      g_type_class_ref(RENDERING_WINDOW_TYPE);
      g_type_class_ref(VISU_UIMAIN_TYPE);

      DBG_fprintf(stderr, "Visu Main: call introspection for file '%s'.\n",
		  commandLineGet_introspect());
      error = (GError*)0;
      g_irepository_dump(commandLineGet_introspect(), &error);
      if (error)
	{
	  g_error("%s", error->message);
	  g_error_free(error);
	}
      return 0;
#else
      g_warning("Introspection required but not compiled.");
#endif
    }

  DBG_fprintf(stderr, "Visu Main: initialise Gtk.\n");
  gtk_init(&argc, &argv);

  gtk_window_set_default_icon_name("v_sim");
  gtk_icon_theme_append_search_path(gtk_icon_theme_get_default(),
                                    V_SIM_ICONS_DIR);
  g_set_application_name(_("Visualise atomic simulations"));

#ifdef HAVE_GTKGLEXT
  DBG_fprintf(stderr, "Visu Main: initialise GtkGlExt.\n");
  gdk_gl_init(&argc, &argv);
#endif
  /* 38713o still allocated by GLIB and GTK. */

  initVisuBasic();
  initOpenglGraphics();

  /* the default is V_Sim with gtk interface. */
  if (!strcmp(commandLineGet_windowMode(), "renderOnly"))
    visuGtkMain(visuGtkCreate_main);
  else
    visuGtkMain(visu_uiMainClass_createMain);
  window = RENDERING_WINDOW(visuGtkGet_renderArea());

  DBG_fprintf(stderr,"--- Initialising plugins ---\n");
  visu_plugins_init();

  DBG_fprintf(stderr, "Visu Main: test for help message.\n");
  if (visu_basic_showOptionHelp(FALSE))
    exit(0);

  newData = visu_basic_setDataFromCommandLine();
  if (newData)
    {
      dirname = g_path_get_dirname(visu_data_getFile(newData, FILE_KIND_POSITION,
						    (ToolFileFormat**)0));
      normDir = normalize_path(dirname);
      visuGtkSet_lastOpenDirectory((char*)normDir, VISU_DIR_FILE);
      g_free(dirname);
      g_free(normDir);

      visu_rendering_window_loadFile(window, newData, commandLineGet_iSet());

      /* Run the command line. */
      if (!strcmp(commandLineGet_windowMode(), "renderOnly"))
	g_idle_add(visuGtkRun_commandLine, (gpointer)0);
      else
	{
	  g_idle_add(visu_ui_main_initPanels, (gpointer)0);
	  g_idle_add(visu_ui_main_runCommandLine, (gpointer)visuGtkGet_panel());
	}
    }
  else
    {
      visu_rendering_window_setData(window, (VisuData*)0);

      /* Run the command line. */
      if (strcmp(commandLineGet_windowMode(), "renderOnly"))
	g_idle_add(visu_ui_main_initPanels, (gpointer)0);
    }

  DBG_fprintf(stderr, "Visu Main: starting main GTK loop.\n");
  gtk_main();
  DBG_fprintf(stderr, "Visu Main: quit main GTK loop.\n");

  return 0;
}
