/*   EXTRAITS DE LA LICENCE
     Copyright CEA, contributeurs : Luc BILLARD et Damien
     CALISTE, laboratoire L_Sim, (2001-2005)
  
     Adresse ml :
     BILLARD, non joignable par ml ;
     CALISTE, damien P caliste AT cea P fr.

     Ce logiciel est un programme informatique servant  visualiser des
     structures atomiques dans un rendu pseudo-3D. 

     Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
     respectant les principes de diffusion des logiciels libres. Vous pouvez
     utiliser, modifier et/ou redistribuer ce programme sous les conditions
     de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
     sur le site "http://www.cecill.info".

     Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
     pris connaissance de la licence CeCILL, et que vous en avez accept les
     termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
     Copyright CEA, contributors : Luc BILLARD et Damien
     CALISTE, laboratoire L_Sim, (2001-2005)

     E-mail address:
     BILLARD, not reachable any more ;
     CALISTE, damien P caliste AT cea P fr.

     This software is a computer program whose purpose is to visualize atomic
     configurations in 3D.

     This software is governed by the CeCILL  license under French law and
     abiding by the rules of distribution of free software.  You can  use, 
     modify and/ or redistribute the software under the terms of the CeCILL
     license as circulated by CEA, CNRS and INRIA at the following URL
     "http://www.cecill.info". 

     The fact that you are presently reading this means that you have had
     knowledge of the CeCILL license and that you accept its terms. You can
     find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef FOG_H
#define FOG_H

#include <visu_extension.h>
#include <visu_tools.h>


/**
 * initExtFogAndBG:
 *
 * It initialises all variables of the OpenGL extension.
 * It creates all resources and parameters introduced by
 * this extension.
 * This method should be added in the %listInitExtensionFunc to
 * be called automatically by the initVisuExtensions() at V_Sim
 * startup.
 *
 * Returns: a pointer to the VisuExtension it created or
 * NULL otherwise.
 */
VisuExtension* initExtFogAndBG();

/**
 * VISU_GLEXT_FOG_AND_BG_ID:
 *
 * The id used to identify this extension, see
 * visuExtensions_rebuildList() for instance.
 */
#define VISU_GLEXT_FOG_AND_BG_ID "FogAndColor"

/**
 * visu_glExt_fog_setValues:
 * @rgba: a three floats array with values (0 <= values <= 1) for the
 * red, the green and the blue color. Only values specified by the mask
 * are really relevant.
 * @mask: use #TOOL_COLOR_MASK_R, #TOOL_COLOR_MASK_G, #TOOL_COLOR_MASK_B, #TOOL_COLOR_MASK_RGBA or a
 * combinaison to indicate what values in the rgb array must be taken
 * into account.
 *
 * Method used to change the value of the parameter fog_specific_color.
 * This color is actually used only if fog_color_is_specific is set to 1,
 * use setFogColorSpecific() to do that.
 *
 * Returns: 0 if redrawing is not necessary.
 * 1 if the rendering window must be redrawn.
 */
int visu_glExt_fog_setValues(float rgba[4], int mask);
/**
 * visu_glExt_fog_setOn:
 * @value: TRUE if fog must be rendered, FALSE otherwise.
 *
 * Method used to change the value of the parameter fog_is_on.
 *
 * Returns: FALSE if redrawing is not necessary.
 * TRUE if the rendering window must be redrawn.
 */
gboolean visu_glExt_fog_setOn(gboolean value);
/**
 * visu_glExt_fog_setUseSpecificColor:
 * @value: TRUE if fog is rendered with its own color specified
 * by setFogRGBValues() or FALSE if the fog uses the background
 * color.
 *
 * Method used to change the value of the parameter fog_color_is_specific.
 *
 * Returns: TRUE if visu_glExt_fog_create() should be called. In all cases, 'OpenGLAskForReDraw'
 *          signal should then be emitted.
 */
gboolean visu_glExt_fog_setUseSpecificColor(gboolean value);
/**
 * VISU_GLEXT_FOG_MASK_START:
 *
 * Value used by the second parameter of setFogStartEndValues() to
 * specified the value that must be changed. This actually changes
 * the fog_start value.
 */
#define VISU_GLEXT_FOG_MASK_START (1 << 0)
/**
 * VISU_GLEXT_FOG_MASK_END:
 *
 * Value used by the second parameter of setFogStartEndValues() to
 * specified the value that must be changed. This actually changes
 * the fog_end value.
 */
#define VISU_GLEXT_FOG_MASK_END (1 << 1)
/**
 * visu_glExt_fog_setStartEndValues:
 * @startEnd: a two floats array with values (0 <= values <= 1) for the
 * beging and the ending of the fog position. Only values specified by the mask
 * are really relevant.
 * @mask: use #VISU_GLEXT_FOG_MASK_START, #VISU_GLEXT_FOG_MASK_END to indicate what values in
 * the startEnd array must be taken into account.
 *
 * Method used to change the value of the parameters fog_start and
 * fog_end.
 *
 * Returns: TRUE if visu_glExt_fog_create() should be called and then 'OpenGLAskForReDraw'
 *          signal be emitted.
 */
gboolean visu_glExt_fog_setStartEndValues(float startEnd[2], int mask);

/**
 * visu_glExt_fog_getValues:
 * @rgba: a storage for four values.
 *
 * Read the RGBA value of the specific fog colour (in [0;1]).
 */
void visu_glExt_fog_getValues(float rgba[4]);
/**
 * visu_glExt_fog_getOn:
 *
 * Read if fog is used or not.
 *
 * Returns: TRUE if the fog is rendered, FALSE otherwise.
 */
gboolean visu_glExt_fog_getOn();
/**
 * visu_glExt_fog_getUseSpecificColor:
 *
 * Read if fog uses a specific colour or not.
 *
 * Returns: TRUE if the fog uses its own color or FALSE if it uses
 * the color of the background.
 */
gboolean visu_glExt_fog_getUseSpecificColor();
/**
 * visu_glExt_fog_getStart:
 *
 * Read the starting value of the fog (in [0;1]).
 *
 * Returns: the position where the fog starts.
 */
float visu_glExt_fog_getStart();
/**
 * visu_glExt_fog_getEnd:
 *
 * Read the ending value of the fog (in [0;1]).
 *
 * Returns: the position where the fog ends.
 */
float visu_glExt_fog_getEnd();
/**
 * visu_glExt_bg_setValues:
 * @rgba: a three floats array with values (0 <= values <= 1) for the
 * red, the green and the blue color. Only values specified by the mask
 * are really relevant.
 * @mask: use #TOOL_COLOR_MASK_R, #TOOL_COLOR_MASK_G, #TOOL_COLOR_MASK_B, #TOOL_COLOR_MASK_RGBA or a
 * combinaison to indicate what values in the rgb array must be taken
 * into account.
 *
 * Method used to change the value of the parameter background_color.
 *
 * Returns: 0 if redrawing is not necessary.
 * 1 if the rendering window must be redrawn.
 */
int visu_glExt_bg_setValues(float rgba[3], int mask);
/**
 * visu_glExt_bg_getValues:
 * @rgba: a storage for four values.
 *
 * Read the RGBA value of the specific background colour (in [0;1]).
 */
void visu_glExt_bg_getValues(float rgba[4]);

/**
 * visu_glExt_fog_create:
 * @data: the #VisuData object the fog apply to.
 *
 * Call the OpenGL routine to enable and initialise the fog.
 */
void visu_glExt_fog_create(VisuData *data);
/**
 * visu_glExt_fog_create_color:
 *
 * Call the OpenGL routines that change the colour of the fog.
 */
void visu_glExt_fog_create_color();

/**
 * visu_glExt_bg_setImage:
 * @imageData: raw image data in RGB or RGBA format ;
 * @width: the width ;
 * @height: the height ;
 * @alpha: TRUE if the image is RGBA ;
 * @title: an optional title (can be NULL).
 * @fit: a boolean (default is TRUE).
 *
 * Draw the @imageData on the background. The image is scaled to the
 * viewport dimensions, keeping the width/height ratio, if @fit is set
 * to TRUE. If @title is not NULL, the title is also printed on the
 * background. The image data are copied and can be free after this
 * call.
 */
void visu_glExt_bg_setImage(const guchar *imageData, guint width, guint height,
                            gboolean alpha, const gchar *title, gboolean fit);

#endif
