/*
 * GLX Hardware Device Driver for S3 Savage3D and probably Savage/MX and
 * Savage/IX
 * Copyright (C) 2000 Dominik Behr
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Based on S3 Virge driver by Jim Duchek <jimduchek@ou.edu>
 *
 * Dominik Behr <behr@promail.pl>
 * thanks to Raja Koduri and Tim Roberts   
 */

#include "s3savglx.h"
#include <stdio.h>
#include <math.h>

#ifdef DUPLICATE_LAST_VERTEX
#define SEND_VERTICES 5L
#else
#define SEND_VERTICES 4L
#endif

/******************************************************************************

******************************************************************************/
void
s3savLine_TX_FG(GLcontext *pCtx, 
                GLuint e0, 
                GLuint e1, 
                GLuint pv)
#define VERTEX_SIZE 8
#define C_TEXTURE
#define C_FOG
#include "s3savline.h"
#undef C_TEXTURE
#undef C_FOG
#undef VERTEX_SIZE

/******************************************************************************

******************************************************************************/
void
s3savLine_TX_NF(GLcontext *pCtx, 
                GLuint e0, 
                GLuint e1, 
                GLuint pv)
#define VERTEX_SIZE 7
#define C_TEXTURE
#include "s3savline.h"
#undef C_TEXTURE
#undef VERTEX_SIZE

/******************************************************************************

******************************************************************************/
void
s3savLine_NT_FG(GLcontext *pCtx, 
                GLuint e0, 
                GLuint e1, 
                GLuint pv)
#define VERTEX_SIZE 6
#define C_FOG
#include "s3savline.h"
#undef C_FOG
#undef VERTEX_SIZE

/******************************************************************************

******************************************************************************/
void
s3savLine_NT_NF(GLcontext *pCtx, 
                GLuint e0, 
                GLuint e1, 
                GLuint pv)
#define VERTEX_SIZE 5
#include "s3savline.h"
#undef VERTEX_SIZE


#undef SEND_VERTICES
#ifdef DUPLICATE_LAST_VERTEX
#define SEND_VERTICES 4L
#else
#define SEND_VERTICES 3L
#endif

/******************************************************************************

******************************************************************************/
void 
s3savTriangle_TX_FG(GLcontext *pCtx, 
                    GLuint e0, 
                    GLuint e1, 
                    GLuint e2, 
                    GLuint pv)
#define VERTEX_SIZE 8
#define C_TEXTURE
#define C_FOG
#include "s3savtri.h"
#undef C_TEXTURE
#undef C_FOG
#undef VERTEX_SIZE

/******************************************************************************

******************************************************************************/
void 
s3savTriangle_TX_NF(GLcontext *pCtx, 
                    GLuint e0, 
                    GLuint e1, 
                    GLuint e2, 
                    GLuint pv)
#define VERTEX_SIZE 7
#define C_TEXTURE
#include "s3savtri.h"
#undef C_TEXTURE
#undef VERTEX_SIZE

/******************************************************************************

******************************************************************************/
void 
s3savTriangle_NT_FG(GLcontext *pCtx, 
                    GLuint e0, 
                    GLuint e1, 
                    GLuint e2, 
                    GLuint pv)
#define VERTEX_SIZE 6
#define C_FOG
#include "s3savtri.h"
#undef C_FOG
#undef VERTEX_SIZE

/******************************************************************************

******************************************************************************/
void 
s3savTriangle_NT_NF(GLcontext *pCtx, 
                    GLuint e0, 
                    GLuint e1, 
                    GLuint e2, 
                    GLuint pv)
#define VERTEX_SIZE 5
#include "s3savtri.h"
#undef VERTEX_SIZE

#undef SEND_VERTICES
