/*
    Copyright (C) 2001-2002  bjk <bjk@arbornet.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <pwd.h>
#include "config.h"

#ifdef HAVE_LASTLOG_H
#include <lastlog.h>
#endif

#ifdef HAVE_UTMPX_H
#include <utmpx.h>
#ifndef UT_LINESIZE
#define UT_LINESIZE 32
#define UT_HOSTSIZE 256
#endif
#else
#include <utmp.h>
#endif

#ifdef HAVE_PROCFS
#include <dirent.h>
#endif

#ifdef HAVE_GETSPNAM
#include <shadow.h>
#endif

#ifdef HAVE_SYS_LIMITS_H
#include <sys/syslimits.h>
#endif

#ifdef USE_DMALLOC
#include <dmalloc.h>
#endif

#ifndef LINE_MAX
#define LINE_MAX 2048
#endif

#define ARRAYCNT(x) (sizeof x / sizeof(x[0]))

#define MAXOPTIONS 64
#define TIMEBUF 64

/* structure definitions */
typedef struct gecos {
    char *name;
    char *office;
    char *officephone;
    char *homephone;
} GECOS;

typedef struct mails {
    char lastread[TIMEBUF];
    char newstamp[TIMEBUF];
    char foldersize[10];
    char forward[LINE_MAX];
    char aliases[LINE_MAX];
} MAIL;

typedef struct lastinfo {
    char tty[UT_LINESIZE];
    char host[UT_HOSTSIZE];
    char time[TIMEBUF];
} LASTINFO;

typedef struct logins {
    char stamp[TIMEBUF];
    char duration[10];
    char host[UT_HOSTSIZE];
    char tty[UT_LINESIZE];
    char idle[10];
    char ppid[6];
    unsigned int mesgstat;
    unsigned int online;
} LOGIN;

typedef struct groups {
    gid_t id;
    char name[32];
    struct groups *next;
} GROUP;

typedef struct infos {
    struct passwd *passwd;
#ifdef HAVE_GETSPNAM
    struct spwd *spwd;
#endif
    GROUP *group;
    GECOS *gecos;
    LASTINFO *lastinfo;
    MAIL *mail;
    LOGIN *login;
    mode_t homedirmode;
} INFO;

/* external variables */
char gecos_opts[4], lastlog_opts[3]; /* number of suboptions */
unsigned int verbose, delimchar, group_info, usefile;
int optspec[MAXOPTIONS];
char *gecosopts, *lastopts, tf[TIMEBUF];
int utmpfd;
FILE *aliasfp, *lastfp;
#ifdef HAVE_PROCFS
DIR *procdir;
#endif
#ifdef HAVE_GETSPNAM
int amroot;
#endif

/* function prototypes */
char *itoa(int);
void mailinfo(INFO *, const char *arg);
void outputinfo(INFO *, const char *arg);
void passwdinfo(INFO *);
void logininfo(INFO *, const char *arg);
char *stripstr(char *str, char *rm);
char *stamp(time_t epoch, const char *format);
