/******************************************
 * System Uptime Applet, v0.2
 * c1999 the Free Software Foundation
 * superstar (superstar@outsole.com)
 ******************************************/

#include<gnome.h>
#include<applet-widget.h>
#include<glibtop.h>
#include<glibtop/uptime.h>
#include<signal.h>
#include<stdio.h>
#include"uptime_applet.h"

GtkWidget *applet;

static void uptime_properties(AppletWidget*,gpointer);

typedef struct 
{ GtkWidget *label;

  int mode;
  int value;
  int timeouttime;
  int timeout;
  int resync_val,resync_hold;
  int update_rate,update_hold;
  int show_seconds,second_hold;
  int show_ident,ident_hold;
  int change;
} utData;

void log_msg(char *str)
{ FILE *log_file;
  char home[255]; 

  strcpy(home,getenv("HOME"));
  strcat(home,"/.uptime_log");
  if((log_file=fopen(home,"a"))!=NULL)
    { fprintf(log_file,"%s",str);
      fclose(log_file);
    }   
}

static void about_cb(AppletWidget *widget, gpointer data)
{ GtkWidget *about;
  static const gchar *author[]={"superstar (superstar@outsole.com)",NULL};

  about=gnome_about_new(_("System Uptime Applet"), 
			VERSION,
			"(C) 1999 the Free Software Foundation",
			author,
			_("Display your system uptime"),
			NULL);

  gtk_widget_show(about);
} /* about_cb */

int get_uptime(void)
{ char str_seconds[80];
  FILE *proc_file;
  int int_seconds;

  /*
  typedef struct _glibtop_uptime glibtop_uptime; 
  struct _glibtop_uptime
  { u_int64_t flags;
    double uptime,idletime;  
  };

  glibtop_uptime *gtu;

  glibtop_get_uptime(gtu);
  */

  if((proc_file=fopen("/proc/uptime","r"))==NULL)
    { g_print("Cannot open /proc/uptime for reading!\n");
      _exit(127);
    } 
  
  fscanf(proc_file,"%s",str_seconds);   
  int_seconds=strtol(str_seconds,NULL,10);

  fclose(proc_file);
 
  /*  return(gtu->uptime); */
  return int_seconds;
} /* get_uptime */

static void uptime_update_func(utData *utd)
{ char time_str[20];
  int curr,sec,min,hour,day; 

  /* prevent incrementing on properties change alone */
  if(utd->change==FALSE)
    { utd->value=utd->value+utd->update_rate;
    }
  curr=utd->value;
  
  /* check to resync time with system clock */
  if((curr%(utd->resync_val*60))==0)
    utd->value=get_uptime();

  day=curr/86400;
  curr=curr%86400;
  hour=curr/3600;
  curr=curr%3600;
  min=curr/60;
  sec=curr%60;

  /* implement any changes from properties here, as to
     avoid screwing up the current update period */
  if(utd->change==TRUE)
    { utd->resync_val=utd->resync_hold;
      utd->update_rate=utd->update_hold;
      utd->show_seconds=utd->second_hold;
      utd->show_ident=utd->ident_hold;
      utd->change=FALSE;
    }

  if(utd->show_seconds==1)
    { if(utd->show_ident==1)
        { sprintf(time_str,"%02dd %02dh %02dm %02ds",day,hour,min,sec);
	}
      else
        { sprintf(time_str,"%02d:%02d:%02d:%02d",day,hour,min,sec);
        }
    }
  else
    { if(utd->show_ident==1)
        { sprintf(time_str,"%02dd %02dh %02dm",day,hour,min);
	}
      else
	{ sprintf(time_str,"%02d:%02d:%02d",day,hour,min);
	}
    }

  gtk_label_set_text(GTK_LABEL(utd->label),time_str);
} /* uptime_update_func */

static int uptime_callback(gpointer data)
{ utData *utd=data;
  
  uptime_update_func(utd);
 
  /* kept in seconds, actual in milliseconds */
  if(utd->timeouttime!=(utd->update_rate*1000))    
    { utd->timeouttime=(utd->update_rate*1000);
      utd->timeout=gtk_timeout_add(utd->timeouttime,uptime_callback,utd);
      return FALSE;
    }

  return TRUE;
} /* uptime_callback */

static gint applet_save_session(GtkWidget *w,
				const char *privcfgpath,
				const char *globcfgpath,
				gpointer data)
{ utData *utd=data;

  gnome_config_push_prefix(privcfgpath);
  gnome_config_set_int("uptime/resync_val",utd->resync_val);
  gnome_config_set_int("uptime/update_rate",utd->update_rate);
  gnome_config_set_int("uptime/show_seconds",utd->show_seconds);
  gnome_config_set_int("uptime/show_ident",utd->show_ident);

  gnome_config_pop_prefix();
  gnome_config_sync();
  gnome_config_drop_all();

  return FALSE;
} /* applet_save_session */

static void load_properties(utData *utd)
{ char str[20];

  log_msg("properties loaded\n");

  utd->resync_val=gnome_config_get_int("uptime_applet/uptime/resync_val=120");
  utd->update_rate=gnome_config_get_int("uptime_applet/uptime/update_rate=60");
  utd->show_seconds=gnome_config_get_int("uptime_applet/uptime/show_seconds=1");
  utd->show_ident=gnome_config_get_int("uptime_applet/uptime/show_ident=0");

  sprintf(str,"show_seconds=%d\n",utd->show_seconds);
  log_msg(str);
} /* load_properties */

GtkWidget *set_text_display(utData *utd)
{ GtkWidget *align;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *frame;

  frame=gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_IN);

  align=gtk_alignment_new(0.5,0.5,0.0,0.0);
  gtk_container_set_border_width(GTK_CONTAINER(align),4);
  gtk_container_add(GTK_CONTAINER(frame),align);
  gtk_widget_show(align);
        
  vbox=gtk_vbox_new(FALSE,FALSE);
  gtk_container_add(GTK_CONTAINER(align),vbox);
  gtk_widget_show(vbox);

  label=gtk_label_new("Uptime");
  uptime_update_func(utd);      /* explicit call to display first value */
  gtk_widget_show(label);
  gtk_widget_show(utd->label);
  gtk_box_pack_start(GTK_BOX(vbox),label,TRUE,TRUE,0);
  gtk_box_pack_start(GTK_BOX(vbox),utd->label,TRUE,TRUE,0);

  hbox=gtk_hbox_new(FALSE,FALSE);
  gtk_box_pack_start_defaults(GTK_BOX(vbox),hbox);
  gtk_widget_show(hbox);

  return frame;
} /* set_text_display */

static GtkWidget *create_uptime_applet(GtkWidget *window,utData *utd)
{ GtkWidget *frame;
  char str[20];

  /* initialize uptime data strucuture */  
  utd=g_new(utData,1);
  utd->label=gtk_label_new("");
  utd->mode=TEXT_MODE;
  utd->value=get_uptime()-1;
  utd->resync_val=DEFAULT_RESYNC;
  utd->resync_hold=DEFAULT_RESYNC;
  utd->update_rate=DEFAULT_UPDATE;
  utd->update_hold=DEFAULT_UPDATE;
  utd->show_seconds=DEFAULT_SECOND;
  utd->second_hold=DEFAULT_SECOND;
  utd->show_ident=DEFAULT_IDENT;
  utd->ident_hold=DEFAULT_IDENT;
  utd->change=FALSE;
  utd->timeouttime=(utd->update_rate*1000);
  utd->timeout=gtk_timeout_add(utd->timeouttime,uptime_callback,utd);

  load_properties(utd);

  frame=set_text_display(utd);

  gtk_signal_connect(GTK_OBJECT(applet),"save_session",
		     GTK_SIGNAL_FUNC(applet_save_session),
		     utd);

  applet_widget_register_stock_callback(APPLET_WIDGET(applet),
					"about",
					GNOME_STOCK_MENU_ABOUT,
					_("About..."),
					about_cb,
					NULL);

  applet_widget_register_stock_callback(APPLET_WIDGET(applet),
					"properties",
					GNOME_STOCK_MENU_PROP,
					_("Properties..."),
					uptime_properties,
					utd);

  /* putting this code here gets it to work... go figure */
  gnome_config_push_prefix(APPLET_WIDGET(applet)->privcfgpath);
  utd->resync_val=gnome_config_get_int("uptime/resync_val=120");
  utd->update_rate=gnome_config_get_int("uptime/update_rate=60");
  utd->show_seconds=gnome_config_get_int("uptime/show_seconds=0");
  utd->show_ident=gnome_config_get_int("uptime/show_ident=1");

  sprintf(str,"show_seconds=%d\n",utd->show_seconds);
  log_msg(str);

  /* apply properties */
  uptime_update_func(utd);  

  return frame;
} /* create_uptime_panel */

int main(int argc, char **argv)
{ GtkWidget *uptime;
  utData *utd=NULL;
	
  /* initialize i18n stuph */
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);
	
  applet_widget_init("uptime_applet",VERSION,argc,argv,NULL,0,NULL);
	
  applet=applet_widget_new("uptime_applet");
  if(!applet) 
    { g_print("Cannot create applet!\n");
      _exit(127);
    }
	
  gtk_widget_realize(applet);

  uptime=create_uptime_applet(applet,utd);
  gtk_widget_show(uptime);
	
  applet_widget_add(APPLET_WIDGET(applet),uptime);
  gtk_widget_show(applet);

  applet_widget_gtk_main();
	
  return 0;
} /* main */

/*************** properties *******************/

static void close_properties(GtkWidget *widget,GtkWidget **prop)
{ *prop=NULL;
} /* close_properties */

static void apply_properties(GtkWidget *widget,gint button_num,gpointer data)
{ utData *utd=data;

  /* hold values are used because updating the actual values 
     directly would cause the change to take effect before apply 
     was pressed (for some reason I couldn't fathom). this circumvented
     the problem */
  utd->change=TRUE;  

  /* interrupt current timeout and start over, updating display */
  gtk_timeout_remove(utd->timeout);     
  utd->timeout=gtk_timeout_add(utd->timeouttime,uptime_callback,utd);

  utd->value=get_uptime();  /* resync clock for the hell of it */
  uptime_update_func(utd);  
  utd->timeouttime=(utd->update_rate*1000);
} /* apply properties */

static void cb_adj(GtkAdjustment *adj,gint *new_val)
{ GtkWidget *props;

  props=gtk_object_get_data(GTK_OBJECT(adj),"prop");

  if(props)
    { gnome_property_box_changed(GNOME_PROPERTY_BOX(props));
    }
  *new_val=(gint)(adj->value);
} /* cb_adj */

static void cb_check(GtkWidget *widget,gint *new_val)
{ GtkWidget *props;
  
  props=gtk_object_get_data(GTK_OBJECT(widget),"prop");
  if(props)
    { gnome_property_box_changed(GNOME_PROPERTY_BOX(props));
    }

  if(GTK_TOGGLE_BUTTON(widget)->active)
    *new_val=1;
  else
    *new_val=0;
} /* cb_check */

static void uptime_properties(AppletWidget *applet,gpointer data)
{ static GnomeHelpMenuEntry help_entry={NULL,"topic.dat"};

  static GtkWidget *props=NULL;
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *align;
  GtkWidget *entry;
  GtkWidget *label;
  GtkWidget *showdate;
  GtkWidget *unixtime;
  GtkAdjustment *adj;
  utData *utd=data;

  help_entry.name=gnome_app_id;

  if(props) 
    { gtk_widget_show(props);
      if(props->window)
	gdk_window_raise(props->window);
      return;
    }

  props=gnome_property_box_new();  
  gtk_signal_connect(GTK_OBJECT(props),"apply",
		     GTK_SIGNAL_FUNC(apply_properties),data);
  gtk_signal_connect(GTK_OBJECT(props),"destroy",
		     GTK_SIGNAL_FUNC(close_properties),&props);
  gtk_signal_connect(GTK_OBJECT(props),"help",
		     GTK_SIGNAL_FUNC(gnome_help_pbox_display),&help_entry);

  gtk_window_set_title(GTK_WINDOW(props),_("Uptime properties"));
  hbox=gtk_hbox_new(FALSE,GNOME_PAD);
  vbox=gtk_vbox_new(FALSE,GNOME_PAD);

  /* create update-rate entry field */
  adj=(GtkAdjustment *)gtk_adjustment_new((gfloat)(utd->update_rate),
					  UPDATE_LOW,UPDATE_HIGH,
					  1,10,UNUSED);
  entry=gtk_spin_button_new(adj,1,0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(entry),TRUE);
  gtk_signal_connect(GTK_OBJECT(adj),"value_changed",
		     GTK_SIGNAL_FUNC(cb_adj),&utd->update_hold);
  gtk_object_set_data(GTK_OBJECT(adj),"prop",props);
  label=gtk_label_new(_("Update time (seconds)"));
  gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(hbox),entry,FALSE,FALSE,0);
  gtk_widget_show(label);
  gtk_widget_show(entry);

  /* create resync-time entry field */
  adj=(GtkAdjustment *)gtk_adjustment_new((gfloat)(utd->resync_val),
					  RESYNC_LOW,RESYNC_HIGH,
					  1,10,UNUSED);
  entry=gtk_spin_button_new(adj,1,0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(entry),TRUE);
  gtk_signal_connect(GTK_OBJECT(adj),"value_changed",
		     GTK_SIGNAL_FUNC(cb_adj),&utd->resync_hold);
  gtk_object_set_data(GTK_OBJECT(adj),"prop",props);  
  label=gtk_label_new(_("Resync time (minutes)"));
  gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,15);
  gtk_box_pack_start(GTK_BOX(hbox),entry,FALSE,FALSE,0);
  gtk_widget_show(label);
  gtk_widget_show(entry);

  /* pack hbox into vbox, the final product */
  gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
  gtk_widget_show(hbox);
  
  /* next hbox */
  hbox=gtk_hbox_new(FALSE,GNOME_PAD);

  /* create show-seconds toggle box */
  entry=gtk_check_button_new_with_label(_("Show seconds"));
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(entry),utd->show_seconds);
  gtk_signal_connect(GTK_OBJECT(entry),"toggled",
		     GTK_SIGNAL_FUNC(cb_check),&utd->second_hold);
  gtk_object_set_data(GTK_OBJECT(entry),"prop",props);
  gtk_box_pack_start(GTK_BOX(hbox),entry,FALSE,FALSE,0);
  gtk_widget_show(entry);

  /* create show-ident toggle box */
  entry=gtk_check_button_new_with_label(_("Show identification (day, hour, etc)"));
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(entry),utd->show_ident);
  gtk_signal_connect(GTK_OBJECT(entry),"toggled",
		     GTK_SIGNAL_FUNC(cb_check),&utd->ident_hold);
  gtk_object_set_data(GTK_OBJECT(entry),"prop",props);
  gtk_box_pack_start(GTK_BOX(hbox),entry,FALSE,FALSE,80);
  gtk_widget_show(entry);

  /* pack another hbox into vbox, the final product */
  gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
  gtk_widget_show(hbox);

  /* show the resulting box */
  gtk_widget_show(vbox);

  gnome_property_box_append_page(GNOME_PROPERTY_BOX(props),vbox,gtk_label_new(_("Uptime")));

  gtk_widget_show(props);
} /* uptime_properties */
