{
        Acceptance tests for CW sender program
        ======================================

Test the limits of the CW sender program, and verify its response under
error input conditions.

}{

Initialise the test to 30 WPM, 800Hz

}@C1;@P1;@M1;@E1;@O1;@G0;@T800;@W30;{

Demonstrate character set and combinations

}= {CHARSET     } ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"$()+-./:;=?_ ={
}= {MIXED CASE  } The lazy dog jumps over the quick brown fox ={
}= {COMBINATIONS} [AR] [VA] [CT] ={

Test the limits of WPM, Hz, and gap

}@W4;= 4 WPM
@W60;= 60 WPM
@W30;={

}@G0;= GAP 0
@G20;= GAP 20
@G0;={

}@T0;= TONE 0
@T10;= TONE 10
@T1000;= TONE 1000
@T5000;= TONE 5000
@T10000;= TONE 10000
@T800;={

Switch flags on and off

}@E0;= ECHO OFF
@?E@E1;= ECHO ON
@?E@E1;={

}@M0;= MESSAGES OFF
@?M@M1;= MESSAGES ON
@?M@M1;={

}@O0;= {COMBINATIONS OFF} [AR] [VA] [CT]
@?O@O1;= {COMBINATIONS ON} [AR] [VA] [CT]
@?O@O1;={

}@P0;= {COMMENTS OFF, SOUNDED}
@?P@P1;= {COMMENTS ON, NOT SOUNDED}
@?P@P1;={

Test the queries

}= {QUERIES   } @?W@?T@?G@?C@?E@?M@?O@?P ={
}= {CW QUERIES} @>W@>T@>G@>C@>E@>M@>O@>P ={

Tests for errors on input

}= {BAD CHARS       } | \ # { } < > ={
}= {BAD COMMANDS    } @J @B @@ @# @; @| ={
}= {BAD COMMAND ARGS} @W61;@W0;@W-10;@T-1;@T10001;@T-100;@G-1;@G21;@G999; ={
}= {BAD QUERIES     } @?J @?B @?@ @?; @?| ={
}= {BAD CW QUERIES  } @>J @>B @>@ @>; @>| ={

Check that we can quit

}= QUIT @Q THIS TEXT WONT APPEAR
