/* ========================================================================== */
/* === UMFPACK_report_triplet =============================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

/*
    User-callable.  Prints a matrix in triplet form.  See
    umfpack_report_triplet.h for details.
*/

#include "umf_internal.h"

GLOBAL Int UMFPACK_report_triplet
(
    const char name [ ],
    Int n,
    Int nz,
    const Int Ti [ ],
    const Int Tj [ ],
    const double Tx [ ],
    const double Control [UMFPACK_CONTROL]
)
{
    Int prl, prl1, k, i, j ;

    if (Control)
    {
	prl = (Int) Control [UMFPACK_PRL] ;
    }
    else
    {
	prl = UMFPACK_DEFAULT_PRL ;
    }

    if (prl <= 2)
    {
	return (UMFPACK_OK) ;
    }

    PRINTF (("\n")) ;
    if (name)
    {
	PRINTF (("%s: ", name)) ;
    }
    PRINTF (("triplet-form matrix, n = "ID", nz = "ID". ", n, nz)) ;

    if (!Ti || !Tj)
    {
	PRINTF (("ERROR: indices not present\n\n")) ;
	return (UMFPACK_ERROR_argument_missing) ;
    }

    if (n <= 0)
    {
	PRINTF (("ERROR: n is <= 0\n\n")) ;
	return (UMFPACK_ERROR_n_nonpositive) ;
    }

    if (nz < 0)
    {
	PRINTF (("ERROR: nz is < 0\n\n")) ;
	return (UMFPACK_ERROR_nz_negative) ;
    }

    PRINTF4 (("\n")) ;

    prl1 = prl ;
    for (k = 0 ; k < nz ; k++)
    {
	i = Ti [k] ;
	j = Tj [k] ;
	PRINTF4 (("    "ID" : "ID" "ID" ", INDEX (k), INDEX (i), INDEX (j))) ;
	if (Tx)
	{
	    PRINTF4 (("%g", Tx [k])) ;
	}
	PRINTF4 (("\n")) ;
	if (i < 0 || i >= n || j < 0 || j >= n)
	{
	    /* invalid triplet */
	    PRINTF (("ERROR: invalid triplet\n\n")) ;
	    return (UMFPACK_ERROR_invalid_triplet) ;
	}
	if (prl == 4 && k == 9 && nz > 10)
	{
	    PRINTF (("    ...\n")) ;
	    prl-- ;
	}
    }
    prl = prl1 ;

    PRINTF4 (("    ")) ;
    if (name)
    {
	PRINTF4 (("%s: ", name)) ;
    }
    PRINTF4 (("triplet-form matrix ")) ;
    PRINTF (("OK\n\n")) ;
    return (UMFPACK_OK) ;
}

