/* ========================================================================== */
/* === umfpack_get_symbolic ================================================= */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

int umfpack_get_symbolic
(
    int *n,
    int *nz,
    int *nfr,
    int *nchains,
    int *nsparse_col,
    int Qtree [ ],
    int Front_npivots [ ],
    int Front_parent [ ],
    int Chain_start [ ],
    int Chain_maxrows [ ],
    int Chain_maxcols [ ],
    void *Symbolic
) ;

long umfpack_l_get_symbolic
(
    long *n,
    long *nz,
    long *nfr,
    long *nchains,
    long *nsparse_col,
    long Qtree [ ],
    long Front_npivots [ ],
    long Front_parent [ ],
    long Chain_start [ ],
    long Chain_maxrows [ ],
    long Chain_maxcols [ ],
    void *Symbolic
) ;

/*
int Syntax:

    #include "umfpack.h"
    int status, n, nz, nfr, nchains, nsparse_col, *Qtree,
	*Front_npivots, *Front_parent, *Chain_start, *Chain_maxrows,
	*Chain_maxcols ;
    void *Symbolic ;
    status = umfpack_get_symbolic (&n, &nz, &nfr, &nchains, &nsparse_col,
	Qtree, Front_npivots, Front_parent, Chain_start, Chain_maxrows,
	Chain_maxcols, Symbolic) ;

long Syntax:

    #include "umfpack.h"
    long status, n, nz, nfr, nchains, nsparse_col, *Qtree,
	*Front_npivots, *Front_parent, *Chain_start, *Chain_maxrows,
	*Chain_maxcols ;
    void *Symbolic ;
    status = umfpack_l_get_symbolic (&n, &nz, &nfr, &nchains, &nsparse_col,
	Qtree, Front_npivots, Front_parent, Chain_start, Chain_maxrows,
	Chain_maxcols, Symbolic) ;

Purpose:

    Copies the contents of the Symbolic object into simple integer arrays
    accessible to the user.  This routine is not needed to factorize
    and/or solve a sparse linear system using UMFPACK.  Note that the output
    arrays Qtree, Front_npivots, Front_parent, Chain_start, Chain_maxrows,
    and Chain_maxcols are not allocated by umfpack_get_symbolic;  they must
    exist on input.

    The Symbolic object is small.  It size, in integers, is
    (3*nchains + n + 2*nfr + 20), which is no greater than 6*n+20.  The object
    holds the initial column permutation, the supernodal column elimination
    tree, and information about each frontal matrix.  You can print it with
    umfpack_report_symbolic.

Returns:

    Returns UMFPACK_OK if successful, UMFPACK_ERROR_invalid_Symbolic_object
    if Symbolic is an invalid object.

Arguments:

    Note that if any of the output arguments are (Int *) NULL pointers, then
    that argument is not returned.  This is not an error condition.  Thus,
    if you do not want a particular component of the Symbolic object to be
    returned to you, simply pass a (Int *) NULL pointer for that particular
    output argument.

    Int *n ;		Output argument.

	The dimension of the matrix A analyzed by the call to umfpack_symbolic
	that generated the Symbolic object.

    Int *nz ;		Output argument.

	The number of nonzeros in A.

    Int *nfr ;	Output argument.

	The number of frontal matrices that will be used by umfpack_numeric
	to factorize the matrix A.  One or more pivots are contained in each
	frontal matrix, and the total number of pivots in the frontal matrices
	is n (see the description of nsparse_col, below).
	Thus, nfr is in the range 1 to n.

    Int *nchains ;	Output argument.

	The frontal matrices are related to one another by the supernodal
	column elimination tree.  Each node in this tree is one frontal matrix.
	The tree is partitioned into a set of disjoint paths, and a frontal
	matrix chain is one path in this tree.  Each chain is factorized using
	a unifrontal technique, with a single working array that holds each
	frontal matrix in the chain, one at a time.  nchains is in the range
	1 to nfr.

    Int *nsparse_col ;	Output argument.

	This is equal to n.  It differed from n in Version 3.0.

    Int Qtree [n] ;	Output argument.

	The initial column permutation.  If Qtree [k] = j, then this means that
	column j is the kth pivot column in the preordered matrix.
	Qtree is not necessarily the same as the final
	column permutation Q, computed by umfpack_numeric.  The numeric
	factorization may reorder the pivot columns within each frontal matrix
	to reduce fill-in.

    Int Front_npivots [nfr] ;	Output argument.

	This array should be of size at least n, in order to guarantee that it
	will be large enough to hold the output.  Only the first nfr entries
	are used, however.  The kth frontal matrix holds Front_npivots [k] pivot
	columns.  Thus, the first frontal matrix, front 0, is used to factorize
	the first Front_npivots [0] columns; these correspond to the original
	columns Qtree [0] through Qtree [Front_npivots [0]-1].  The next frontal
	matrix is used to factorize the next Front_npivots [1] columns, which
	are thus the original columns Qtree [Front_npivots [0]] through
	Qtree [Front_npivots [0] + Front_npivots [1] - 1], and so on.
	The sum of Front_npivots [0..nfr-1] is equal to n.

	Any modifications that umfpack_numeric makes to the initial column
	permutation are constrained to within each frontal matrix.  Thus,
	for the first frontal matrix, Q [0] through Q [Front_npivots [0]-1] is
	some permutation of the columns Qtree [0] through
	Qtree [Front_npivots [0]-1].  For second frontal matrix,
	Q [Front_npivots [0]] through Q [Front_npivots [0] + Front_npivots[1]-1]
	is some permutation of the same portion of Qtree, and so on.  All pivot
	columns are numerically factorized within the frontal matrix originally
	determined by the symbolic factorization; there is no delayed pivoting
	across frontal matrices.

    Int Front_parent [nfr] ;	Output argument.

	This array should be of size at least n, in order to guarantee that it
	will be large enough to hold the output.  Only the first nfr entries
	are used, however.  Front_parent [0..nfr-1] holds the supernodal column
	elimination tree.  Each node in the tree corresponds to a single frontal
	matrix.  The parent of node f is Front_parent [f].

    Int Chain_start [nchains+1] ;	Output argument.

	This array should be of size at least n+1, in order to guarantee that it
	will be large enough to hold the output.  Only the first nchains+1
	entries are used, however.  The kth frontal matrix chain consists of
	frontal matrices Chain_start [k] through Chain_start [k+1]-1.  Thus,
	Chain_start [0] is always 0, and Chain_start [nchains] is the total
	number of frontal matrices, nfr.  For two adjacent fronts f and f+1
	within a single chain, f+1 is always the parent of f (that is,
	Front_parent [f] = f+1).

    Int Chain_maxrows [nchains] ;	Output argument.
    Int Chain_maxcols [nchains] ;	Output argument.

	These arrays should be of size at least n, in order to guarantee that
	they will be large enough to hold the output.  Only the first nchains
	entries of Chain_maxrows and Chain_maxcols are used, however.  The kth
	frontal matrix chain requires a single working array of dimension
	Chain_maxrows [k] by Chain_maxcols [k], for the unifrontal technique
	that factorizes the frontal matrix chain.  Since the symbolic
	factorization only provides an upper bound on the size of each frontal
	matrix, not all of the working array is necessarily used during the
	numerical factorization.

	Note that the upper bound on the number of rows and columns of each
	frontal matrix is computed by umfpack_symbolic, but all that is
	required by umfpack_numeric is the maximum of these two sets of
	values for each frontal matrix chain.  Thus, the size of each
	individual frontal matrix is not preserved in the Symbolic object.

    void *Symbolic ;			Input argument, not modified.

	The Symbolic object, which holds the symbolic factorization computed by
	umfpack_symbolic.  The Symbolic object is not modified by
	umfpack_get_symbolic.

*/

