/* ========================================================================== */
/* === UMF_report_perm ====================================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

#include "umf_internal.h"

GLOBAL Int UMF_report_perm
(
    const char name [ ],
    Int n,
    const Int P [ ],
    Int W [ ],		/* workspace of size n */
    Int prl,
    Int user
)
{
    Int i, k, valid, prl1 ;

    ASSERT (prl >= 3) ;

    if (user || prl >= 4)
    {
	PRINTF (("\n")) ;
	if (name)
	{
	    PRINTF (("%s: ", name)) ;
	}
	PRINTF (("permutation vector, n = "ID". ", n)) ;
    }

    if (n <= 0)
    {
	PRINTF (("ERROR: length of permutation is <= 0\n\n")) ;
	return (UMFPACK_ERROR_n_nonpositive) ;
    }

    if (!P)
    {
	/* if P is (Int *) NULL, this is the identity permutation */
	PRINTF (("(not present)\n\n")) ;
	return (UMFPACK_OK) ;
    }

    if (!W)
    {
	PRINTF (("ERROR: out of memory\n\n")) ;
	return (UMFPACK_ERROR_out_of_memory) ;
    }

    if (user || prl >= 4)
    {
	PRINTF4 (("\n")) ;
    }

    for (i = 0 ; i < n ; i++)
    {
	W [i] = TRUE ;
    }

    prl1 = prl ;
    for (k = 0 ; k < n ; k++)
    {
	i = P [k] ;
	PRINTF4 (("    "ID" : "ID" ", INDEX (k), INDEX (i))) ;
	valid = (i >= 0 && i < n) ;
	if (valid)
	{
	    valid = W [i] ;
	    W [i] = FALSE ;
	}
	if (!valid)
	{
	    /* out of range or duplicate entry */
	    PRINTF (("ERROR: invalid\n\n")) ;
	    return (UMFPACK_ERROR_invalid_permutation) ;
	}
	PRINTF4 (("\n")) ;
	if (prl == 4 && k == 9 && n > 10)
	{
	    PRINTF (("    ...\n")) ;
	    prl-- ;
	}
    }
    prl = prl1 ;

    PRINTF4 (("    ")) ;
    if (name)
    {
	PRINTF4 (("%s: ", name)) ;
    }
    PRINTF4 (("permutation vector ")) ;
    if (user || prl >= 4)
    {
	PRINTF (("OK\n\n")) ;
    }
    return (UMFPACK_OK) ;
}

