/* ========================================================================== */
/* === UMF_kernel_wrapup ==================================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

/* The matrix is factorized.  Finish the LU data structure. */

#include "umf_internal.h"

GLOBAL void UMF_kernel_wrapup
(
    NumericType *Numeric,
    SymbolicType *Symbolic,
    WorkType *Work
)
{

    /* ---------------------------------------------------------------------- */
    /* local variables */
    /* ---------------------------------------------------------------------- */

    Int n, i, k, col, row, llen, ulen, *ip, *Rperm, *Cperm, *Lilen,
	*Uilen, *Lip, *Uip, *Cperm_init, up, pivrow, pivcol, *Lpos, *Upos, *W1,
	*W2, *W3, *W6, *W7 ;

#ifndef NDEBUG
    /* this will be nonzero only if matrix is singular */
    ASSERT (Work->ulen == 0) ;
    UMF_dump_matrix (Numeric, Work, FALSE) ;
#endif

    DEBUG0 (("Kernel complete, Starting Kernel wrapup\n")) ;
    n = Symbolic->n ;
    Rperm = Numeric->Rperm ;
    Cperm = Numeric->Cperm ;
    Lilen = Numeric->Lilen ;
    Uilen = Numeric->Uilen ;
    Upos = Numeric->Upos ;
    Lpos = Numeric->Lpos ;

    Lip = Numeric->Lip ;
    Uip = Numeric->Uip ;

    ASSERT (n == Numeric->n) ;
    ASSERT (n == Symbolic->n) ;
    DEBUG0 (("Wrap-up: npiv "ID"\n", Work->npiv)) ;
    ASSERT (Work->npiv == n) ;

    /* size n workspaces that can be used here (total 7n): */
    W1 = Work->Frpos ;
    W2 = Work->Fcpos ;
    W3 = Work->Lpattern ;
    /* W4 = Work->Upattern ;	unused */
    /* W5 = Work->Wp ;		unused */
    W6 = Work->E ;		/* E is of size 2n+1 */
    W7 = W6 + n ;

    /* ---------------------------------------------------------------------- */
    /* construct Rperm from inverse permutations */
    /* ---------------------------------------------------------------------- */

    /* use W6 for copy of inverse row permutation [ */

    for (pivrow = 0 ; pivrow < n ; pivrow++)
    {
	k = Rperm [pivrow] ;
	ASSERT (k < 0) ;
	k = ONES_COMPLEMENT (k) ;
	ASSERT (k >= 0 && k < n) ;
	W1 [k] = pivrow ;
	W6 [pivrow] = k ;
    }
    for (k = 0 ; k < n ; k++)
    {
	Rperm [k] = W1 [k] ;
    }

    /* ---------------------------------------------------------------------- */
    /* construct Cperm from inverse permutation */
    /* ---------------------------------------------------------------------- */

    /* use W7 for copy of inverse column permutation [ */

    for (pivcol = 0 ; pivcol < n ; pivcol++)
    {
	k = Cperm [pivcol] ;
	ASSERT (k < 0) ;
	k = ONES_COMPLEMENT (k) ;
	ASSERT (k >= 0 && k < n) ;
	W1 [k] = pivcol ;
	/* save a copy of the inverse column permutation in W7 */
	W7 [pivcol] = k ;
    }
    for (k = 0 ; k < n ; k++)
    {
	Cperm [k] = W1 [k] ;
    }

#ifndef NDEBUG
    for (k = 0 ; k < n ; k++)
    {
	col = Cperm [k] ;
	ASSERT (col >= 0 && col < n) ;
	ASSERT (W7 [col] == k) ;		/* col is the kth pivot */
	row = Rperm [k] ;
	ASSERT (row >= 0 && row < n) ;
	ASSERT (W6 [row] == k) ;		/* row is the kth pivot */
    }
#endif

#ifndef NDEBUG
    UMF_dump_lu (Numeric) ;
#endif

    /* ---------------------------------------------------------------------- */
    /* permute Lpos, Upos, Lilen, Lip, Uilen, and Uip */
    /* ---------------------------------------------------------------------- */

    for (k = 0 ; k < n ; k++)
    {
	pivrow = Rperm [k] ;
	W1 [k] = Lpos [pivrow] ;
	W2 [k] = Uilen [pivrow] ;
	W3 [k] = Uip [pivrow] ;
    }

    for (k = 0 ; k < n ; k++)
    {
	Lpos [k] = W1 [k] ;
	Uilen [k] = W2 [k] ;
	Uip [k] = W3 [k] ;
    }

    for (k = 0 ; k < n ; k++)
    {
	pivcol = Cperm [k] ;
	W1 [k] = Upos [pivcol] ;
	W2 [k] = Lilen [pivcol] ;
	W3 [k] = Lip [pivcol] ;
    }

    for (k = 0 ; k < n ; k++)
    {
	Upos [k] = W1 [k] ;
	Lilen [k] = W2 [k] ;
	Lip [k] = W3 [k] ;
    }

    /* ---------------------------------------------------------------------- */
    /* terminate the last Uchain and last Lchain */
    /* ---------------------------------------------------------------------- */

    Upos [n] = EMPTY ;
    Lpos [n] = EMPTY ;
    Uip [n] = EMPTY ;
    Lip [n] = EMPTY ;
    Uilen [n] = 0 ;
    Lilen [n] = 0 ;

    /* ---------------------------------------------------------------------- */
    /* convert U to the new pivot order */
    /* ---------------------------------------------------------------------- */

    for (k = 0 ; k < n ; k++)
    {
	up = Uip [k] ;
	if (up < 0)
	{
	    /* this is the start of a new Uchain (with a pattern) */
	    ulen = Uilen [k] ;
	    DEBUG4 (("K "ID" New U.  ulen "ID" End_Uchain 1\n", k-1, ulen)) ;
	    if (ulen > 0)
	    {
		up = -up ;
		ip = (Int *) (Numeric->Memory + up) ;
		for (i = 0 ; i < ulen ; i++)
		{
		    col = *ip ;
		    DEBUG4 (("    old col "ID" new col "ID"\n", col, W7 [col]));
		    ASSERT (col >= 0 && col < n) ;
		    *ip++ = W7 [col] ;
		}
	    }
	}
    }

    /* W7 no longer needed ] */

    /* ---------------------------------------------------------------------- */
    /* convert L to the new pivot order */
    /* ---------------------------------------------------------------------- */

    for (k = 0 ; k < n ; k++)
    {
	llen = Lilen [k] ;
	DEBUG4 (("K "ID" New L.  llen "ID" \n", k, llen)) ;
	if (llen > 0)
	{
	    ip = (Int *) (Numeric->Memory + ABS (Lip [k])) ;
	    for (i = 0 ; i < llen ; i++)
	    {
		row = *ip ;
		DEBUG4 (("    old row "ID" new row "ID"\n", row, W6 [row])) ;
		ASSERT (row >= 0 && row < n) ;
		*ip++ = W6 [row] ;
	    }
	}
    }

    /* W6 no longer needed ] */

    /* ---------------------------------------------------------------------- */
    /* combine Cperm_init and Cperm into a single column permutation */
    /* ---------------------------------------------------------------------- */

    if (Numeric->pivot_option == UMFPACK_DEFAULT_PIVOT_OPTION)
    {
	/* default unsymmetric pivoting */
	Cperm_init = Symbolic->Cperm_init ;
	for (k = 0 ; k < n ; k++)
	{
	    Cperm [k] = Cperm_init [Cperm [k]] ;
	}
    }
    else
    {
	/* Symmetric pivoting. */
	/* also combine Cperm_init (initial row permutation) and Rperm */
	Cperm_init = Symbolic->Cperm_init ;
	for (k = 0 ; k < n ; k++)
	{
	    Rperm [k] = Cperm_init [Rperm [k]] ;
	    Cperm [k] = Cperm_init [Cperm [k]] ;
	}
    }

    /* Work object will be freed immediately upon return (to UMF_kernel */
    /* and then to UMFPACK_numeric). */
}
