/*
	Serial.h  
	RS232 Serial Interface for the standard Atmel Programmer
	Uros Platise(c) copyright 1997-1999
*/

#ifndef __Serial
#define __Serial

#include <sys/types.h>
#include <time.h>
#include <unistd.h>
#include <string>
#include "Global.h"
#include "Error.h"

class TSerial{
private:
  int serline;
  
protected:
  int Tx(unsigned char* queue, int queue_size);
  int Rx(unsigned char* queue, int queue_size, timeval* timeout);

public:
  int Send(unsigned char* queue, int queue_size, int rec_queue_size=-1);

  TSerial();
  ~TSerial();
};

#endif
