/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */


// define UgData-based structure for downloading.
//
// UgData
// |
// +- UgDataCommon
// |
// +- UgDataProxy
// |
// +- UgProgress
// |
// +- UgDataHttp
// |
// +- UgDataFtp
//


#ifndef UG_DATA_DOWNLOAD_H
#define UG_DATA_DOWNLOAD_H

#include <glib.h>
#include <ug_data.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct	UgDataCommon_		UgDataCommon;
typedef struct	UgDataProxy_		UgDataProxy;
typedef struct	UgProgress_			UgProgress;
typedef struct	UgDataHttp_			UgDataHttp;
typedef struct	UgDataFtp_			UgDataFtp;

typedef enum	UgDataProxyType_	UgDataProxyType;

extern	const	UgDataClass*		UgDataCommonClass;
extern	const	UgDataClass*		UgDataProxyClass;
extern	const	UgDataClass*		UgProgressClass;
extern	const	UgDataClass*		UgDataHttpClass;
extern	const	UgDataClass*		UgDataFtpClass;


// ----------------------------------------------------------------------------
// UgDataCommon
//
//	UgData
//	|
//	+- UgDataCommon

struct UgDataCommon_
{
	UG_DATA_MEMBERS (UgDataCommon);
//	const UgDataClass*	data_class;
//	UgDataCommon*		next;
//	UgDataCommon*		prev;

	// common data
	gchar*		name;
	gchar*		url;
	gchar*		file;
	gchar*		folder;
	gchar*		user;
	gchar*		password;

	guint		connect_timeout;	// second
	guint		transmit_timeout;	// second
	guint		retry_delay;		// second
	guint		retry_limit;		// limit of retry_count
	guint		retry_count;		// increase it when receiving UG_MESSAGE_INFO_RETRY

	guint		debug_level;

//	gint64		resume_offset;
//	guint		n_segment;
};


// ---------------------------------------------------------------------------
// UgDataProxy
//
//	UgData
//	|
//	+- UgDataProxy

enum UgDataProxyType_ {
	UG_DATA_PROXY_NONE,
	UG_DATA_PROXY_DEFAULT,			// Decided by plug-ins
	UG_DATA_PROXY_HTTP,
	UG_DATA_PROXY_SOCKS4,
	UG_DATA_PROXY_SOCKS5
};

struct UgDataProxy_
{
	UG_DATA_MEMBERS (UgDataProxy);
//	const UgDataClass*	data_class;
//	UgDataProxy*		next;
//	UgDataProxy*		prev;

	gchar*				host;
	guint				port;
	UgDataProxyType		type;

	gchar*				user;
	gchar*				password;
};


// ---------------------------------------------------------------------------
// UgProgress
//
//	UgData
//	|
//	+- UgProgress

struct UgProgress_
{
	UG_DATA_MEMBERS (UgProgress);
//	const UgDataClass*	data_class;
//	UgDataProgress*		next;
//	UgDataProgress*		prev;

	gint64		complete;
	gint64		total;
	gdouble		percent;
	gdouble		current_speed;
	gdouble		average_speed;
	gdouble		consume_time;		// Elapsed	(seconds)
	gdouble		remain_time;		// Left		(seconds)

	// optional
	gchar*		file;				// filename

//	guint		n_segments;			// 1 segment = 1 offset + 1 length
//	gint64*		segments;			// offset1, length1, offset2, length2
};


// ---------------------------------------------------------------------------
// UgDataHttp
//
//	UgData
//	|
//	+- UgDataHttp

struct UgDataHttp_
{
	UG_DATA_MEMBERS (UgDataHttp);
//	const UgDataClass*	data_class;
//	UgDataHttp*			next;
//	UgDataHttp*			prev;

	gchar*		user;
	gchar*		password;
	gchar*		referer;
	gchar*		user_agent;

	gchar*		post_data;
	gchar*		post_file;
	gchar*		cookie_data;
	gchar*		cookie_file;

	guint		redirection_limit;
};


// ---------------------------------------------------------------------------
// UgDataFtp
//
//	UgData
//	|
//	+- UgDataFtp

struct UgDataFtp_
{
	UG_DATA_MEMBERS (UgDataFtp);
//	const UgDataClass*	data_class;
//	UgDataFtp*			next;
//	UgDataFtp*			prev;

	gchar*		user;
	gchar*		password;

	gboolean	extended_passive_mode;
};


#ifdef __cplusplus
}
#endif

#endif  // End of UG_DATA_DOWNLOAD_H

