/* ==================================================== ======== ======= *
 *
 *  uucolor.cpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:02] ======= *
 * ==================================================== ======== ======= */

//#pragma ident	"@(#)uucolor.cpp		ubit:03.06.04"
#include <limits.h>
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uerror.hpp>
#include <ucontext.hpp>
#include <ustr.hpp>
#include <uctrl.hpp>
#include <ucolor.hpp>
#include <unatgraph.hpp>
#include <ucolorImpl.hpp>
#include <uappli.hpp>
#include <ubox.hpp>
#include <update.hpp>


/* !!ATT: cette implementation suppose que les pixels ne sont utilises
 * que sur les 24 bits de droite !
 * de plus, il faut:  valid pixels < UNDEF < NONE < INHERIT <= ULONG_MAX
 */
const UX_Color 
  UColorImpl::UNDEF   = ULONG_MAX-2, 
  UColorImpl::NONE    = ULONG_MAX-1, 
  UColorImpl::INHERIT = ULONG_MAX;


UColor UColor::inherit(new UColorImpl("inherit",UColorImpl::INHERIT), 
		       UMode::UCONST);
UBgcolor UBgcolor::inherit(UColor::inherit, UMode::UCONST);

UBgcolor UBgcolor::none(new UColorImpl("none", UColorImpl::NONE), 
			UMode::UCONST);
UColor UColor::none(UColor::none, UMode::UCONST);


UColor UColor::black(new UColorImpl("#000000"), UMode::UCONST);
UBgcolor UBgcolor::black(UColor::black, UMode::UCONST);

UColor UColor::white(new UColorImpl("#ffffff"), UMode::UCONST);
UBgcolor UBgcolor::white(UColor::white, UMode::UCONST);

UColor UColor::disabled(new UColorImpl("grey55"), UMode::UCONST);

UColor UColor::lightgrey(new UColorImpl("grey95"),UMode::UCONST);
UBgcolor UBgcolor::lightgrey(UColor::lightgrey, UMode::UCONST);

UColor UColor::grey(new UColorImpl("#dadada"), UMode::UCONST);  // #cccccc
UBgcolor UBgcolor::grey(UColor::grey, UMode::UCONST);

UColor UColor::darkgrey(new UColorImpl("#bababa"), UMode::UCONST);
UBgcolor UBgcolor::darkgrey(UColor::darkgrey, UMode::UCONST);

UColor UColor::navy(new UColorImpl("navy"), UMode::UCONST);
UBgcolor UBgcolor::navy(UColor::navy, UMode::UCONST);

//UColor UColor::blue(new UColorImpl("blue"), UMode::UCONST);
//UBgcolor UBgcolor::blue(UColor::blue, UMode::UCONST);
UColor UColor::blue(new UColorImpl("steelblue"), UMode::UCONST);
UBgcolor UBgcolor::blue(UColor::blue, UMode::UCONST);

UColor UColor::red(new UColorImpl("red"), UMode::UCONST);
UBgcolor UBgcolor::red(UColor::red, UMode::UCONST);

UColor UColor::green(new UColorImpl("#00dd00"), UMode::UCONST);
UBgcolor UBgcolor::green(UColor::green, UMode::UCONST);

UColor UColor::yellow(new UColorImpl("yellow"), UMode::UCONST);
UBgcolor UBgcolor::yellow(UColor::yellow, UMode::UCONST);

UColor UColor::lightyellow(new UColorImpl("#ffffa0"), UMode::UCONST);
UBgcolor UBgcolor::lightyellow(UColor::lightyellow, UMode::UCONST);

UColor UColor::orange(new UColorImpl("orange"), UMode::UCONST);
UBgcolor UBgcolor::orange(UColor::orange, UMode::UCONST);

UColor UColor::wheat(new UColorImpl("wheat"), UMode::UCONST);
UBgcolor UBgcolor::wheat(UColor::wheat, UMode::UCONST);

UColor UColor::teal(new UColorImpl("CadetBlue"), UMode::UCONST);
UBgcolor UBgcolor::teal(UColor::teal, UMode::UCONST);

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// nb: error if colspec is null

UColorImpl::UColorImpl(const char* colspec) {
  refcount = 0;
  natspec  = CStr::strdup(colspec);
  colors.push_back(UNDEF);
}

UColorImpl::UColorImpl(const char* colspec, UX_Color col) {
  refcount = 0;
  natspec  = CStr::strdup(colspec);
  colors.push_back(col);
}

UColorImpl::~UColorImpl() {
  free(natspec);
}

void UColorImpl::removeRef() {
  refcount--;
  if (refcount == 0
      /*
      && isBmode(UMode::CAN_DEL)
      && !hasValidParent()
      */
      ) {
    delete this;
  }
}

bool UColorImpl::equals(const UColorImpl& ci2) const {
  if (colors[0] != UNDEF) 
    return (colors[0] == ci2.colors[0]);  //!!att si plusieurs disp!!
  else if (!natspec || !ci2.natspec) 
    return false;
  else 
    return (strcmp(natspec, ci2.natspec) == 0);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UColor::UColor() {ci = black.ci;}                // cas valeur par default
UColor::UColor(const UColor& _c) {ci = _c.ci;}
UColor::UColor(const UColor& _c, u_modes m) : UProp(m) {ci = _c.ci;}
UColor::UColor(UColorImpl* _ci, u_modes m)  : UProp(m) {ci = _ci;}

UColor::UColor(const UStr& colspec) {
  if (colspec.empty()) {
    error("set", "[warning] null color spec (Black assumed)");
    ci = black.ci;
  }
  else ci = new UColorImpl(colspec.chars());
}

UColor::UColor(const char* colspec) {
  if (!colspec) {
    error("set", "[warning] null color spec (Black assumed)");
    ci = black.ci;
  }
  else ci = new UColorImpl(colspec);
}

UColor::~UColor() {}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

UBgcolor::UBgcolor() : UColor(white) {}          // cas valeur par default
UBgcolor::UBgcolor(const UColor& _c) : UColor(_c) {}
UBgcolor::UBgcolor(const UColor& _c, u_modes m) : UColor(_c, m)  {}
UBgcolor::UBgcolor(UColorImpl* _ci, u_modes m)  : UColor(_ci, m) {}

UBgcolor::UBgcolor(const char* colspec) : UColor(colspec) {}
UBgcolor::UBgcolor(const UStr& colspec) : UColor(colspec) {}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UColor& UColor::operator=(const UColor&c) {
  set(c);
  return *this;
}

UBgcolor& UBgcolor::operator=(const UColor&c) {
  set(c);
  return *this;
}

void UColor::set(const UColor&c) {
  if (equals(c)) return;
  ci = c.ci;
  changed(true);
}

void UColor::set(const UStr& colspec) {
  set(colspec.chars());
}

void UColor::set(const char* colspec) {
  if (!colspec || !*colspec) {
    error("set", "[warning] null color spec (Black assumed)");
    ci = black.ci;
    return;
  }

  if (strcmp(ci->natspec,colspec)==0) return;

  ci = new UColorImpl(colspec);
  changed(true);
}

bool UColor::equals(const UColor& c2) const {
  if (ci == c2.ci) return true;
  else return (ci->equals(*c2.ci));
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UColor::update() {
  parents.updateParents(UUpdate::paint); //size unchanged
}

void UColor::putProp(UContext* props, UCtrl* ctrl) {
  props->color = this;
}

void UBgcolor::putProp(UContext* props, UCtrl* ctrl) {
  props->bgcolor = this;
}

bool UColor::realize(UDisp *d) {
  return d->realizeColor(*this);
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
