/* ==================================================== ======== ======= *
 *
 *  uumenu.cc
 *  Ubit Project [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uumenu.cc	ubit:b1.10.1"
#include <ubrick.hh>
#include <uconfig.hh>
#include <ucall.hh>
#include <uprop.hh>
#include <ustr.hh>
#include <uctrl.hh>
#include <ubox.hh>
#include <uwin.hh>
#include <uwinImpl.hh>
#include <uview.hh>
#include <uviewImpl.hh>
#include <uevent.hh>
#include <ustyle.hh>
#include <ucolor.hh>
#include <uborder.hh>
#include <ugraph.hh>
#include <unat.hh>
#include <uappli.hh>
#include <umenu.hh>
#include <umenuImpl.hh>
#include <uobs.hh>

// maximum number of cascaded menus
const int UMenuCtrl::CASCADED_MENU_MAX_COUNT = 25;

const UClass UMenubar::uclass("UMenubar");
const UClass UMenu::uclass("UMenu");
const UClass UPopmenu::uclass("UPopmenu");

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UStyle *UMenubar::style = null;

const UStyle* UMenubar::getStyle(const UBox*) {
  if (!style) {
    style = new UStyle(null);
    style->local.orient   = UOrient::horizontal.get();
    style->local.halign   = UHalign::left.get();
    style->local.valign   = UValign::flex.get();
    style->local.hspacing = 5;
    style->local.vspacing = 5;
    style->local.padding.set(2, 2); //!!
    style->local.border   = &UBorder::shadowOut;
  }
  return style;
}

UMenubar::UMenubar(UArgs a): UBar(a) {
  // recupere evenements dans les enfants
  onChildrenEvents(ucall(this, &UMenubar::enterChildCB, UOn::enter)
		   + ucall(this, &UMenubar::leaveChildCB, UOn::leave)
		   + ucall(this, &UMenubar::relaxChildCB, UOn::mrelax)
		   //+ ucall(this, &UMenubar::disarmChildCB, UOn::disarm)
		   );
}

UMenubar& umenubar(UArgs l) {return *(new UMenubar(l));}


/* ==================================================== ======== ======= */
/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

UStyle *UMenu::style = null;

const UStyle* UMenu::getStyle(const UBox *parent) {
  if (!style) {
    style = new UStyle(null);
    style->local.orient   = UOrient::vertical.get();
    style->local.halign   = UHalign::flex.get();
    style->local.valign   = UValign::top.get();
    style->local.hspacing = 1;
    style->local.vspacing = 1;
    style->local.padding.set(0, 0);
    style->local.border   = &UBorder::shadowOut;
    style->font           = &UFont::standard;
    style->fgcolors = UStyle::makeColors(&UColor::black,&UColor::white); 
    style->bgcolors = UStyle::makeColors(&UBgcolor::grey, &UBgcolor::black);
  }
  return style;
}

const UStyle* UPopmenu::getStyle(const UBox *parent) {
  return UMenu::getStyle(parent);
}

UGroup* UMenu::getBrowseGroup() {
  return (menuBrowseGroup ? menuBrowseGroup : this);
}

UMenu& umenu(UArgs l) {return *(new UMenu(l));}
UPopmenu& upopmenu(UArgs l) {return *(new UPopmenu(l));}

/* ==================================================== ======== ======= */

UMenu::UMenu(UArgs l) : UWin(l) {
  setCmodes(UMode::HAS_AUTOCLOSE_BHV | UMode::AUTOCLOSE_BHV, true);
  menuBrowseGroup = null;
  placement = null;
  enter_opener = arm_opener = disarm_opener = null;
  // recupere evenements dans les enfants
  onChildrenEvents(ucall(this, &UMenu::enterChildCB, UOn::enter)
		   + ucall(this, &UMenu::leaveChildCB, UOn::leave)
		   + ucall(this, &UMenu::relaxChildCB, UOn::mrelax)
		   //+ ucall(this, &UMenu::disarmChildCB, UOn::disarm)
     );
}

UPopmenu::UPopmenu(UArgs l) : UMenu(l) {
  //opening is automatic if != 0
  //openingMode = 0;
  setCmodes(UMode::AUTOOPEN_BHV, false);
}

/* ==================================================== ======== ======= */

void UMenu::addingTo(ULink *selflink, UGroup *parent) {
  UWin::addingTo(selflink, parent);
  //if (openingMode != 0) {
  if (isDef(0, UMode::AUTOOPEN_BHV)) {
    if (!enter_opener) {
      //doit etre arm et pas mpress, car arm change le BrowseGroup
      // (et disarm egalement)
      // NB:                                   !! prendre en compte arm 3 !!
      enter_opener = &ucall(this, &UMenu::enterOpenerCB, UOn::enter);
      arm_opener   = &ucall(this, &UMenu::armOpenerCB, UOn::arm);
      disarm_opener= &ucall(this, &UMenu::disarmOpenerCB, UOn::disarm);
   }
    //!!ATT: risque de pas marcher si le parent est un UGroup !!!
    // mais c'est un bug a corriger ailleurs ...
    parent->addlist(*enter_opener + arm_opener + disarm_opener);
 }
}

/* ==================================================== ======== ======= */
// necessaire a cause de removingFrom (car les fct ne sont pas virtuelles
// dans les desctructeurs!)
UMenu::~UMenu() {
  // att: reset du MenuCtrl si on detruit le menu
  // (note que closeGrabbedMenusFrom serait OK avec stop_auto_open_mode)
  //if (wingraph && (a = wingraph->getAppli())) 
  UAppli *a = getAppli();
  if (a) a->menuCtrl->closeAllGrabbedMenus(true);
  clean();
}

//NB: removingFrom() requires a destructor to be defined
void UMenu::removingFrom(ULink *selflink, UGroup *parent) {
  if (enter_opener) {
    // don't delete the ucalls as they are shared
    parent->remove(enter_opener, false);
    parent->remove(arm_opener, false);
    parent->remove(disarm_opener, false);
  }
  UWin::removingFrom(selflink, parent);
}

u_bool UMenu::realize() {
  if (is_hardwin) return realizeHardwin(&UNatWin::realizeMenu);
  else {
    error("realize", UError::CANT_REALIZE_SOFTWIN);
    return false;
  }
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UMenuCtrl::UMenuCtrl(UAppli *a){
  appli = a;
  // grabbed menus
  menuGrabCount = 0;
  menuGrabStack = (UGroup**) malloc((CASCADED_MENU_MAX_COUNT+1) * sizeof(UGroup*));
  for (int k = 0; k <= CASCADED_MENU_MAX_COUNT; k++)  menuGrabStack[k] = null;
  autoOpenMenus = activeMenuOpener = false;
  lastOpenedMenu = null;
}

u_bool UMenuCtrl::currentGrab() {
  return (menuGrabCount > 0);
}

u_bool UMenuCtrl::isGrabbed(UGroup* menu) {
  for (int k = 0; k < menuGrabCount; k++) 
    if (menuGrabStack[k] == menu) return true;
  return false;			// not found
}

void UMenuCtrl::registerGrabbedMenu(UGroup *menu) {
  if (menuGrabCount <= CASCADED_MENU_MAX_COUNT) {
    menuGrabStack[menuGrabCount] = menu;
    menuGrabCount++;
  }
  //fprintf(stderr, "openGrabbedMenu new count= %d\n", menuGrabCount);
  //deplace dans menushow()
  //menu->UGroup::show(true); 
}

void UMenuCtrl::closeAllGrabbedMenus(u_bool stop_auto_open_mode) {
  //fprintf(stderr, "closeAllGrabbedMenus %d\n", stop_auto_open_mode);
  // fermer les menus
  /* 	// ????ne sert a rien (fait automatiquement par X)
  if (menuGrabCount > 0) {
    UWin *win = dynamic_cast<UWin*>(menuGrabStack[0]);
    win->getWinView()ff->wg().ungrabPointer();
  }
  */
  for (int k = 0; k < menuGrabCount; k++) {
    // !!ATT: standard show() mthd, not the specific close() mthd.
    menuGrabStack[k]->show(false);
  }
  menuGrabCount = 0;

  appli->setBrowseGroup(null);   // securite

  if (stop_auto_open_mode) {
    lastOpenedMenu = null;
    autoOpenMenus = activeMenuOpener = false;
  }
  //fprintf(stderr, "closeAllGrabbedMenus autoOpenMenus %d\n\n", autoOpenMenus);
}


// ferme tous les grabbed menus sauf 'menu' et ceux qui l'ont ouvert
// (ie qui sont au dessus dans la liste)

void UMenuCtrl::closeGrabbedMenusFrom(UGroup *menu, 
				      u_bool including_this_menu) {
  //fprintf(stderr, "closeGrabbedMenusFrom %d\n\n", menu);
  int k, found = -1;
  for (k = 0; k < menuGrabCount; k++)
    if (menuGrabStack[k] == menu) {
      found = k;      
      break;
    }

  if (found < 0) {// not found
    closeAllGrabbedMenus(false);
    return;
  }

  // if !included skip this menu
  if (!including_this_menu) {k++; found++;}

  for ( ; k < menuGrabCount; k++) {
    // !!ATT: standard show() mthd, not the specific close() mthd.
    menuGrabStack[k]->show(false);
  }
  menuGrabCount = found;
}

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

void UMenu::enterOpenerCB(UEvent *e) {
  UAppli *a = getAppli();
  UMenuCtrl *mc = a->getMenuCtrl();

  // si autoOpenMode et meme browse group, alors auto ouvrir
  if (mc->autoOpenMenus
      && e->getParentContext() && a->getBrowseGroup()
      && e->getParentContext()->browseGroup == a->getBrowseGroup()) {

    openImpl(a, e->getView(), // <- opener_view, v menuGroup
	     (e->getParentContext() ? e->getParentContext()->browseGroup : null),
	     true);  //autoplace
  }
}

// toujours appele APRES enterOpenerCB qunad ce dernier est applicable

void UMenu::enterChildCB(UEvent *e) {
  UAppli *a = getAppli();
  UMenuCtrl *mc = a->getMenuCtrl();

  if (e->getSource() != this) {
    if (!mc->activeMenuOpener
	&& mc->lastOpenedMenu
	&& !e->getSource()->isChildOf(mc->lastOpenedMenu, true)
	) {
      mc->closeGrabbedMenusFrom(this, false);
      mc->lastOpenedMenu = null;
    }
  }
}
void UMenubar::enterChildCB(UEvent *e) {
  UAppli *a = e->getView()->getAppli();
  UMenuCtrl *mc = a->getMenuCtrl();

  if (e->getSource() != this) {
    if (!mc->activeMenuOpener && mc->lastOpenedMenu) {
      mc->closeGrabbedMenusFrom(mc->lastOpenedMenu, true);
      mc->lastOpenedMenu = null;
    }
  }
}

void UMenu::leaveChildCB(UEvent *e) {
  UAppli *a = getAppli();
  if (e->getSource() != this)
    a->getMenuCtrl()->activeMenuOpener = false;
}
void UMenubar::leaveChildCB(UEvent *e) {
  UAppli *a = e->getView()->getAppli();
  if (e->getSource() != this) 
    a->getMenuCtrl()->activeMenuOpener = false;
}

void UMenu::armOpenerCB(UEvent *e) {
  UAppli *a = getAppli();
  openImpl(a, e->getView(), // <- opener_view, v menuGroup
	   (e->getParentContext() ? e->getParentContext()->browseGroup : null),
	   true);
}

/* ==================================================== ======== ======= */

void UMenu::disarmOpenerCB(UEvent *e) {
  UAppli *a = getAppli();
  UMenuCtrl *mc = a->getMenuCtrl();

  // Cette fonction est appelee par les boutons qui ouvrent un submenu.
  // Elle a pour effet de reinitialiser le browseGroup 
  // et les vars d'etat du menuCtrl
  a->setBrowseGroup(menuBrowseGroup);
  mc->lastOpenedMenu = this;
  mc->autoOpenMenus = mc->activeMenuOpener = true;
}

// toujours invoque APRES le disarm (si celui-ci a ete appele)

void UMenu::relaxChildCB(UEvent *e) {
  UAppli *a = getAppli();
  UMenuCtrl *mc = a->getMenuCtrl();

  // if (e->getSource() != this) test supprime car il faut qu'un 
  // mrelease sur le menu ou un objet non reactif ferme ce menu
  //if (!mc->activeMenuOpener) mc->closeAllGrabbedMenus(true);
  if (!mc->activeMenuOpener
      && e->getSource()
      && e->getSourceContext() && e->getSourceContext()->autoClose)
    mc->closeAllGrabbedMenus(true);
}

void UMenubar::relaxChildCB(UEvent *e) {
  UAppli *a = e->getView()->getAppli();
  UMenuCtrl *mc = a->getMenuCtrl();
  if (!mc->activeMenuOpener
      && e->getSource()
      //&& e->getSource()->isDef(0, UMode::CAN_CLOSE_MENU))
      /*
      && (e->getSource()->isAllDef(0,UMode::HAS_AUTOCLOSE_BHV|UMode::AUTOCLOSE_BHV)
	  || (e->getParentContext() && e->getParentContext()->autoClose))
      ) {
      */
      && e->getSourceContext() && e->getSourceContext()->autoClose)
    mc->closeAllGrabbedMenus(true);
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

void UMenu::close() {
  UAppli *a = getAppli();
  if (a) a->getMenuCtrl()->closeGrabbedMenusFrom(this, true);
}

void UMenu::open() {
  UAppli *a = getAppli();
  if (!a) error("open", UError::UNREALIZED_WINDOW);
  else openImpl(a, null, null, false);
}

void UMenu::open(UEvent *e, u_dim delta_x, u_dim delta_y) {
  UAppli *a = getAppli();
  if (!a) error("open", UError::UNREALIZED_WINDOW);
  else {
    move(e, delta_x, delta_y);
    openImpl(a, e->getView(), null, false);
  }
}

void UMenu::open(UView *opener, u_pos x_inview, u_pos y_inview) {
  UAppli *a = getAppli();
  if (!a) error("open", UError::UNREALIZED_WINDOW);
  else {
    move(opener, x_inview, y_inview);
    openImpl(a, opener, null, false);
  }
}

void UMenu::open(UView *opener, UPlacement &pl) {
  UAppli *a = getAppli();
  if (!a) error("open", UError::UNREALIZED_WINDOW);
  else {
    move(opener, pl);
    openImpl(a, opener, null, false);
  }
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

void UMenu::openImpl(UAppli *a, UView *opener, UGroup *menugroup, 
		     u_bool auto_place) {
  if (!winview)  {
    error("openImpl", UError::UNREALIZED_WINDOW);
    return;
  };
  UMenuCtrl *mc = a->getMenuCtrl();
  UBox *parent_menu = null;
  u_bool is_cascaded;

  //printf("openImpl this %d / isShowable(%d) [menuview=%d] menu_group=%d, auto_place: %dn", 
  // this, isShowable(), menuview, menu_group, auto_place);

  // si le menu est deja ouvert, alors le fermer (comportement standard)
  //if (isShowable()) {
  //  close();
  //  return;
  //}

  //inutile de reafficher dans ce cas (provoque un flicking)
  //if (menuview->getBox() == a->lastGrabbedMenu()) {
  //  printf("same_menu \n");  //chercher si dans liste
  //  return;
  //}

  if (mc->currentGrab()
      // s'il y a deja un MenuGrab et la Win qui contient l'opener est egalement
      // un menu (de type UMenu ou UPopmenu) alors le menu que l'on veut 
      // maintenant afficher est cascade 
      // ==> ne pas enlever tous les menus deja affiche par closeAllGrabbedMenus
      //     mais enlever seulement ceux qui ont ete ouverts apres le menu
      //     qui contient l'opener (= 'parent_menu')
      && opener
      // && ((parent_menu = dynamic_cast<UMenu*>(opener->getWinView()->getBox())))

      // !!! FAUX pour softwins !!!!!!                 !!!!!
      && ((parent_menu = dynamic_cast<UMenu*>(opener->getHardwin())))
      ) {
    is_cascaded = true;
    mc->closeGrabbedMenusFrom(parent_menu, false);
  }
  else {
    is_cascaded = false;
    //fprintf(stderr, "--> will closeAllGrabbedMenus [in menu]\n");
    mc->closeAllGrabbedMenus(false);
  }

  // cas d'erreur: le menu ne peut etre realize
  if (is_hardwin) {
    if (!this->realize()) return;
  }

  // affecter le browsingGroup de UAppli:
  // -- c'est celui herite du graphe d'instanciation
  //    (en particulier le cas des menubars ou des menus cascades)
  // -- sauf s'il est nul auquel cas le browsingGroup sera l'opener
  //    qui a provoque l'ouverture du menu (cad: opener_view->getBox())
  // -- et si l'opener est nul ce sera le menu lui-meme

  menuBrowseGroup = menugroup;
  if (!menuBrowseGroup) menuBrowseGroup = this; // le menu lui-meme
  a->setBrowseGroup(menuBrowseGroup);
  mc->lastOpenedMenu = this;
  mc->activeMenuOpener = true;
  mc->autoOpenMenus = true;

  //positionner le menu
  if (opener) {
    if (placement) move(opener, *placement);
    else if (auto_place) {	 // default rules
      UPlacement pl;
      if (is_cascaded) {
	pl.halign = &UHalign::right;
	pl.hoppositeBorder = true;
	pl.hdist = 1;
      }  
      else {
	pl.valign = &UValign::bottom;
	pl.voppositeBorder = true;
	pl.vdist = 1;
      }
      move(opener, pl);
    }
  }

  // ajouter ce menu a la liste des grabbedMenus de l'appli
  mc->registerGrabbedMenu(this);
  show(true);

  // le grab physique fait en sorte que le menu se ferme automatiquement
  // si on clique la souris (ou si ou tape une touche du clavier)
  // qunad la souris est en dehors de l'application
  // (ie. si le grab physique etait supprime les menus resteraient ouverts
  //  en permanence qunad la souris est dans une autre appli, ce qui n'est
  //  pas completement delirant mais n'est pas conforme a l'usage)

  if (is_hardwin)  winview->wg().grabPointer();  //!!!! que hardwin ?
}

void UMenu::setPlacement(const UPlacement *pl) {
  if (placement) delete(placement);
  if (pl) placement = new UPlacement(*pl);
  else placement = null;
}
void UMenu::setPlacement(const UPlacement &pl) {
  setPlacement(&pl);
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */
