//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Russell Mok 1997
// 
// uEHM.h -- 
// 
// Author           : Russell Mok
// Created On       : Mon Jun 30 16:46:18 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Aug 31 23:47:25 2004
// Update Count     : 164
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_EHM_H__
#define __U_EHM_H__


#define uInitEvent( ae_class ) void *ae_class::uId = 0;
#define uRendezvousAcceptor uSerialMemberInstance.uAcceptor
#define uEHMMaxName 50


//######################### uEHM ########################


class uEHM {
    friend class uKernelBoot;				// access: uTerminateHandler, uUnexpectedHandler
    friend class uMachContext;				// access: uTerminate
    friend class uBaseCoroutine;			// access: uUnexpected
    friend class uBaseTask;				// access: uTerminate

    class uRaiseWorkHorseInit;
    class uEHMAutoResourceCleanup;
    class uAsyncAEMsg;
    class uAsyncAEMsgBuffer;

    enum uFlagT { uThrowF, uDualThrowF, uDualRaiseF, uRaiseF };

    static bool uMatch_exception_type( void *, void *const );
    static bool deliverable_exception( void * );
    static void uTerminate() __attribute__(( noreturn ));
    static void uTerminateHandler() __attribute__(( noreturn ));
    static void uUnexpected() __attribute__(( noreturn ));
    static void uUnexpectedHandler() __attribute__(( noreturn ));
  public:
    class uResumptionHandlers;				// usage generated by translator
    template< typename Exn > class uNullHandlerClause;
    template< typename Exn, typename Functor > class uHandlerClause;

    class uHandlerBase;
    class uDeliverAEStack;
    class uDualClass;
    class uThrowClass;
    class uRaiseClass;

    static void uEHMThrow( const uDualClass &, uBaseCoroutine & );
    static void uEHMThrow( const uThrowClass &, uBaseCoroutine & );
    static void uEHMThrow( const uDualClass & );
    static void uEHMThrow( const uThrowClass & );
    static void uEHMRaise( const uDualClass &, uBaseCoroutine & );
    static void uEHMRaise( const uRaiseClass &, uBaseCoroutine & );
    static void uEHMRaise( const uDualClass & );
    static void uEHMRaise( const uRaiseClass & );
    static void uPoll();
    static void uReRaise();
  private:
    static void uRaiseWorkHorse( const uDualClass &, const bool );
}; // uEHM


//######################### uEHM::uAsyncAEMsg ########################


class uEHM::uAsyncAEMsg : public uSeqable {
    friend class uEHM;
    friend class uEHM::uAsyncAEMsgBuffer;
    friend void uEHM::uEHMThrow( const uDualClass &, uBaseCoroutine & );
    friend void uEHM::uEHMThrow( const uThrowClass &, uBaseCoroutine & );
    friend void uEHM::uEHMRaise( const uDualClass &, uBaseCoroutine & );
    friend void uEHM::uEHMRaise( const uRaiseClass &, uBaseCoroutine & );
    friend void uEHM::uPoll();

    const uFlagT flag;
    bool uHidden;
    uDualClass *ae;

    uAsyncAEMsg &operator=( const uAsyncAEMsg & );
    uAsyncAEMsg( const uAsyncAEMsg & );

    uAsyncAEMsg( const uDualClass &, const uFlagT );
    uAsyncAEMsg( const uThrowClass & );
    uAsyncAEMsg( const uRaiseClass & );
  public:
    ~uAsyncAEMsg();
}; // uEHM::uAsyncAEMsg


//######################### uEHM::uAsyncAEMsgBuffer ########################


// uAsyncAEMsgBuffer looks like public uQueue<uAsyncAEMsg> but with mutex

class uEHM::uAsyncAEMsgBuffer : public uSequence<uEHM::uAsyncAEMsg> {
    friend void uEHM::uPoll();			// access lock
    friend class uTaskMain;
    friend class uCoroutineMain;

    uAsyncAEMsgBuffer( const uAsyncAEMsgBuffer & );
    uAsyncAEMsgBuffer& operator=( const uAsyncAEMsgBuffer & );
  public:
    uSpinLock lock;
    uAsyncAEMsgBuffer();
    ~uAsyncAEMsgBuffer();
    void uAddMsg( uAsyncAEMsg *msg );
    uAsyncAEMsg *uRmMsg();
    uAsyncAEMsg *uRmMsg( uAsyncAEMsg *msg );
    uAsyncAEMsg *uNextVisible( uAsyncAEMsg *msg );
}; // uEHM::uAsyncAEMsgBuffer


//######################### uEHM::uDualClass ########################


class uEHM::uDualClass {
    friend class uEHM;
    friend class uEHM::uAsyncAEMsg;
    friend void uEHM::uEHMThrow( const uDualClass &, uBaseCoroutine & );
    friend void uEHM::uEHMThrow( const uDualClass & );
    friend void uEHM::uEHMRaise( const uDualClass &, uBaseCoroutine & );
    friend void uEHM::uEHMRaise( const uDualClass & );
    friend void uEHM::uPoll();
    friend void uEHM::uRaiseWorkHorse( const uDualClass &, const bool );
  protected:
    const char *const msg;
    const uBaseCoroutine &src;
    char uName[uEHMMaxName + sizeof("...")];		// room for "...\0"

    const void *uStaticallyBoundObject;

    // These routines are generated by the translator so they are object
    // specific.
    virtual void *uEvent_id() const = 0;
    virtual void uStackThrow() const __attribute__(( noreturn )) = 0;
    virtual uDualClass *uDuplicate() const = 0;
  public:
    static void *uId;

    uDualClass( const char *const msg = "" );
    virtual ~uDualClass();

    const char *const message() const;
    const uBaseCoroutine &source() const;
    const char *sourceName() const;
    virtual void defaultTerminate() const;
    virtual void defaultResume() const;

    // These members should be private but cannot be because they are
    // referenced from user code.
    inline const void *getOriginalThrower() const { return uStaticallyBoundObject; }
    const uDualClass * const setOriginalThrower ( const void *p ) const;
}; // uEHM::uDualClass


//######################### uEHM::uThrowClass ########################


// uThrowClass is the root class of all throwable exception-types

class uEHM::uThrowClass : protected uEHM::uDualClass {
    friend class uEHM;
    friend class uEHM::uAsyncAEMsg;			// enable conversion to uDualClass;
    friend void uEHM::uEHMThrow( const uThrowClass &, uBaseCoroutine & );
    friend void uEHM::uEHMThrow( const uThrowClass & );

#ifdef __DEBUG__
    virtual void defaultResume() const;
#endif // __DEBUG__
  protected:
    // These routines are generated by the translator, and hence, object
    // specific.
    virtual void *uEvent_id() const = 0;
    virtual void uStackThrow() const __attribute__(( noreturn )) = 0;
    virtual uDualClass *uDuplicate() const = 0;
  public:
    static void *uId;

    uThrowClass( const char *const msg = "" );
    virtual ~uThrowClass();

    uEHM::uDualClass::message;				// pass through from uDualClass
    uEHM::uDualClass::source;
    uEHM::uDualClass::sourceName;
    uEHM::uDualClass::getOriginalThrower;
    uEHM::uDualClass::setOriginalThrower;

    uEHM::uDualClass::defaultTerminate;
}; // uEHM::uThrowClass


//######################### uEHM::uRaiseClass ########################


class uEHM::uRaiseClass : protected uEHM::uDualClass {
    friend class uEHM;
    friend class uEHM::uAsyncAEMsg;
    friend void uEHM::uEHMRaise( const uRaiseClass &, uBaseCoroutine & );
    friend void uEHM::uEHMRaise( const uRaiseClass & );

#ifdef __DEBUG__
    virtual void defaultTerminate const();
#endif // __DEBUG__
  protected:
    // These routines are generated by the translator, and hence, object
    // specific.
    virtual void *uEvent_id() const = 0;
    virtual void uStackThrow() const __attribute__(( noreturn ));
    virtual uDualClass *uDuplicate() const = 0;
  public:
    static void *uId;

    uRaiseClass( const char *const msg = "" );
    virtual ~uRaiseClass();

    uEHM::uDualClass::message;				// pass through from uDualClass
    uEHM::uDualClass::source;
    uEHM::uDualClass::sourceName;
    uEHM::uDualClass::getOriginalThrower;
    uEHM::uDualClass::setOriginalThrower;

    virtual void defaultResume() const;			// calls uTerminate
}; // uEHM::uRaiseClass


//######################### internal class and function declarations ########################


// base class allowing a list of otherwise-heterogeneous uHandlerClauses
class uEHM::uHandlerBase {
    friend void uEHM::uRaiseWorkHorse( const uDualClass &, const bool );

    void * const originalThrower;
    void * const eventId;
  protected:
    uHandlerBase( void *originalThrower, void *eventId ) : originalThrower( originalThrower ), eventId( eventId ) {}
  public:
    virtual void uHandler( uEHM::uDualClass &exn ) = 0;
    void *uGetOriginalThrower() const { return originalThrower; }
    void *uGetEventId() const { return eventId; }
}; // uHandlerBase

template< typename Exn >
class uNullHandlerClause : public uEHM::uHandlerBase {
  public:
    uNullHandlerClause( void *originalThrower ) : uHandlerBase( originalThrower, &Exn::uId ) {}
    virtual void uHandler( uEHM::uDualClass &exn ) {}
}; // uNullHandlerClause

template< typename Exn, typename Functor >
class uHandlerClause : public uEHM::uHandlerBase {
    Functor &functor;
  public:
    uHandlerClause( void *originalThrower, Functor &functor ) : uHandlerBase( originalThrower, &Exn::uId ), functor( functor ) {}
    virtual void uHandler( uEHM::uDualClass &exn ) { functor( (Exn &)exn ); }
}; // uHandlerClause


// Every set of resuming handlers bound to a template try block is saved in a
// uEHM::uResumptionHandlers object. The resuming handler hierarchy is
// implemented as a linked list.

class uEHM::uResumptionHandlers {
    friend void uEHM::uRaiseWorkHorse( const uDualClass &, const bool );
    uResumptionHandlers *uNext, *uConseqNext;           // uNext maintains a proper stack, while uConseqNext is used to skip
                                                        // over handlers that have already been examined for resumption (to avoid recursion)

    const unsigned int size;				// number of handlers
    uHandlerBase *const *table;				// pointer to array of resumption handlers

    uResumptionHandlers( const uResumptionHandlers & );	// no copy
    uResumptionHandlers &operator=( const uResumptionHandlers & ); // no assignment
  public:
    uResumptionHandlers( uHandlerBase *const table[], const unsigned int size );
    ~uResumptionHandlers();
}; // uEHM::uResumptionHandlers


// The following actually implements a linked list of event_id's table.  Used
// in uEnable and uDisable block.

class uEHM::uDeliverAEStack {
    friend bool uEHM::deliverable_exception( void * );

    uDeliverAEStack *next;
    bool uDeliverFlag;                                  // true when events in table is Enable, otherwise false
    int  table_size;                                    // number of events in the table, 0 implies everything
    void **event_table;                                 // event id table

    uDeliverAEStack( uDeliverAEStack & );		// no copy
    uDeliverAEStack &operator=( uDeliverAEStack & );	// no assignment
  public:
    uDeliverAEStack( bool f, void **t = NULL, unsigned int msg = 0 ); // for enable and disable blocks
    ~uDeliverAEStack();
}; // uEHM::uDeliverAEStack


#endif // __U_EHM_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
