//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// TaskAcceptBB.cc -- Generic bounded buffer using a task
// 
// Author           : Peter A. Buhr
// Created On       : Sun Sep 15 20:24:44 1991
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jul 22 08:38:13 2003
// Update Count     : 67
// 

#include <uC++.h>
#include <uIOStream.h>

template<typename ELEMTYPE> uTask BoundedBuffer {
	const int size;										// number of buffer elements
	int front, back;									// position of front and back of queue
	int count;											// number of used elements in the queue
	ELEMTYPE *Elements;
  public:
	BoundedBuffer( const int size = 10 ) : size( size ) {
		front = back = count = 0;
		Elements = new ELEMTYPE[size];
	} // BoundedBuffer::BoundedBuffer

	~BoundedBuffer() {
		delete [] Elements;
	} // BoundedBuffer::~BoundedBuffer

	uNoMutex int query() {
		return count;
	} // BoundedBuffer::query

	void insert( ELEMTYPE elem ) {
		Elements[back] = elem;
	} // BoundedBuffer::insert

	ELEMTYPE remove() {
		return Elements[front];
	} // BoundedBuffer::remove
  protected:
	void main() {
		for ( ;; ) {
			uAccept( ~BoundedBuffer )
				break;
			uOr uWhen ( count != size ) uAccept( insert ) {
				back = ( back + 1 ) % size;
				count += 1;
			} uOr uWhen ( count != 0 ) uAccept( remove ) {
				front = ( front + 1 ) % size;
				count -= 1;
			} // uAccept
		} // for
	} // BoundedBuffer::main
}; // BoundedBuffer

#include "ProdConsDriver.i"

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++ TaskAcceptBB.cc" //
// End: //
