#ifndef BVBASE_HH
#define BVBASE_HH
//---------------------------------------------------------------------------
// Copyright (c) 1995-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: BVBase.hh,v 1.10 1999/03/09 22:51:59 dmartin Exp $
//---------------------------------------------------------------------------

#include "VHDLData.hh"
#include "ArrayInfo.hh"

extern "C" int abs(int);

//class so that all BitVectors can be passed around the same way
class VectorBase : public VHDLData {
public:
  int numbits; //total number bits in VectorBase
  ArrayInfo bounds;
  char *ch;
  VectorBase(int left, ArrayDirn_t dirn, int right) : bounds(left, dirn, right) {
    numbits = abs(right - left) + 1;
  }
  VectorBase(VectorBase& b) : numbits(b.numbits), bounds(b.bounds) { }
  ~VectorBase() { };

  virtual VectorBase& operator=(const VectorBase&);
  
  virtual char& operator[]( int);
  int length() const; 
  virtual int getSize() const;
  virtual bool operator !=( const VHDLData& ) const;
  virtual void print(ostream& ) const;
};


#endif
