/*
 * TWLOG.H  
 */

/*
 * INCLUDES AND DEFINES
 */

#ifndef TWLOG_H_INCLUDED
#define TWLOG_H_INCLUDED

#include "../config.h"
#include <time.h>
#include <errno.h>
#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/shm.h>
#include <sys/stat.h>

#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/FileSB.h>
#include <Xm/MwmUtil.h>
#include <Xm/DialogS.h>
#include <Xbae/Matrix.h>
#include <Xm/MessageB.h>
#include <Xm/MenuShell.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/SelectioB.h>

#define MAKE_ICON 1

#define XS_CONVERT( property, value ) \
           XtVaTypedArg, (property), XmRString, (value), strlen(value) + 1

#define KEY        6146            /* Some nice number */
#define SHMSIZE    40              /* Size of shared memory */ 
#define CANCEL_BTN 1
#define MAXNAME    25
#define PBWIDTH    80
#define MARGIN     20
#define LOGDIR     "/.twlogDir"    /* needed to build dirpath and logpath */
#define LOGFILE    "/logfile"
#define PRINT_CMD  "lpr "          /* needs the space after the command */

/*
 * APPLICATION DEFINED RESOURCES 
 */
#define XmNtzone           "tzone"
#define XmCTzone           "Tzone"

#define XmNbands           "bands"
#define XmCBands           "Bands"
#define XmNdefault_band    "default_band"
#define XmCDefault_band    "Default_band"

#define XmNmodes           "modes"
#define XmCModes           "Modes"
#define XmNdefault_mode    "default_mode"
#define XmCDefault_mode    "Default_mode"

#define XmNpower           "power"
#define XmCPower           "Power"
#define XmNdefault_power   "default_power"
#define XmCDefault_power   "Default_power"

typedef struct
{
   int    tzone;
   char **bands;
   int    default_band;
   char **modes;
   int    default_mode;
   char **power;
   int    default_power;
} LogRes;

typedef struct
{
   Widget TF1;
   Widget TF2;
   Widget next;
} Cdata;

/*
 * GLOBALS
 */
Widget logSH, searchSH, mwText;
char dirpath[100];
char logpath[100];
 

/*
 * FUNCTION DECLARATIONS
 */
void build_widgets (Widget w, LogRes app_data);
Widget buildOptionMenus (Widget parent, int defaultBtn, String *labelXS);
void dateCB (Widget w, XtPointer cdata, XtPointer cbs);
void startCB (Widget w, XtPointer cdata, XtPointer cbs);
void callsignCB (Widget w, XtPointer cdata, XtPointer cbs);
void traverseCB (Widget w, XtPointer cdata, XtPointer cbs);
void endCB (Widget w, XtPointer cdata, XtPointer cbs);
void fileCB (Widget w, XtPointer cdata, XtPointer cbs);
void convCB (Widget w, XtPointer cdata, XtPointer cbs);
void editCB (Widget w, XtPointer cdata, XtPointer cbs);
void helpCB (Widget w, XtPointer cdata, XtPointer cbs);
void focusCB (Widget w, XtPointer cdata, XtPointer cbs);
void diagCB (Widget w, XtPointer cdata, XtPointer cbs);
void okCB (Widget w, XtPointer cdata, XtPointer cbs);
void fsbCB (Widget w, XtPointer cdata, XtPointer cbs);
void saveCB (Widget w, XtPointer cdata, XtPointer cbs);
void closeCB (Widget w, XtPointer cdata, XtPointer cbs);
void searchCB (Widget w, XtPointer cdata, XtPointer cbs);
void enterCellCB (Widget w, XtPointer cdata, XtPointer cbs);
void cellCB (Widget w, XtPointer cdata, XtPointer cbs);
void popupFindCB (Widget w, XtPointer cdata, XtPointer cbs);
void doFindCB (Widget w, XtPointer cdata, XtPointer cbs);
void browserCB (Widget w, XtPointer cdata, XtPointer cbs);
void noMatchDiag (void);
void mk_log (void);
void errorDiag (Widget w, char *emess, int cancel);
void errOkCB (Widget w, XtPointer cdata, XtPointer cbs);
void errCancelCB (Widget w, XtPointer cdata, XtPointer cbs);
void confirmDiag (Widget w);
void confOkCB (Widget w, XtPointer cdata, XtPointer cbs);
char *findNoCase (char *text, char *pattern);
void promptCB (Widget w, XtPointer cdata, XtPointer cbs);
void popdownCB (Widget w, XtPointer cdata, XtPointer cbs);
void initCB (Widget w, XtPointer cdata, XtPointer cbs);
void initDiagCB (Widget w, XtPointer cdata, XtPointer cbs);
void popupHandler (Widget w, XtPointer cdata, XEvent * event, Boolean * cont);
void appendlog (char logpath[], Widget * col_2_wids);
void clearform (Widget * col_2_wids);
void popupEdit (char *filename);
Widget build_editor (void);
void build_convDiag (void);
void popupHelp (int topicNum);
void getHelp (char *filename, Widget wid);
void aboutDiag (void);
void mwLoad (Widget w);
void callSearch (char *);
Widget build_searchSH (void);

int  to_adif (char inlog[], char outlog[]);
int  de_adif (char inlog[], char outlog[]);

#endif
