/*
 * twlog:  A basic ham loging program using Motif
 * Copyright (C) 1997->2007 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
   License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge. MA 02139,
 * USA. See the COPYING file in this directory.
 *
 * Version: 2.5 -  Dec 2007
 */

/*
 * main Function
 * Main defines a structure for the application defined resources,
 * initializes the toolkit, builds the widgets, initializes some
 * variables, and then realizes the widgets. 
 */

#include "twlog.h"

#if MAKE_ICON && HAVE_X11_XPM_H && HAVE_LIBXPM
   #include <X11/xpm.h>
   #include "icons/twlog.xpm"
   Pixmap pixmap, mask;
   XpmAttributes pix_attributes;
   XpmColorSymbol transparentColor[1] = { {NULL, "none", 0} };
#endif

int shmid;
void *shareCall;

int main (int argc, char *argv[])
{
   XtAppContext ac;
   LogRes log_res;
   Dimension h = 0, w = 0;

   /*
    * Describe the application defined resources. This struct is
    * for the app resources which are read in the resource
    * file.  See the resource file (Twlog) for more info.
    */
   XtResource app_res_desc[] = 
   {
      {
         XmNtzone,                   /* Name */
         XmCTzone,                   /* Class */
         XmRInt,                     /* Target data type */
         sizeof (int),               /* Size of target type */
         XtOffsetOf (LogRes, tzone), /* Offset into LogRes */
         XtRImmediate,               /* Default data type */
         (XtPointer) 1               /* Default value */
      },

      {
         XmNbands,                   /* Same a above */
         XmCBands,
         XmRStringTable,
         sizeof (String *),
         XtOffsetOf (LogRes, bands),
         XmRString,
         "-1"                        /* Defaults to "-1" if Twlog not found */
      },

      {
         XmNdefault_band,            /* Same a above */
         XmCDefault_band,
         XmRInt,
         sizeof (int),
         XtOffsetOf (LogRes, default_band),
         XtRImmediate,
         0
      },

      {
         XmNmodes,                   /* Same a above */
         XmCModes,
         XmRStringTable,
         sizeof (String *),
         XtOffsetOf (LogRes, modes),
         XmRString,
         "1"
      },

      {
         XmNdefault_mode,            /* Same a above */
         XmCDefault_mode,
         XmRInt,
         sizeof (int),
         XtOffsetOf (LogRes, default_mode),
         XtRImmediate, 0             /* Default to first button */
      },

      {
         XmNpower,                   /* Same a above */
         XmCPower,
         XmRStringTable,
         sizeof (String *),
         XtOffsetOf (LogRes, power),
         XmRString,
         "1"
      },

      {
         XmNdefault_power,           /* Same a above */
         XmCDefault_power,
         XmRInt,
         sizeof (int),
         XtOffsetOf (LogRes, default_power),
         XtRImmediate, 0             /* Default to first button */
      }
   };

#ifdef XmVERSION_STRING
   extern const char _XmVersionString[];
   fprintf (stderr, "Compiled with %s\n", XmVERSION_STRING);
   fprintf (stderr, "Running  with %s\n", _XmVersionString);
#endif

   /*
    * Initialize the tool kit, create the application shell,
    * and get the app defined resources
    */
   logSH = XtVaAppInitialize (&ac, "Twlog", NULL, 0, &argc, argv, NULL,
      XmNmwmFunctions, MWM_FUNC_ALL | MWM_FUNC_CLOSE,
      XmNtitle, "TWLOG",
      NULL);

#if MAKE_ICON && HAVE_X11_XPM_H && HAVE_LIBXPM
   /*
    *  then create pixmap for application Icon
    */
   pix_attributes.closeness = 40000;
   pix_attributes.valuemask = XpmColorSymbols | XpmCloseness;
   pix_attributes.colorsymbols = transparentColor;
   pix_attributes.numsymbols = 1;

   XpmCreatePixmapFromData (XtDisplay (logSH),
      DefaultRootWindow (XtDisplay (logSH)),
      twlog_xpm, &pixmap, &mask, &pix_attributes);

   XtVaSetValues (logSH,
      XmNiconPixmap, pixmap,
      NULL);
#endif

   XtGetApplicationResources (logSH, &log_res, app_res_desc,
      XtNumber (app_res_desc), NULL, 0);

   /*
    * Check bands for "-1". If so, realize the shell, call error dialog,
    * and allow diag to force exit since the resource file was not found.
    */
   if (strcmp (log_res.bands[0], "-1") == 0)
   {
      XtRealizeWidget (logSH);
      errorDiag (logSH, "The resource file, Twlog, is missing.\n"
                        "This is an installation problem.  Did\n"
                        "you install twlog as root?\n"
                        "twcw must exit.\n\n"
                        "Please send bug reports to\n" PACKAGE_BUGREPORT,
                         CANCEL_BTN);
      fprintf (stderr, "twlog: The resource file, Twlog, is missing.\n");
      XtAppMainLoop (ac);
   }


   /*
    * Build the widgets
    */
   build_widgets (logSH, log_res);

   /*
    * Initialize the Timezone
    * Check the timezone resource and do a tzset if OK.  If the value
    * is bad or the resource was not found (default resource = 2
    * above) force an error and exit.
    */
   switch (log_res.tzone)
   {
      case 0:
         putenv ("TZ");
         break;

      case 1:
         putenv ("TZ=GMT");
         break;

      default:
         fprintf (stderr, "twlog: Warning - Invalid tzone in Twlog\n");
         fprintf (stderr, "Using GMT\n");
         putenv ("TZ=GMT");
   }
   tzset ();

   /*
    * get shared memory segment and attach it
    */
   if ((shmid = shmget (KEY, SHMSIZE, IPC_CREAT | 0600)) < 0)
   {
      perror ("twlog - shmget");
      exit (1);
   }

   if ((shareCall = (shmat (shmid, NULL, 0))) == (char *) -1)
   {
      perror ("twlog - shmat");
      exit (1);
   }

   /*
    * Realize the widgets
    */
   XtRealizeWidget (logSH);

   /*
    * Set max and min height to current height.  Set min width to 
    * current width.  Then, go into loop mode.
    */
   XtVaGetValues (logSH,
      XmNheight, &h,
      XmNwidth, &w,
      NULL);

   XtVaSetValues (logSH,
      XmNminHeight, h, 
      XmNmaxHeight, h,
      XmNminWidth, w,
      NULL);

   /*
    * Realize the widgets and enter the main loop
    */
   XtRealizeWidget (logSH);
   XtAppMainLoop (ac);
   return 0;                    /* Never get here */
}
