<?php

Function TWIGIsMemberOfACLGroup( $name, $groupname )
	{
	return FALSE;	
	}

Function TWIGConvertAccess( $access )
	{
	switch( strtoupper( $access ) )
		{
		case "NONE":
			return 0;
		case "READ":
			return 2;
		case "WRITE":
			return 4;
		case "DELETE":
			return 8;
		case "SIDADMIN":
			return 16;
		case "OWNER":
			return 32;
		case "ADMIN":
			return 128;
		case 0:
			return "none";
		case 2:
			return "read";
		case 4:
			return "write";
		case 8:
			return "delete";
		case 16:
			return "sidadmin";
		case 32:
			return "owner";
		case 128:
			return "admin";
		}
	}

//
// SID Ranges are as follows:
//
// 	    0-100000  : Internal SID (for features and preferences)
//     100000-2000000 : Assigned by modules for user data
//
// Internal SID's a currently defined as follows: 	
//
//	   0  - 999	: reserved
//	 1000 - 1999	: Global Options
//	 2000 - 2999	: Features (main, mail, etc...)
//	 3000 - 3999	: Main feature prefs
//	 4000 - 4999	: Mail feature prefs
//	 5000 - 5999	: News feature prefs
//	 6000 - 6999	: Contacts feature prefs
//	 7000 - 7999	: Calander feature prefs
//	 8000 - 8999	: ToDO feature prefs
//	 9000 - 9999	: Bookmarks feature prefs
//	10000 - 10999	: Groups feature prefs
//	11000 - 11999	: Admin feature prefs
//	12000 - 12999	: Meetings feature prefs
//	13000 - 13999	: Notes feature prefs
//	14000 - 14999   : Search feature prefs
//	15000 - 100000	: reserved for future use
//

Function TWIGGenerateSID( $owner = "" )
	{
	return 0;
	}

Function TWIGSCheckACL( $name, $sid, $access )
	{
	Global $disabled;

	if( $access > TWIGConvertAccess( "admin" ) ) { return FALSE; }
	if( $access > TWIGConvertAccess( "sidadmin" ) ) { return FALSE; }

	switch( $sid )
		{
		case 1000:
			if( $disabled["global_autoaccounts"] ) { return FALSE; }
			break;
		case 1001:
			if( $disabled["global_goto"] ) { return FALSE; }
			break;
		case 1002:
			if( $disabled["global_newmailcheck"] ) { return FALSE; }
			break;
		case 1003:
			if( $disabled["global_prefs"] ) { return FALSE; }
			break;
		case 1004:
			if( $disabled["global_password_prefs"] ) { return FALSE; }
			break;
		case 2000:		// main sid
			if( $disabled["main"] ) { return FALSE; }
			break;
		case 2001:		// mail sid
			if( $disabled["mail"] ) { return FALSE; }
			break;
		case 2002:		// news sid
			if( $disabled["news"] ) { return FALSE; }
			break;
		case 2003:		// contacts sid
			if( $disabled["contacts"] ) { return FALSE; }
			break;
		case 2004:		// schedule sid
			if( $disabled["schedule"] ) { return FALSE; }
			break;
		case 2005:		// todo sid
			if( $disabled["todo"] ) { return FALSE; }
			break;
		case 2006:		// bookmarks sid
			if( $disabled["bookmarks"] ) { return FALSE; }
			break;
		case 2007:
			if( $disabled["groups"] ) { return FALSE; }
			break;
		case 2008:
			if( $disabled["help"] ) { return FALSE; }
			break;
		case 2009:
			if( $disabled["meetings"] ) { return FALSE; }
			break;
 		case 2010:
 			if( $disabled["notes"] ) { return FALSE; }
 			break;
		case 2011:
 			if( $disabled["search"] ) { return FALSE; }
 			break;
		case 3000:
			if( $disabled["main_prefs"] ) { return FALSE; }
			break;
		case 3001:
			if( $disabled["main_recentmail"] ) { return FALSE; }
			break;
		case 3002:
			if( $disabled["main_schedule"] ) { return FALSE; }
			break;
		case 4000:
			if( $disabled["mail_compose"] ) { return FALSE; }
			break;
		case 4001:
			if( $disabled["mail_delete"] ) { return FALSE; }
			break;
		case 4002:
			if( $disabled["mail_expunge"] ) { return FALSE; }
			break;
		case 4003:
			if( $disabled["mail_folders"] ) { return FALSE; }
			break;
		case 4004:
			if( $disabled["mail_foldover"] ) { return FALSE; }
			break;
		case 4005:
			if( $disabled["mail_msgview"] ) { return FALSE; }
			break;
		case 4006:
			if( $disabled["mail_prefs"] ) { return FALSE; }
			break;
		case 4007:
			if( $disabled["mail_refresh"] ) { return FALSE; }
			break;
		case 4008:
			if( $disabled["mail_secondcmdline"] ) { return FALSE; }
			break;
		case 4009:
			if( $disabled["mail_showattach"] ) { return FALSE; }
			break;
		case 4010:
			if( $disabled["mail_transfer"] ) { return FALSE; }
			break;
		case 4011:
			if( $disabled["mail_transfer_to"] ) { return FALSE; }
			break;
		case 4012:
			if( $disabled["mail_treeview"] ) { return FALSE; }
			break;
		case 4013:
			if( $disabled["mail_readreceipts"] ) { return FALSE; }
			break;
		case 4014:
			if( $disabled["mail_configfrom"] ) { return FALSE; }
			break;
		case 4015:
			if( $disabled["mail_folder_graph"] ) { return FALSE; }
			break;
		case 5000:
			if( $disabled["news_manage"] ) { return FALSE; }
			break;
		case 5001:
			if( $disabled["news_prefs"] ) { return FALSE; }
			break;
		case 5002:
			if( $disabled["news_post"] ) { return FALSE; }
			break;
		case 6000:
			if( $disabled["contacts_import"] ) { return FALSE; }
			break;
		case 6001:
			if( $disabled["contacts_edit"] ) { return FALSE; }
			break;
		case 6002:
			if( $disabled["contacts_prefs"] ) { return FALSE; }
			break;
		case 6003:
			if( $disabled["contacts_lists"] ) { return FALSE; }
			break;
		case 6004:
			if( $disabled["contacts_export"] ) { return FALSE; }
			break;
		case 7000:
			if( $disabled["schedule_day"] ) { return FALSE; }
			break;
		case 7001:
			if( $disabled["schedule_edit"] ) { return FALSE; }
			break;
		case 7002:
			if( $disabled["schedule_prefs"] ) { return FALSE; }
			break;
		case 7003:
			if( $disabled["schedule_week"] ) { return FALSE; }
			break;
		case 7004:
			if( $disabled["schedule_list"] ) { return FALSE; }
			break;
		case 7005:
			if( $disabled["schedule_cal"] ) { return FALSE; }
			break;
		case 7006:
			if( $disabled["schedule_maint"] ) { return FALSE; }
			break;
		case 7007:
			if( $disabled["schedule_year"] ) { return FALSE; }
			break;
		case 8000:
			if( $disabled["todo_edit"] ) { return FALSE; }
			break;
		case 8001:
			if( $disabled["todo_prefs"] ) { return FALSE; }
			break;
		case 9000:
			if( $disabled["bookmarks_edit"] ) { return FALSE; }
			break;
		case 9001:
			if( $disabled["bookmarks_prefs"] ) { return FALSE; }
			break;
		case 9002:
			if( $disabled["bookmarks_import"] ) { return FALSE; }
			break;
		case 9003:
			if( $disabled["bookmarks_export"] ) { return FALSE; }
			break;
		case 10000:
			if( $disabled["groups_edit"] ) { return FALSE; }
 			break;
 		case 12001:
 			if( $disabled["meetings_prefs"] ) { return FALSE; }
 			break;
 		case 12002:
 			if( $disabled["meetings_schedule"] ) { return FALSE; }
 			break;
 		case 12003:
 			if( $disabled["meetings_private"] ) { return FALSE; }
 			break;
 		case 12004:
 			if( $disabled["meetings_public"] ) { return FALSE; }
 			break;
 		case 13000:
 			if( $disabled["notes_edit"] ) { return FALSE; }
 			break;
 		case 13001:
 			if( $disabled["notes_prefs"] ) { return FALSE; }
			break;
 		case 14000:
 			if( $disabled["search_bookmarks"] ) { return FALSE; }
			break;
 		case 14001:
 			if( $disabled["search_contacts"] ) { return FALSE; }
			break;
 		case 14002:
 			if( $disabled["search_global"] ) { return FALSE; }
			break;
 		case 14003:
 			if( $disabled["search_mail"] ) { return FALSE; }
			break;
 		case 14004:
 			if( $disabled["search_meetings"] ) { return FALSE; }
			break;
 		case 14005:
 			if( $disabled["search_news"] ) { return FALSE; }
			break;
 		case 14006:
 			if( $disabled["search_notes"] ) { return FALSE; }
			break;
 		case 14007:
 			if( $disabled["search_schedule"] ) { return FALSE; }
			break;
 		case 14008:
 			if( $disabled["search_todo"] ) { return FALSE; }
			break;
		}

	return TRUE;
	}

Function TWIGCheckACL( $name, $sid, $access )
	{
	return TWIGSCheckACL( $name, $sid, $access );
	}

Function TWIGSGetACL( $name, $sid, $access )
	{
	Global $config, $dbconfig;

	if( TWIGCheckACL( $name, $sid, TWIGConvertAccess( "write" ) ) )
		{
		return TWIGConvertAccess( "write" );
		}

	return 0;
	}

Function TWIGGetACL( $name, $sid )
	{
	Global $config, $dbconfig;

	return TWIGSGetACL( $name, $sid, $access );
	}

Function TWIGModifyACL( $name, $sid )
	{
	return TWIGDisplayACL( $name, $sid );
	}

Function TWIGDisplayACL( $name, $sid )
	{
	$tableheaders = array( TWIGPhrase( "Object" ),  "&nbsp;", TWIGPhrase( "Access" ) );
	$tablecontents[0] = array( TWIGPhrase( "Global Setting" ),  "&nbsp;", TWIGConvertAccess( TWIGGetACL( $name, $sid ) ) );

	return TWIGGenerateTable( $tableheaders, $tablecontents );
	}

Function TWIGCreateACLGroup( $name, $groupname )
	{
	return 0;
	}

Function TWIGDeleteACLGroup( $name, $groupname )
	{
	return FALSE;
	}

Function TWIGGetSID( $name )
	{
	return FALSE;
	}

Function TWIGAddACLEntry( $user, $addname, $sid, $access )
	{
	return FALSE;
	}

Function TWIGGetACLUsers()
	{
	return FALSE;
	}

Function TWIGGetACLGroups()
	{
	return FALSE;
	}

Function TWIGGetACLGroupMembers( $group )
	{
	return FALSE;
	}
	
Function TWIGSYSAddACLGroupMember( $usernametoadd, $groupname )
	{
	return FALSE;
	}

Function TWIGAddACLGroupMember( $username, $usernametoadd, $groupname )
	{
	return FALSE;
	}

Function TWIGRemoveACLGroupMember( $username, $usernametoremove, $groupname )
	{
	return FALSE;
	}

Function TWIGProcessACLModify()
	{
	return FALSE;
	}
?>
