<?php	// TWIG		Commonly used functions.	?>
<?php

if( !isset($included["common.inc.php3"] ) )
	{
	Function TWIGGoToFeature( $GoToFeature )
		{
		GLOBAL $context;

   		$gtfeature = unserialize( URLDecode( stripslashes( $GoToFeature ) ) );

		$context["feature"] = $gtfeature["command"];
		$context["action"] = $gtfeature["action"];
		$context["options"] = $gtfeature["options"];
		}

 	Function TWIGPrintError( $string )
		{
  		echo "<b>" . TWIGPhrase( "Error" ) . "</b>: <i>$string</i><br>\n";
 		}

	Function TWIGDebugLevel( $level = 10 )
		{
		GLOBAL $config, $login;

		if( $level < 1 ) { $level = 1; }
		if( !isset( $config["debug_users"][$login["username"]] ) ) { $config["debug_users"][$login["username"]] = $config["debug"]; }

		return ( $config["debug_users"][$login["username"]] >= $level );
		}

	Function TWIGDebug( $string, $level = 10 )
		{
		if( TWIGDebugLevel( $level ) ) { echo "<font color=\"#FF0000\"><b>DEBUG:</b>" . $string . "</font><BR>\n"; flush(); }
		}

 	// Create link with some status info
 	Function TWIGLink( $text="", $feature="", $action="", $params="", $target="", $sother = "", $cother = "" )
		{
  		GLOBAL $config;

		TWIGDebug( "TWIGLink( \"$text\", \"$feature\", \"$action\", \"$params\", \"$target\" );", 30 );

		$str = $config["baseurl"] . "?";
		if( $config["url_timestamp"] ) { $str .= "ts=" . mktime(); }
  		$str .= TWIGSession( "get", $sother );
		$str .= TWIGContext( "get", $feature, $action, $cother );
  		if( $params ) { $str .= "&amp;" . $params; }

 		return "<a href=\"$str\" $target>$text</a>";
		}

 	Function TWIGSRCFile( $file="", $feature="", $action="", $params="", $target="", $sother = "", $cother = "" )
		{
  		GLOBAL $config;

		TWIGDebug( "TWIGSRCFile( \"$file\", \"$feature\", \"$action\", \"$params\", \"$target\" );", 30 );

						  $ret  = $config["baseurl"];
		if( $file && substr( $config["baseurl"], -1 ) != "/" )
		    				{ $ret .= "/" . $file; }
						  $ret .= "?";
		if( $config["url_timestamp"] )	{ $ret .= "ts=" . mktime(); }
  						  $ret .= TWIGSession( "get", $sother );
						  $ret .= TWIGContext( "get", $feature, $action, $cother );
  		if( $params )			{ $ret .= "&amp;" . $params; }

 		return $ret;
 		}

 	Function TWIGImage( $image="", $alt="", $tip="", $border="0", $height="", $width="", $align="", $valign="", $vspace="", $hspace="" )
		{
		TWIGDebug( "TWIGImage( \"$image\", \"$alt\", \"$tip\", \"$border\", \"$height\", \"$width\", \"$align\", \"$valign\", \"$vspace\", \"$hspace\" );", 30 );

		// $tip is for the tooltip, default to $alt if not specifically set
		if( !$tip ) { $tip = $alt; }

		$ret = "<img";
		// The function should probably just bomb entirely if there's no $image
		if( $image )		{ $ret .= " src=\"$image\""; }
		// Most older browsers show "alt" as the tooltip, ala HTML 2 and 3
		if( $alt )		{ $ret .= " alt=\"$alt\""; }
		// IE 5 and up wants "type" for a tooltip, Mozilla follows HTML 4 and wants "title"
		if( $tip )		{ $ret .= " type=\"$tip\" title=\"$tip\""; }
		// These are numerical, so don't let "0" return false
		if( strlen( $border ) )	{ $ret .= " border=\"$border\""; }
		if( strlen( $height ) )	{ $ret .= " height=\"$height\""; }
		if( strlen( $width ) )	{ $ret .= " width=\"$width\""; }
		if( $align )		{ $ret .= " align=\"$align\""; }
		if( $valign )		{ $ret .= " valign=\"$valign\""; }
		// These are numerical, so don't let "0" return false
		if( strlen( $vspace ) ) { $ret .= " vspace=\"$vspace\""; }
		if( strlen( $hspace ) ) { $ret .= " hspace=\"$hspace\""; }
		$ret .= ">";

 		return $ret;
 		}

 	Function TWIGMailto( $address, $linktext = "", $nolinkprefix = "" )
		{
  		GLOBAL $config, $login;

		TWIGDebug( "TWIGMailto( \"$address\", \"$linktext\", $nolinkprefix );", 30 );

		if( !$address ) { $address = $config["defaults"]["mail"]["fromaddress"]; }
		if( !strstr( $address, "@" ) ) { $address .= "@" . $config["fromdomain"]; }

		if( TWIGCheckACL( $login["username"], 2001, TWIGConvertAccess( "read" ) ) )
			{
			if( $linktext )
				{
				$email = $nolinkprefix . twigLink( $linktext, "mail", "compose",
					"form[to]=" . URLEncode( $address ) );
				}
			else
				{
				$email = twigLink( $address, "mail", "compose",
					"form[to]=" . URLEncode( $address ) );
				}
			}
		else
			{
			if( $linktext )
				{
				$email = $nolinkprefix . "<a href=\"mailto:" . URLEncode( $address ) . "\">" . $linktext . "</a>";
				}
			else
				{
				$email = "<a href=\"mailto:" . URLEncode( $address ) . "\">" . $address . "</a>";
				}
			}

 		return $email;
 		}

	Function TWIGCheckAdmin( $username = "" )
		{
		GLOBAL $config, $login;

		TWIGDebug( "TWIGCheckAdmin( \"" . $username . "\");" );

		if( !$username ) { $username = $login["username"]; }

		if( file_exists( "features/admin/users/" . $username . ".admin" ) )
			{
			return TRUE;
			}

  		return TWIGIsMemberOfACLGroup( $username, "TWIGAdministrators" );
 		}

	Function TWIGFormatDisplayString( $str )
		{
		return TWIGFindHtml( nl2br( htmlspecialchars( str_replace( "\r", "", $str ) ) ) );
		}

	Function TWIGMassage( $str )
		{ // Fixes fu for things like NetPositive
  		return htmlspecialchars( str_replace( "\r", "", $str ) );
 		}

	Function TWIGFindHtml( $string = "" )
		{
		GLOBAL $config, $disabled, $login;

		TWIGDebug( "TWIGFindHtml( \"" . $string . "\" );", 30 );

		if( !$disabled["FindHTML"] )
			{

			$bstring = trim( $string );

	                $bstring = eregi_replace( "&lt;", " ", $bstring );
        	        $bstring = eregi_replace( "&gt;", " ", $bstring );
			$bstring = eregi_replace( "&quot;"," ", $bstring );
			$bstring = str_replace( "\t", " ", $bstring );
        	        $bstring = eregi_replace( "\[", " ", $bstring );
                	$bstring = eregi_replace( "\]", " ", $bstring );
			$bstring = eregi_replace( "[<>'()*]", " ", $bstring );
			$bstring = eregi_replace( "MAILTO:", " ", $bstring );
        	        $bstring = eregi_replace( "HTTP:", " http:", $bstring );
                	$bstring = eregi_replace( "HTTPS:", " https:", $bstring );
			$bstring = eregi_replace( "FTP:", " ftp:", $bstring );

			$string_split = split( " ", $bstring );

			$fstrings["http"] = array();
			$fstrings["ftp"] = array();
			$fstrings["nohttp"] = array();
			$fstrings["noftp"] = array();
			$fstrings["mail"] = array();

			for( $i = 0, $j = sizeof( $string_split ); $i < $j; $i++ )
				{
				$csplit = trim( strtoupper( $string_split[$i] ) );
				$string_split[$i] = trim( eregi_replace( "[,.;:]$", " ", $string_split[$i] ) );

   				if( strstr( $csplit, "HTTP://" ) || strstr( $csplit, "HTTPS://" ) ) { $fstrings["http"][$string_split[$i]] = 1; }
				else if( strstr( $csplit, "FTP://" ) ) { $fstrings["ftp"][$string_split[$i]] = 1; }
				else if( strstr( $csplit, "@" ) && strstr( $csplit, "." ) ) { $fstrings["mail"][$string_split[$i]] = 1; }
				else if( eregi( "WWW\..*\..", $csplit ) ) { $fstrings["nohttp"][$string_split[$i]] = 1; }
				else if( eregi( "FTP\..*\..", $csplit ) ) { $fstrings["noftp"][$string_split[$i]] = 1; }
				}

			$ret = $string;

			while( list( $key, $val ) = each( $fstrings["http"] ) )
				{
				$ret = eregi_replace( preg_quote( $key ), "<a href=\"" . $key . "\" target=_blank>" . $key . "</a>", $ret );
				}

			while( list( $key, $val ) = each( $fstrings["ftp"] ) )
				{
				$ret = eregi_replace( preg_quote( $key ), "<a href=\"" . $key . "\" target=_blank>" . $key . "</a>", $ret );
				}

			while( list( $key, $val ) = each( $fstrings["nohttp"] ) )
				{
				$ret = eregi_replace( preg_quote( $key ), "<a href=\"http://" . $key . "\" target=_blank>" . $key . "</a>", $ret );
				}

			while( list( $key, $val ) = each( $fstrings["noftp"] ) )
				{
				$ret = eregi_replace( preg_quote( $key ), "<a href=\"ftp://" . $key . "\" target=_blank>" . $key . "</a>", $ret );
				}

			while( list( $key, $val ) = each( $fstrings["mail"] ) )
				{
				$ret = eregi_replace( preg_quote( $key ), "<a href=\"mailto:" . $key . "\">" . $key . "</a>", $ret );
				}

			if( TWIGCheckACL( $login["username"], 2001, TWIGConvertAccess( "read" ) ) )
				{
				$ret = eregi_replace( "=[ \"]mailto:", "=\"" . $config["baseurl"] . "?" . twigsession() . twigcontext( "get", "mail", "compose" ) . "&amp;form[to]=", $ret );
				}

		    	return $ret;
			}
		else
			{
			return $string;
			}
		}

	Function TWIGLoadLanguageFile( $filepath, $filename, $lang )
		{
		GLOBAL $TWIGphrase, $config, $dayNamesShort, $dayNames, $monthNames;

		TWIGDebug( "TWIGLoadLanguageFile( \"" . $filepath . "\", \"" . $filename . "\", \"" . $lang . "\" );" );

		if( !$filename ) { $sep = ""; } else { $sep = "."; }

 		if( file_exists( $filepath . $filename . $sep . $lang . ".strings.php3" ) )
   			{
			TWIGDebug( "TWIGLoadLanguageFile() - including " . $filepath . $filename . $sep . $lang . ".strings.php3", 20 );
   			include( $filepath . $filename . $sep . $lang . ".strings.php3" );
   			}
		else
			{
			TWIGDebug( "TWIGLoadLanguageFile() " . $lang . " not found - including " . $filepath . $filename . ".english.strings.php3", 20 );
   			include( $filepath . $filename . $sep . "english.strings.php3" );
   			}
		}

	// Takes an array and generates TWIG menus
	//
	// Menu types include:	0 - Traditional TWIG text
	//			1 - Drop Down List
	//			2 - Button Bar
	//			3 - Traditional TWIG secondary bar
	//			4 - Vertical bulleted list
	//			5 - Tab list
	//			6 - Simple list
	//			7 - Button Bar without text
	//			8 - Button Bar #2
	//			9 - Button Bar without text #2
	//
	// If adding a new type, update the mstyle1 and mstyle2 workarounds.
	//
	Function TWIGGenerateMenu( &$contents, $menutype = "", $imagepath = "primary", $sother = "", $cother = "" )
		{
		global $config, $disabled, $context, $dbconfig;

		TWIGDebug( "TWIGGenerateMenu( array, array );" );

		if( !$menutype ) { $menutype = GetPref( "mstyle1", $dbconfig["global_prefs_table"], $config["defaults"]["global"]["mstyle1"] ); }

		$j = count( $contents );

		$ret .= "<!-- Begin Menu -->\n";
		if ( $imagepath == "primary" )
			{
			$ret .= "<div class=\"menuprimary\">\n";
			/* Work around faulty prefs for mystle1. */
			if ($menutype > 9 || $menutype < 0)
				$menutype = $config["defaults"]["global"]["mstyle1"];
			if ($menutype > 9 || $menutype < 0)
				$menutype = 0;

			}
		else
			{
			$ret .= "<div class=\"menusecondary\">\n";
			/* Work around faulty prefs for mstyle2. */
			if ($menutype > 9 || $menutype < 0)
				$menutype = $config["defaults"]["global"]["mstyle2"];
			if ($menutype > 9 || $menutype < 0)
				$menutype = 3;

			}

		switch( $menutype )
 			{
			case 0:
				for( $i = 0; $i < $j; $i++ )
					{
					if ( $imagepath == "primary" &&  $contents[$i]["command"] == $context["feature"] )
						{
						$ret .=  twigLink( "[" . $contents[$i]["desc"] . "]", $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					elseif ( $contents[$i]["command"] == "schedule" && $contents[$i]["command"] == $context["feature"] && $contents[$i]["action"] == $context["action"] )
						{
						$ret .=  twigLink( "[" . $contents[$i]["desc"] . "]", $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					else
						{
						$ret .=  twigLink( $contents[$i]["desc"], $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					if( $i + 1 < $j ) { $ret .= " | "; }
					}
				break;
			case 1:
				$ret .= "<form method=\"post\">\n";
				$ret .= TWIGSession( "put", $sother );
				$ret .= TWIGContext( "put", "", "", $cother );
				$ret .= TWIGPhrase( "Feature" ) . ": ";
				$ret .= "<SELECT name=\"GoToFeature\">\n";

  				for( $i = 0; $i < $j; $i++ )
					{
					if( $context["feature"] == $contents[$i]["command"] && $context["action"] == $contents[$i]["action"]) { $selected = "SELECTED "; }
					else { $selected = ""; }

					$ret .=  "<option " . $selected . "value=\"" . URLEncode( serialize( $contents[$i] ) ) . "\">" . $contents[$i]["desc"] . "</option>\n";
  					}

				$ret .= "</select><input type=\"submit\" value=\"" . TWIGPhrase( "Go" ) . "\"></form>\n";

				break;
			case 2:
				$jj = round ( $j / 2 );
				$start = 0;
				$stop = $jj;
				for( $z = 0; $z < 2; $z++ )
					{
					$ret .= "<table border=0 cellspacing=0 cellpadding=0><tr>";
					for( $i = $start; $i < $stop; $i++ )
						{
						$tooltip = $contents[$i]["desc"];
						if( $imagepath == "primary" &&  $contents[$i]["command"] == $context["feature"] )
							{
							$tooltip = "[" . $contents[$i]["desc"] . "]";
							$ret .= "<td valign=top>" . twigLink( TWIGImage( $config["imgdir"] . "menus/" . $imagepath ."/" . $config["language"] . "/" . $contents[$i]["image"], $tooltip, $tooltip,"0","","","","",8,0), $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
							}
						elseif( $contents[$i]["command"] == "schedule" && $context["feature"] == $contents[$i]["command"] && $context["action"] == $contents[$i]["action"])
							{
							$tooltip = "[" . $contents[$i]["desc"] . "]";
							$ret .= "<td valign=top>" . twigLink( TWIGImage( $config["imgdir"] . "menus/" . $imagepath ."/" . $config["language"] . "/" . $contents[$i]["image"], $tooltip, $tooltip,"0","","","","",8,0), $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
							}
						else
							{
							$ret .= "<td valign=bottom>" . twigLink( TWIGImage( $config["imgdir"] . "menus/" . $imagepath ."/" . $config["language"] . "/" . $contents[$i]["image"], $tooltip, $tooltip), $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
							}
						$ret .= "</td>\n";
						}
					$ret .= "</tr></table>\n";
					$start = $jj;
					$stop = $j;
					}
				break;
			case 3:
				for( $i = 0; $i < $j; $i++ )
					{
					$tooltip = "title=\"" . $contents[$i]["desc"] . "\"alt= \"" . $contents[$i]["desc"] . "\"";;
					if ( $imagepath == "primary" &&  $contents[$i]["command"] == $context["feature"] )
						{
						$ret .=  twigLink( "[" . $contents[$i]["desc"] . "]", $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					elseif ( $contents[$i]["command"] == "schedule" && $contents[$i]["command"] == $context["feature"] && $contents[$i]["action"] == $context["action"] )
						{
						$ret .=  twigLink( "[" . $contents[$i]["desc"] . "]", $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					else
						{
						$tooltip .= "alt= \"" . $contents[$i]["desc"] . "\"";
						$ret .=  twigLink( $contents[$i]["desc"], $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					if( $i + 1 < $j ) { $ret .= " | "; }
					}
				break;
			case 4:
				$ret .="<table border=0 cellspacing=0 cellpadding=0>";
				for( $i = 0; $i < $j; $i++ )
					{
					if ( $imagepath == "primary" &&  $contents[$i]["command"] == $context["feature"] )
						{
						$ret .= "<tr><td align=\"left\">&bull;&nbsp;" . twigLink( "[" . $contents[$i]["desc"] . "]", $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother ) . "</td></tr>\n";
						}
					elseif ( $contents[$i]["command"] == "schedule" && $contents[$i]["command"] == $context["feature"] && $contents[$i]["action"] == $context["action"] )
						{
						$ret .= "<tr><td align=\"left\">&bull;&nbsp;" . twigLink( "[" . $contents[$i]["desc"] . "]", $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother ) . "</td></tr>\n";
						}
					else
						{
						$ret .= "<tr><td align=\"left\">&bull;&nbsp;" . twigLink( $contents[$i]["desc"], $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother ) . "</td></tr>\n";
						}
					}
				$ret .="</table>\n";
				break;
			case 5:
				$selected = -1;
				$selectedpref = -1;
				$ret .= "<div class=\"menutabs\">\n";
  				for( $i = 0; $i < $j; $i++ )
					{
					if ( $imagepath == "primary" &&  $contents[$i]["command"] == $context["feature"] ) { $selected = $i;}
					if ( $contents[$i]["command"] == "schedule" && $contents[$i]["command"] == $context["feature"] && $contents[$i]["action"] == $context["action"] ) { $selected = $i;}
					if ( $context["feature"] == $contents[$i]["command"] && $context["action"] == $contents[$i]["action"]) { $selectedpref = $i;}

					$tabcontents[$i] =  twigLink( $contents[$i]["desc"], $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
					}
				if ( $selectedpref != -1 ) {$selected = $selectedpref;}
				$ret .= TWIGGenerateTabs( $tabcontents, $selected );
				$ret .="</div>\n";

				break;
			case 6:
				$ret .= "<div class=\"menusimple\">\n";
				for( $i = 0; $i < $j; $i++ )
					{
					if ( $imagepath == "primary" &&  $contents[$i]["command"] == $context["feature"] )
						{
						$ret .=  twigLink( "[" . $contents[$i]["desc"] . "]", $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					elseif ( $contents[$i]["command"] == "schedule" && $contents[$i]["command"] == $context["feature"] && $contents[$i]["action"] == $context["action"] )
						{
						$ret .=  twigLink( "[" . $contents[$i]["desc"] . "]", $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					else
						{
						$ret .=  twigLink( $contents[$i]["desc"], $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}

					if( $i + 1 < $j ) { $ret .= " &bull; "; }
					}
				$ret .="</div>\n";

				break;
			case 7:
				$ret .= "<table border=0 cellspacing=0 cellpadding=0><tr>";
				if ( !$config["ntimgsize"] ) { $config["ntimgsize"] = 26; }
				for( $i = 0; $i < $j; $i++ )
					{
					$tooltip = $contents[$i]["desc"];
					if ( $imagepath == "primary" &&  $contents[$i]["command"] == $context["feature"] )
						{
						$tooltip = "[" . $contents[$i]["desc"] . "]";
						$ret .= "<td class=\"formhead\">" . twigLink( TWIGImage( $config["imgdir"] . "menus-nt/" . $imagepath ."/" . $contents[$i]["image"], $tooltip, $tooltip, "0",($config["ntimgsize"]-4),($config["ntimgsize"]-4),"","",2,4 ), $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					elseif ( $contents[$i]["command"] == "schedule" && $contents[$i]["command"] == $context["feature"] && $contents[$i]["action"] == $context["action"] )
						{
						$tooltip = "[" . $contents[$i]["desc"] . "]";
						$ret .= "<td class=\"formhead\">" . twigLink( TWIGImage( $config["imgdir"] . "menus-nt/" . $imagepath ."/" . $contents[$i]["image"], $tooltip, $tooltip, "0",($config["ntimgsize"]-4),($config["ntimgsize"]-4),"","",2,4 ), $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					else
						{
						$ret .= "<td>" . twigLink( TWIGImage( $config["imgdir"] . "menus-nt/" . $imagepath ."/" . $contents[$i]["image"], $tooltip, $tooltip), $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					$ret .= "</td>\n";
					}
				$ret .= "</tr></table>\n";

				break;
			case 8:
				$ret .= "<table border=0 cellspacing=0 cellpadding=0><tr>";
				for( $i = 0; $i < $j; $i++ )
					{
					$tooltip = $contents[$i]["desc"];
					if( $imagepath == "primary" &&  $contents[$i]["command"] == $context["feature"] )
						{
						$tooltip = "[" . $contents[$i]["desc"] . "]";
						$ret .= "<td valign=\"top\">" . twigLink( TWIGImage( $config["imgdir"] . "menus2/" . $imagepath ."/" . $config["language"] . "/" . $contents[$i]["image"], $tooltip, $tooltip,"0","","","","",8,0), $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					elseif( $contents[$i]["command"] == "schedule" && $context["feature"] == $contents[$i]["command"] && $context["action"] == $contents[$i]["action"])
						{
						$tooltip = "[" . $contents[$i]["desc"] . "]";
						$ret .= "<td valign=\"top\">" . twigLink( TWIGImage( $config["imgdir"] . "menus2/" . $imagepath ."/" . $config["language"] . "/" . $contents[$i]["image"], $tooltip, $tooltip,"0","","","","",8,0), $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					else
						{
						$ret .= "<td valign=\"bottom\">" . twigLink( TWIGImage( $config["imgdir"] . "menus2/" . $imagepath ."/" . $config["language"] . "/" . $contents[$i]["image"], $tooltip, $tooltip), $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					$ret .= "</td>\n";
					}
				$ret .= "</tr></table>\n";
				break;
			case 9:
				$ret .= "<table border=0 cellspacing=0 cellpadding=0><tr>";
				if ( !$config["ntimgsize"] ) { $config["ntimgsize"] = 26; }
				for( $i = 0; $i < $j; $i++ )
					{
					$tooltip = $contents[$i]["desc"];
					if ( $imagepath == "primary" &&  $contents[$i]["command"] == $context["feature"] )
						{
						$tooltip = "[" . $contents[$i]["desc"] . "]";
						$ret .= "<td class=\"formhead\">" . twigLink( TWIGImage( $config["imgdir"] . "menus-nt2/" . $imagepath ."/" . $contents[$i]["image"], $tooltip, $tooltip, "0","","","","",2,4 ), $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					elseif ( $contents[$i]["command"] == "schedule" && $contents[$i]["command"] == $context["feature"] && $contents[$i]["action"] == $context["action"] )
						{
						$tooltip = "[" . $contents[$i]["desc"] . "]";
						$ret .= "<td class=\"formhead\">" . twigLink( TWIGImage( $config["imgdir"] . "menus-nt2/" . $imagepath ."/" . $contents[$i]["image"], $tooltip, $tooltip, "0","","","","",2,4 ), $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					else
						{
						$ret .= "<td>" . twigLink( TWIGImage( $config["imgdir"] . "menus-nt2/" . $imagepath ."/" . $contents[$i]["image"], $tooltip, $tooltip), $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother );
						}
					$ret .= "</td>\n";
					}
				$ret .= "</tr></table>\n";
				break;
			}

		$ret .= "</div>\n";
		$ret .= "<!-- End Menu -->\n";
		return $ret;
		}

  	Function TWIGGenerateTable( &$headers, &$contents, $columns = 0, $width = "100%", $align = "", $class = "" )
		{
		GLOBAL $config;

		TWIGDebug( "TWIGGenerateTable( array, array, \"" . $columns . "\" );" );

		// Sometimes we are just giving "$width" a null string so that we can give the function a value for "$class".
		// We really sure juggle the variables around so that this is less of an issue.
		// However, there is a lot of code to seek out and juggle around.  So this will likely never happen.
		// In the mean time, we'll just pull the following stunt....
		if ( !$width ) { $width="100%"; }

		if( !$columns ) { $columns = count( $headers ); }

		echo "<table border=0 cellspacing=0 cellpadding=0 width=\"$width\"";
		// For some silly reason, Netscape will render stuff left or right of a table.
		// The GenerateTable( ..., $align ) option is really here for centering, anyhow.
		if( $align ) { echo " align=\"$align\""; }
		if ($class) { echo " class=\"$class\""; }
		echo ">\n";
		echo "<tr class=\"rowhead\">\n";

		for( $i = 0, $j = 0; $i < $columns && $j < $columns; $j++, $i++ )
			{
			if( is_array( $headers[$i] ) )
				{
				if( $headers[$i]["colspan"] ) { $colspan = " COLSPAN=" . $headers[$i]["colspan"]; $j += $headers[$i]["colspan"] - 1; } else { $colspan = ""; }
				if( $headers[$i]["align"] ) { $align = " align=\"" . $headers[$i]["align"] . "\""; } else { $align = ""; }
				if( $headers[$i]["valign"] ) { $valign = " valign=\"" . $headers[$i]["valign"] . "\""; } else { $valign = ""; }
				if( $headers[$i]["nowrap"] ) { $nowrap = " NOWRAP"; } else { $nowrap = ""; }
				if( $headers[$i]["class"] ) { $class = " class=\"" . $headers[$i]["class"] . "\""; } else { $class = ""; }

				echo "<td" . $colspan . $align . $valign . $nowrap . $class . ">" . $headers[$i]["header"] . "</td>\n";
				}
			else
				{
				echo "<td>" . $headers[$i] . "</td>\n";
				}
			}

		echo "</tr>\n";

		for( $i = 0, $j = count( $contents ); $i < $j; $i++ )
			{
			echo "<tr class=\"";
			if ( $contents[$i]["class"] ) {
				echo $contents[$i]["class"];
			} elseif ($i % 2) {
				echo "roweven";
			} else {
				echo "rowodd";
			}
			echo "\">\n";

			for( $k = 0, $l = 0; $k < $columns && $l < $columns; $l++, $k++ )
				{
				if( is_array( $contents[$i][$k] ) )
					{
					if( $contents[$i][$k]["bgcolor"] ) { $bgcolor = " bgcolor=\"" . $contents[$i][$k]["bgcolor"] . "\""; } else { $bgcolor = ""; }
 					if( $contents[$i][$k]["colspan"] ) { $colspan = " COLSPAN=" . $contents[$i][$k]["colspan"]; $l += $contents[$i][$k]["colspan"] - 1; } else { $colspan = ""; }
					if( $contents[$i][$k]["align"] ) { $align = " align=\"" . $contents[$i][$k]["align"] . "\""; } else { $align = ""; }
					if( $contents[$i][$k]["valign"] ) { $valign = " valign=\"" . $contents[$i][$k]["valign"] . "\""; } else { $valign = " valign=\"middle\""; }
					if( $contents[$i][$k]["nowrap"] ) { $nowrap = " NOWRAP"; } else { $nowrap = ""; }
					if( $contents[$i][$k]["class"] ) { $class = " class=\"" . $contents[$i][$k]["class"] . "\""; } else { $class=""; }

				  	echo "<td", $bgcolor, $colspan, $align, $valign, $nowrap, $class, ">", $contents[$i][$k]["contents"], "</td>\n";
					}
				else
					{
				  	echo "<td valign=\"middle\">", $contents[$i][$k], "</td>\n";
					}
				}

			echo "</tr>\n";
			}

		echo "</table>\n";
		}

	Function TWIGGenerateTabsOLD( &$contents, $selected = -1 )
		{
		GLOBAL $img, $config;

		TWIGDebug( "TWIGGenerateTabs( array, \"" . $selected . "\" );" );

		if( !$config["tabcolorlight"] ) { $config["tabcolorlight"] = "#c6c6c6"; }
		if( !$config["tabcolordark"] ) { $config["tabcolordark"] = "#848484"; }

 		$tabbuffer = "<table border=0 cellpadding=0 cellspacing=0>\n";
 		$tabbuffer .= "<tr valign=\"bottom\">\n";

		for( $i = 0, $j = count( $contents ); $i < $j; $i++ )
			{
		 	$tabbuffer .= "<td>\n";
	  		$tabbuffer .= "<table border=0 cellpadding=0 cellspacing=0>\n";
			if( $i == $selected )
				{
				$tabbuffer .= "<tr height=1><td height=1 width=1></td><td height=1 width=1 bgcolor=\"#FFFFFF\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 width=1 bgcolor=\"#000000\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"></td></tr>\n";
				$tabbuffer .= "<tr height=1><td height=1 width=1 bgcolor=\"#FFFFFF\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 width=1 bgcolor=\"#000000\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"></td></tr>\n";
				$tabbuffer .= "<tr height=30><td height=30 bgcolor=\"#FFFFFF\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\">[" . $contents[$i] . "]</td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=30 bgcolor=\"" . $config["tabcolordark"] . "\"></td><td height=30 bgcolor=\"#000000\"></td></tr>\n";
				$tabbuffer .= "<tr height=4><td height=4 bgcolor=\"#FFFFFF\"></td><td height=4 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=4 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=4 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=4 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=4 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=4 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=4 bgcolor=\"" . $config["tabcolordark"] . "\"></td><td height=4 bgcolor=\"#000000\"></td></tr>\n";
				}
			else
				{
				$tabbuffer .= "<tr height=1><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td></tr>\n";
				$tabbuffer .= "<tr height=1><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td></tr>\n";
				$tabbuffer .= "<tr height=1><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td></tr>\n";
				$tabbuffer .= "<tr height=1><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td><td height=1 width=1></td></tr>\n";
				$tabbuffer .= "<tr height=1><td height=1 width=1></td><td height=1 width=1 bgcolor=\"#FFFFFF\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 width=1 bgcolor=\"#000000\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"></td></tr>\n";
				$tabbuffer .= "<tr height=1><td height=1 width=1 bgcolor=\"#FFFFFF\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=1 width=1 bgcolor=\"#000000\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"></td></tr>\n";
				$tabbuffer .= "<tr height=30><td height=30 bgcolor=\"#FFFFFF\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\">" . $contents[$i] . "</td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"></td><td height=30 bgcolor=\"" . $config["tabcolordark"] . "\"></td><td height=30 bgcolor=\"#000000\"></td></tr>\n";
				}
			$tabbuffer .= "</table>\n";
 			$tabbuffer .= "</td>\n";
			}

 		$tabbuffer .= "</tr></table>\n";

		return $tabbuffer;
		}

	Function TWIGGenerateTabs( &$contents, $selected = -1 )
		{
		GLOBAL $img, $config;

		TWIGDebug( "TWIGGenerateTabs( array, \"" . $selected . "\" );" );

		$tabbuffer = "<table border=0 cellpadding=0 cellspacing=0>\n";
		$tabbuffer .= "<tr valign=\"bottom\">\n";

		for( $i = 0, $j = count( $contents ); $i < $j; $i++ )
				{
				$tabbuffer .= "<td>\n";
				if( $i == $selected )
						{
						$tabbuffer .= "<div class=\"tabactive\"><div class=\"tabin1\"><div class=\"tabin2\">[" . $contents[$i] . "]</div></div></div>\n";
						}
				else
						{
						$tabbuffer .= "<div class=\"tabinactive\"><div class=\"tabin1\"><div class=\"tabin2\">" . $contents[$i] . "</div></div></div>\n";
						}
				$tabbuffer .= "</td>\n";
				}

		$tabbuffer .= "</tr></table>\n";

		return $tabbuffer;
		}

	Function TWIGGenerateLeftRightOptions( &$left, &$right, $name, $lefthead, $righthead, $size = 5 )
		{
		GLOBAL $config;

		TWIGDebug( "TWIGGenerateLeftRightOptions( array, array, \"" . $name . "\", \"" . $lefthead . "\", \"" . $righthead . "\", \"" . $size . "\" );" );

		$buf  = "<table border=0 cellspacing=0 cellpadding=0>\n";
		$buf .= " <tr>\n";
		$buf .= "  <td>" . $lefthead . "</td>\n";
		$buf .= "  <td>&nbsp;</td>\n";
		$buf .= "  <td>" . $righthead . "</td>\n";
		$buf .= " </tr>\n";
		$buf .= " <tr>\n";
		$buf .= "  <td>\n";

		if( is_array( $left ) )
			{
			reset( $left );
 			while( list( $key, $val ) = each( $left ) )
				{
				$buf .= "   <input type=\"hidden\" name=\"" . $name . "_orig_left[" . $key . "]\" value=\"" . urlencode( $left[$key] ) . "\">\n";
				}
			}

		$buf .= "   <select name=\"" . $name . "_sel_left[]\" size=" . $size . " multiple>\n";

		if( is_array( $left ) )
			{
			reset( $left );
 			while( list( $key, $val ) = each( $left ) )
				{
				$buf .= "    <option value=\"" . $key . "\">" . $left[$key] . "</option>\n";
				}
			}

		$buf .= "   </select>\n";
		$buf .= "  </td>\n";
		$buf .= "  <td valign=\"middle\">\n";
		$buf .= "   <input type=\"submit\" name=\"" . $name . "_sub\" value=\"&gt;&gt;\"><BR><BR><input type=\"submit\" name=\"" . $name . "_unsub\" value=\"&lt;&lt;\">";
		$buf .= "  </td>\n";
		$buf .= "  <td>\n";

		if( is_array( $right ) )
			{
			reset( $right );
 			while( list( $key, $val ) = each( $right ) )
				{
				$buf .= "   <input type=\"hidden\" name=\"" . $name . "_orig_right[" . $key . "]\" value=\"" . urlencode( $right[$key] ) . "\">\n";
				}
			}

		$buf .= "   <select name=\"" . $name . "_sel_right[]\" size=" . $size . " multiple>\n";

		if( is_array( $right ) )
			{
			reset( $right );
 			while( list( $key, $val ) = each( $right ) )
				{
				$buf .= "    <option value=\"" . $key . "\">" . $right[$key] . "</option>\n";
				}
			}

		$buf .= "   </select>\n";
		$buf .= "  </td>\n";
		$buf .= " </tr>\n";
		$buf .= "</table>\n";

		return $buf;
		}

 	Function TWIGProcessLeftRightOptions( $name )
		{
		$varvarname_sub = $name . "_sub";
		$varvarname_unsub = $name . "_unsub";
		$varvarname_left = $name . "_left";
		$varvarname_right = $name . "_right";
		$varvarname_sel_left = $name . "_sel_left";
		$varvarname_sel_right = $name . "_sel_right";
		$varvarname_orig_left = $name . "_orig_left";
		$varvarname_orig_right = $name . "_orig_right";
		GLOBAL $$varvarname_sub, $$varvarname_unsub;
		GLOBAL $$varvarname_left, $$varvarname_right;
		GLOBAL $$varvarname_sel_left, $$varvarname_sel_right;
		GLOBAL $$varvarname_orig_left, $$varvarname_orig_right;

		TWIGDebug( "TWIGProcessLeftRightOptions( \"" . $name . "\" )" );

 		if( ${$name . "_sub"} || ${$name . "_unsub"} )
 			{
 			if( ${$name . "_unsub"} )
 				{
 				if( is_array( ${$name . "_sel_right"} ) )
 					{
 					while( list( $key, $val ) = each( ${$name . "_sel_right"} ) )
 						{
						${$name . "_orig_left"}[$val] = ${$name . "_orig_right"}[$val];
						unset( ${$name . "_orig_right"}[$val] );
 						}
 					}
 				}

 			if( ${$name . "_sub"} )
 				{
 				if( is_array( ${$name . "_sel_left"} ) )
 					{
 					while( list( $key, $val ) = each( ${$name . "_sel_left"} ) )
 						{
						${$name . "_orig_right"}[$val] = ${$name . "_orig_left"}[$val];
						unset( ${$name . "_orig_left"}[$val] );
 						}
 					}
 				}
			}

		if( is_array( ${$name . "_orig_left"} ) )
			{
			reset( ${$name . "_orig_left"} );
			while( list( $key, $val ) = each( ${$name . "_orig_left"} ) )
				{
				${$name . "_left"}[$key] = urldecode( $val );
				}
			}

		if( is_array( ${$name . "_orig_right"} ) )
			{
			reset( ${$name . "_orig_right"} );
			while( list( $key, $val ) = each( ${$name . "_orig_right"} ) )
				{
				${$name . "_right"}[$key] = urldecode( $val );
				}
			}
 		}

	Function TWIGPrevNext( $currentlow, $total, $pagesize, $context, $linkoption, $displaytype="arrows")
	  	{
	  	GLOBAL $img, $config, $dbconfig;

		if( !$displaytype ) { $displaytype = GetPref( "prevnext", $dbconfig["global_prefs_table"], $config["defaults"]["global"]["prevnext"] ); }

	  	if( $pagesize < 1 ) { $pagesize = 1; }
	  	if( $currentlow > $total ) { $currentlow = $total; }

	  	$currenthigh = $currentlow + $pagesize - 1;

	  	if( $currenthigh > $total ) { $currenthigh = $total; }
	  	if( $currentlow == $currenthigh ) { $current = $currentlow; } else { $current = $currentlow . " - " . $currenthigh; }

	  	if( $currentlow > 1 )
	    		{
	    		$prevhigh = $currentlow - 1;

			if( ( $currentlow - $pagesize ) > 0) { $prevlow = $currentlow - $pagesize; } else { $prevlow = 1; }

	    		if( $prevlow == $prevhigh ) { $prev = "$prevlow"; } else { $prev = $prevlow . " - " . $prevhigh; }
	    		}

	  	if( $currenthigh < $total )
	    		{
	    		$nextlow = $currenthigh + 1;
	    		$nexthigh = $currenthigh + $pagesize;

	    		if( $nexthigh > $total ) { $nexthigh = $total; }
	    		if( $nextlow == $nexthigh ) { $next = "$nextlow"; } else { $next = $nextlow . " - " . $nexthigh; }
	    		}

	  	if( $pagesize > 1 )
	    		{
	    		if( ( $current + $pagesize ) > $total ) { $currentstr = $current - $total; } else { $currentstr = $current . " - " . ( $current + $pagesize - 1 ); }
	    		}

  		include( "lib/prevnext/" . $displaytype . ".prevnext.php3" );

	  	return $out;
	  	}

	// Function to decode a MIME-encoded string
	// Returns the original string, if not MIME
	// See rfc1522 for details
	// Unabashedly ripped from imp - anoah
	Function TWIGDecodeMimeString( $string )
  		{
   		GLOBAL $config;

		TWIGDebug( "TWIGDecodeMimeString( \"" . $string . "\" );", 30 );

  		$pos = strpos( $string, "=?" );

  		if( !is_int( $pos ) ) {	return $string;	}

  		$preceding = substr( $string, 0, $pos ); // save any preceding text

   		$end = strlen( $string );
   		$search = substr( $string, $pos+2, $end - $pos - 2 ); // the mime header spec says this is the longest a single encoded word can be

  		$d1 = strpos( $search, "?" );
  		if( !is_int( $d1 ) ) { return $string; }

   		$charset = strtolower(substr( $string, $pos+2, $d1 ));
  		$search = substr( $search, $d1+1 );

  		$d2 = strpos( $search, "?" );
  		if( !is_int( $d2 ) ) { return $string; }

  		$encoding = substr( $search, 0, $d2 );
  		$search = substr( $search, $d2+1 );

  		$end = strpos( $search, "?=" );
  		if( !is_int( $end ) ) { return $string; }

  		$encoded_text = substr( $search, 0, $end );
  		$rest = substr( $string, ( strlen( $preceding . $charset . $encoding . $encoded_text ) + 6 ) );

  		switch( $encoding )
			{
  			case "Q":
  			case "q":
				// the new twig way: str_replace is faster
    				$encoded_text = str_replace( "_", " ", $encoded_text );
    				$decoded = quoted_printable_decode( $encoded_text );

				// the old twig way: ereg is slower, but works in old php
    				// $encoded_text = ereg_replace( '_', ' ', $encoded_text );
    				// $decoded = quoted_printable_decode( $encoded_text );

    				break;
  			case "B":
  			case "b":
    				$decoded = urldecode( base64_decode( $encoded_text ) );

    				break;
  			default:
    				$decoded = "=?" . $charset . "?" . $encoding . "?" . $encoded_text . "?=";

    				break;
  			}

   		if( $config["globalcharset"] )
			{
  			if( $config["globalcharset"] != $charset )
				{
 				$from = $config["charactersets"][$charset];
				$to =  $config["charactersets"][$config["globalcharset"]];

  				if( $from && $to ) { $decoded = convert_cyr_string( $decoded, $from, $to ); }
  				}
  			}

  		return $preceding . $decoded . TWIGDecodeMimeString( $rest );
		}

	Function TWIGProcessGPCString( $string )
		{
		global $config;

		if( !isset( $config["GMQGPC"] ) ) { $config["GMQGPC"] = get_magic_quotes_gpc() + 1; }

		if( $config["GMQGPC"] == 2 )
			{
			return stripslashes( $string );
			}
		else
			{
			return $string;
			}
		}

	Function TWIGProcessGPCtoSQL( $string )
		{
		global $config;

		if( !$config["GMQGPC"] ) { $config["GMQGPC"] = get_magic_quotes_gpc() + 1; }

		if( $config["GMQGPC"] == 1 )
			{
			return addslashes( $string );
			}
		else
			{
			return $string;
			}
		}

        Function TWIGBytesToText( $size = 0 )
                {
                $ranges = array( "B", "KB", "MB", "GB", "TB" );

                if( $size == 0 ) { return "0" . $ranges[0]; }

                $range = floor( floor( log10( $size ) ) / 3 );
                $val = substr( $size / pow( 10, 3 * $range), 0, 3 );

                $ret = sprintf( "%3.0f%s", $val, $ranges[$range] );

                return $ret;
                }

	Function TWIGdate($format, $timestamp)
		{
		GLOBAL $dayNames, $monthNames;

		$str = date( $format, $timestamp );
		$str = str_replace( date( "l", $timestamp ), $dayNames[date( "w", $timestamp )], $str );
		$str = str_replace( date( "F", $timestamp ), $monthNames[date( "n", $timestamp )], $str );

		return $str;
		}

  	Function TWIGExecuteServerCommands( $opencon, $CmdArray )
 		{
 		$cmdtotal = count( $CmdArray );
		$fnum = 0;

 		for( $cmdnum = 0; $cmdnum < $cmdtotal; $cmdnum++ )
 			{
 			if( $CmdArray[$cmdnum][0] ) { fwrite( $opencon, $CmdArray[$cmdnum][0] . "\r\n" ); }

 			if( $CmdArray[$cmdnum][1] )
 				{
 				$chr = "";
 				$rstring = "";
 				while( ord( $chr ) != 10 )
 					{
 					$rstring .= $chr;
 					$chr = fgetc( $opencon );
 					}

 				if( substr( $rstring, 0, strlen( $CmdArray[$cmdnum][1] ) ) != $CmdArray[$cmdnum][1] )
					{
					$failures[$fnum]["sequence"] = $cmdnum;
					$failures[$fnum]["command"] = $CmdArray[$cmdnum][0];
					$failures[$fnum]["expected"] = $CmdArray[$cmdnum][1];
					$failures[$fnum]["result"] = $rstring;
					$failures[$fnum]["type"] = $CmdArray[$cmdnum][2];

					$fnum++;

					if( $CmdArray[$cmdnum][2] == 0 )
						{
						$failures["count"] = $fnum;
						return $failures;
						}
					}
 				}
 			}

		$failures["count"] = $fnum;

		return $failures;
 		}

	Function TWIGPrintESCErrors( $ESCErrors )
		{
		for( $i = 0; $i < $ESCErrors["count"]; $i++ )
			{
			if( $ESCErrors[$i]["type"] == 1 )
				{
				TWIGPrintError( "Warning on server command(" . $ESCErrors[$i]["sequence"] . "): " . $ESCErrors[$i]["command"] . " expected result: " . $ESCErrors[$i]["expected"] . " received result: " . $ESCErrors[$i]["result"] . " (" . substr( $ESCErrors[$i]["result"], 0, strlen( $ESCErrors[$i]["expected"] ) ) . ")" );
				}
			else
				{
				TWIGPrintError( "Error on server command(" . $ESCErrors[$i]["sequence"] . "): " . $ESCErrors[$i]["command"] . " expected result: " . $ESCErrors[$i]["expected"] . " received result: " . $ESCErrors[$i]["result"] . " (" . substr( $ESCErrors[$i]["result"], 0, strlen( $ESCErrors[$i]["expected"] ) ) . ")" );
				}
			}
		}

	Function TWIGGetTimeFormat()
		{
		GLOBAL $config, $dbconfig;

		$ret = $config["timeformat"][GetPref( "timeformat", $dbconfig["global_prefs_table"], $config["defaults"]["global"]["timeformat"] )];

		if( !$ret ) { $ret = $config["timeformat"]["12"]; }

		return $ret;
		}

  	Function TWIGCheckTimeFormat( $fstring )
  		{
  		GLOBAL $config;

  		// there should be either "h", "g", "H" or "G" in timeformat, if unsure use "am/pm"

  		if( ereg( "H|G", $fstring ) ) { return 24; }
  		else { return 12; }
  		}

	Function TWIGDateTimeFromUTime( $utime )
		{
		$year = date ( "Y", $utime );
		$month = date ( "n", $utime );
		$day = date ( "j", $utime );
		$hour = date( "H", $utime );
		$minute = date( "i", $utime );

		return array( $year, $month, $day, $hour, $minute );
		}

	Function TWIGTimeCleanup( $hour, $minute, $ampm )
		{
		if( !isset( $hour ) )
			{
			$hour = date( "H" );
			}

		if( !isset( $minute ) )
			{
			$minute = date( "i" );
			}
		//$minute = 5 * round( $minute / 5 );
		$minute = $minute - $minute % 5;
		while( $minute > 59 )
			{
			$hour++;
			$minute -= 60;
			}

		if( $ampm == "PM" )
			{
  			if( $hour < 13 )
				{
				$hour += 12;
				}
			}

		if( $ampm == "AM" )
			{
			if( $hour == 12 )
				{
				$hour = 0;
				}
			}

		$day = 0;
		while( $hour > 24 )
			{
			// This is a "remainder" of sorts (well, days, actually ;-).
			$day++;
			$hour -= 24;
			}

		return array( $hour, $minute, $day );
		}

	Function TWIGDateCleanup( $year, $month, $day, $extra_days )
		{
		if( !isset( $year ) )
			{
			$year = date( "Y" );
			}

		if( !isset( $month ) )
			{
			$month = date( "m" );
			}
		while( $month > 12 )
			{
			$year++;
			$month -= 12;
			}
		while( $month < 1 )
			{
			$year--;
			$month += 12;
			}

		if( !isset( $day ) )
			{
			$day = date( "j" );
			}
		$day += $extra_days;

		// The last day of this month is the 0th day of next month
		$lastday = date( "j", mktime(0, 0, 0, $month + 1, 0, $year ) );
		while( $day > $lastday )
			{
			$month++;		// Add the number of days of *this* month
			$day -= $lastday;	// To skip to the correct day of *next* month
			$lastday = date( "j", mktime(0, 0, 0, $month + 1, 0, $year ) );
			}
		while( $day < 1 )
			{
			$month--;
			$lastday = date( "j", mktime(0, 0, 0, $month + 1, 0, $year ) );
			$day += $lastday;	// Add the number of days of *last* month
			}			// To skip to the correct day of *this* month

		// Recalculate the month/year because we just readjusted the day/month
		while( $month > 12 )
			{
			$year++;
			$month -= 12;
			}
		while( $month < 1 )
			{
			$year--;
			$month += 12;
			}

		return array( $year, $month, $day );
		}

 	Function TWIGUTimeToJulianDay( $utime )
 		{
		// This function returns a Julian Day for the given timestamp
		// Copied from the interactive PHP documentation.
		// Posted by erik at nospam dot tba dot com dot br, from 05-Mar-2002 10:24
		$ts = getdate( $utime );

 		$a = floor( ( 14 - $ts["mon"] ) / 12 );
 		$y = floor( $ts["year"] + 4800 - $a );
 		$m = floor( $ts["mon"] + 12 * $a - 3 );
 		$jd = $ts["mday"] + floor( ( 153 * $m + 2 ) / 5 ) + $y * 365;
 		$jd += floor( $y / 4 ) - floor( $y / 100 ) + floor( $y / 400 ) - 32045;
 		return $jd;
 		}

	Function TWIGAddToUTime( $utime, $q = 1, $u = "mday" )
		{
		// This function takes a timestamp and adds $q quantity of unit $u.
		// Very useful to avoid breaking the time across a DST shift.

		// The default values are meant to replace $utime += 86400; which is a bad idiom.

		$ts = getdate( $utime );
		return mktime(
			$ts["hours"]	+ ( $u == "hours"	? $q : 0 ),
			$ts["minutes"]	+ ( $u == "minutes"	? $q : 0 ),
			$ts["seconds"]	+ ( $u == "seconds"	? $q : 0 ),
			$ts["mon"]	+ ( $u == "mon"		? $q : 0 ),
			$ts["mday"]	+ ( $u == "mday"	? $q : 0 ),
			$ts["year"]	+ ( $u == "year"	? $q : 0 )
			);
		}

  	Function TWIGTimeSelector( $prefix, $hour, $minute )
  		{
  		GLOBAL $config;

  		$timeformat = TWIGCheckTimeFormat( TWIGGetTimeFormat() );

  		if( $timeformat == 24 )
 			{
 			$hour_start = 0;
 			$hour_end = 23;
 			}
  		else
  			{
  			$hour_start = 1;
  			$hour_end = 12;

  			if( $hour > 11 )
  				{
  				$hour -= 12;
  				$ampm = "PM";
  				}
  			else
 				{
 				$ampm = "AM";
 				}

  			if( $hour == 0 ) { $hour = 12; }
  			}

  		$hour_str = "<select name=\"" . $prefix . "Hour\">\n";

  		for( $i = $hour_start; $i <= $hour_end; $i++ )
  			{
  			if( $hour == $i ) { $hour_str .= "<option selected>" . $i . "</option>";}
  			else { $hour_str .= "<option>" . $i . "</option>"; }
  			}

  		$hour_str .= "\n</select>";

  		$min_str = "<select name=\"" . $prefix . "Minute\">\n";

  		for( $i = 0; $i < 60; $i += 5 )
  			{
  			$min = $i;

  			if( $min < 10 ) { $min = "0" . $min; }

  			if( $minute == $min) { $min_str .= "<option selected>" . $min . "</option>";}
  			else { $min_str .= "<option>" . $min . "</option>"; }
  			}

  		$min_str .= "\n</select>\n";

  		if( $timeformat == 12 )
  			{
  			$ampm_str = "<select name=\"" . $prefix . "AMPM\">";

  			if( $ampm == "AM" ) { $ampm_str .= "<option selected>AM</option>\n<option>PM</option>\n"; }
  			else { $ampm_str .= "<option>AM</option>\n<option selected>PM</option>\n"; }

  			$ampm_str .= "</select>\n";
  			}
  		else
 			{
 			$ampm_str = "";
 			}

  		return $hour_str . "<b>:</b>\n" . $min_str . $ampm_str;
  		}

   	Function TWIGDateSelector( $prefix, $year, $month, $day )
   		{
   		GLOBAL $config, $monthNames;

	      		$ret .= "<SELECT name=\"" . $prefix . "Month\">\n";

 			for( $i = 1; $i <= 12; $i++ )
        				{
        				$ret .= "<option ";
        				if( $month == $i ) { $ret .= "selected "; }
	        			$ret .= "value=\"" . $i . "\">" . $monthNames[$i] . "</option>\n";
        				}

 			$ret .= "</SELECT>\n";

	    		$ret .= "<SELECT name=\"" . $prefix . "Day\">\n";

      			for( $i = 1; $i <= 31; $i++ )
        				{
        				$ret .= "<option ";
		       			if( $day == $i ) { $ret .= "selected "; }
        				$ret .= "value=\"" . $i . "\">" . $i . "</option>\n";
        				}

	 		$ret .= "</SELECT>\n";

	    		$ret .= "<SELECT name=\"" . $prefix . "Year\">\n";

      			for( $i = $year - 10, $j = $year + 10; $i < $j; $i++ )
        				{
        				$ret .= "<option ";
        				if( $year == $i ) { $ret .= "selected "; }
	        			$ret .= "value=\"" . $i . "\">" . $i . "</option>\n";
        				}

    			$ret .= "</SELECT>\n";

 		return $ret;
 		}

        Function TWIGPhrase( $phrase, $args = array() )
                {
                Global $TWIGphrase, $config;

		// Do the initial lookup from the phrases array
		$translation = $TWIGphrase[$phrase];

		// See if this string requires a plural selection
		if( is_array( $translation ) )
			{
			// The position array member tells us which index of
			// args holds the degree argument. We're off-by-one
			// because the phrases start with 1, but arrays start
			// with 0. Duh!
			$n = $args[$translation["position"]-1];

			$pluralfunc = "TWIGPlural" . $config["language"];
			if( function_exists( $pluralfunc ) )
				$plural = $pluralfunc( $n );

			// Don't worry if this array member doesn't exist,
			// because then translation will be empty and thus
			// revert to phrase in the next if block!
			$translation = $translation[$plural];
			}

		// This is a separate block in case the plural selection failed
		if( $translation == "" )
			{
			TWIGDebug( "'$phrase' was not found in the string files!", 10);
			$TWIGphrase[$phrase] = $phrase;
			$translation = $phrase;
			}

		for( $i = 0, $j = count( $args ); $i < $j; $i++ )
			{
			$translation = str_replace( "%" . ($i+1), $args[$i], $translation );
			}

		return $translation;
		}

	// Set a session variable, using defaults if necessary, and track default values.
	$TWIGSessionDefaults = array();

	Function TWIGSessionSet( $key, $val, $def=NULL, $nullok=FALSE )
		{
		global $session, $TWIGSessionDefaults;

		if( strlen( $val ) || $nullok ) { $session[$key] = $val; }
		elseif( !isset( $session[$key] ) && isset( $def ) ) { $session[$key] = $def; }

		if( isset( $def ) ) { $TWIGSessionDefaults[$key] = $def; }

		return $session[$key];
		}

	$included["common.inc.php3"] = 1;
	}

?>
