<?php	// TWIG		Header Configuration File ?>
<?php

	$config["fromdomain"]		= "foo.com";		// This is where mail will be sent from
	$config["basedir"]		= "/twig";		// The path of the URL to your TWIG installation
	$config["imgdir"]		= "/twig/images";	// The path to graphics files
	$config["index"]		= "index.php3";		// This is what you name the index file
								// Note: index.php3 can be aliased to the value of $config["basedir"] 
								// in apache's httpd.conf, which cleans up the URL area.

 	$config["auth"]			= "forms";		// Authorization Type (basic|forms)
	$config["auth_timeout"]		= 3600;			// Set the auth cookie timeout value, in seconds. Set to 0 for session length cookies 
	$config["auth_logout_redirect"]	= "";			// Complete URL to redirect browsers to after they have been logged out
 	$config["auth_provider"]	= "imap-new";		// Authorization Method (imap-new|imap|sqltable|mysql|pgsql|ldap|sqlimap|sqlopen|nntp|ibase|imap-limit|oracle|pop3)

	$config["security"]		= "basic";		// Type of security to use (basic|advanced)

	$config["groups"]		= "standard"; 		// What level of group support to use (none|standard|personal|userperms)

        $config["language"] 		= "english"; 		// language file to use (english is the default).
	                                                        // language files are in /lib/strings
                                                                // language options are in /features/prefs/modules/global.inc.php3

	$config["spellcheck"]		= "/usr/local/bin/aspell -a"; // Command, including full path and flags, to run a spellcheck (via pipe)

	$config["session_handler"]	= "get";		// Session handler (get|get2|sqltable|php4session)
	$config["session_expiry"]	= 300;			// How long session records are retained (in seconds)
	$config["login_handler"]	= "cookie";		// Login handler (cookie|sqltable|base64cookie|php4session|session|securecookie.php4session|securecookie.sqltable)

	$config["default_feature"]	= "main";		// Which feature should TWIG load upon login (main|mail|news|contacts|schedule|meetings|todo|notes|bookmarks|preferences|help|groups)
	$config["announcements"]	= "basic";		// Announcements type (basic|advanced)

								// Color Configuration
	$config["cellcolor"]		= "#e0e0e0";		// Background color of certain cells
	$config["cellcoloralt"]		= "#ffffff";		// Alternate background color of list cells
	$config["cellcolorhigh"]	= "#b0c4de";		// Hilight backgroud color of cells
	$config["celltext"]		= "#000000";		// Text color inside those cells
	$config["cellheadcolor"]	= "#778899";		// Background color of header cells
	$config["cellheadtext"]		= "#ffffff";		// Text color inside those cells
	$config["tabcolorlight"] 	= "#c6c6c6";		// The light (main body) color of tabs
	$config["tabcolordark"] 	= "#848484"; 		// The light (highlight) color of tabs
	$config["cellfont"]		= "Arial,Helvetica";	// Font of text inside those cells
	$config["textfontsize"] 	= "+0";			// Font size
	$config["titlefontsize"]	= "+1";			// Title font size
	$config["largetitlefontsize"] 	= "+2";			// Large title font size
	$config["smallfontsize"] 	= "-1";			// Small text font size
	$config["tinyfontsize"] 	= "-2";			// Really small text font size
	$config["hr"] 			= "<hr>";		// Horizontal Rule tags

 	$config["timeformat"]["12"]	= "h:i a";		// Format to display time in (12 hour foramt)
 	$config["timeformat"]["24"]	= "H:i";		// Format to display time in (24 hour format)
	$config["longdateformat"]	= "l, F j Y";		// Format to display long dates in
 	$config["shortdateformat"]	= "m/d/y";		// Format to display dates in
        $config["firstdayweek"]         = 0;                    // 1st day in week, 0=sunday, 1=monday

								// IMAP Mail Server Settings
	$config["imap_servertype"]	= "php-imap";		// Mail system to use (defaults to php-imap) (php-imap|php-pop3)
	$config["imap_server"]		= "localhost";		// IMAP Server Host (defaults to localhost)
	$config["imap_port"]		= "143";		// IMAP Server Port (defaults to 143)
	$config["imap_path"]		= "";			// IMAP Mail Path (defaults to home dir)
								// Set to "INBOX." for Cyrus and Courier IMAP servers.
	$config["mail_folder_delimiter"]= "/";			// Character that divides heirarchical levels of folder names ("/" for UofW IMAP, "." for Cyrus and Courier)

 	$config["mail_sender"]		= "relay";		// How to we deal with outgoing mail? (internal/relay/imap-mail)
	$config["smtp_server"]		= "localhost";		// SMTP Relay server to send mail through
	$config["smtp_port"]		= "25";			// SMTP Relay server port to send mail through
	$config["smtp_clientip"]	= 0;			// Add "X-Client-IP: <ip address of web browser>" to SMTP headers.  (0|1)

 	$config["news_server"]		= "news";		// News Server Host (defaults to localhost)
 	$config["news_port"]		= "119";		// News Server Port (defaults to 119)

//	$vhosts["<server_name>"]	= "config/<server_name>"; // Setup support for virtual hosts

								// Non-overridable feature disables
	$disabled["global_goto"]	= 0;			// Disable the goto box at the bottom of page (1=yes, 0=no)
	$disabled["mail_showattach"] 	= 1;			// Disable extra message info in mailbox view (off for performance boost)
	$disabled["mail_configfrom"]	= 1;			// Disable the user's ability to change their from address
	$disabled["search"]		= 1;			// Disable the Search feature (currently in beta)

	$config["debug"]		= 0;			// Set to 10 view debugging output in some parts of TWIG
								// Set to 20 to view more detailed info, but may conflict with cookie setting, 
								//     if you need this level you should set the login handler to sesssion
								// Set to 30 to see lots of extra information that is typiclly useless :)
?>
