/*
	TuxPuck - data2c.c
	Copyright (C) 2001-2002 Jacob Kroon

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Jacob Kroon - d00jkr@efd.lth.se
*/

/* includes */
#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <SDL_types.h>
#include <SDL_endian.h>

void errorc(char *msg)
{
  fprintf(stderr, "%s\n", msg);
  exit(1);
}

void errorcc(char *msg1, char *msg2)
{
  fprintf(stderr, "%s%s\n", msg1, msg2);
  exit(1);
}

int main(int argc, char **argv)
{
  FILE *in = NULL, *out = NULL;
  char buffer[100];
  unsigned char ch;
  int i = 0;
  Uint32 size;
  struct stat theStat;

  if (argc != 3)
    errorc("Usage : data2c <file> <array>");
  if ((in = fopen(argv[1], "r")) == NULL)
    errorcc("Couldn't open file for reading : ", argv[1]);
  stat(argv[1], &theStat);
  size = theStat.st_size;
  sprintf(buffer, "%s.c", argv[2]);
  if ((out = fopen(buffer, "w")) == NULL)
    errorcc("Couldn't open file for writing : ", buffer);
  fprintf(out, "/* %s */\n", buffer);
  fprintf(out, "unsigned char %s[] = {\n", argv[2]);
  for (i = 0; i < 4; i++)
    fprintf(out, "%d,", ((Uint8 *) & size)[i]);
  while (fread(&ch, 1, 1, in) != 0)
    fprintf(out, "%d,", ch);
  fseek(out, -1, SEEK_CUR);
  fprintf(out, "};\n");
  fclose(in);
  fclose(out);
  return 0;
}
