/*
	TuxPuck - timer.c
	Copyright (C) 2001-2002 Jacob Kroon

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Jacob Kroon - d00jkr@efd.lth.se
*/

/* includes */
#include <stdlib.h>
#include <SDL_timer.h>
#include "timer.h"

/* structs */
struct _Timer
{
  Uint32 start, end, elapsed_time;
};

/* functions */
Timer *timer_create(void)
{
  Timer *timer = NULL;

  timer = malloc(sizeof(Timer));
  timer->start = SDL_GetTicks();
  timer->end = timer->start;
  timer->elapsed_time = 0;
  return timer;
}

void timer_free(Timer * timer)
{
  free(timer);
}

void timer_reset(Timer * timer)
{
  timer->start = SDL_GetTicks();
  timer->end = 0;
}

void timer_update(Timer * timer)
{
  timer->end = SDL_GetTicks();
  timer->elapsed_time = timer->end - timer->start;
}

Uint32 timer_elapsed(Timer * timer)
{
  return timer->elapsed_time;
}
