/*
	TuxPuck - intro.c
	Copyright (C) 2001-2002 Jacob Kroon

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Jacob Kroon - d00jkr@efd.lth.se
*/

/* includes */
#include <SDL_events.h>
#include <SDL_timer.h>
#include "video.h"
#include "font.h"
#include "timer.h"

/* defines */
#define FADE_SPEED	((float)100.0)

/* externals */
extern unsigned char title_jpg[];
extern unsigned char logo_jpg[];
extern unsigned char ghost_fnt[];

/* functions */
void run_intro(void)
{
  Uint8 loop = 1, state = 0;
  Uint32 elapsed_time = 0;
  float alpha = 0.0;
  SDL_Event event;
  SDL_Surface *sdl_title = NULL, *sdl_logo = NULL;
  SDL_Rect text_rect, logo_rect;
  Font *fnt_ghost = NULL;
  Timer *timer = NULL;
  char txt_coder[] = "written by Jacob Kroon";
  char txt_gfx[] = "graphics by m0ns00n";
  char txt_version[] = "v" _VERSION;

  sdl_title = video_create_jpg_surface(title_jpg, NULL);
  sdl_logo = video_create_jpg_surface(logo_jpg, NULL);
  logo_rect.x = 0;
  logo_rect.y = SCREEN_H / 2 - sdl_logo->h / 2 - 9;
  logo_rect.w = logo_rect.h = 0;
  video_box_up(sdl_title, 8000);
  video_save();
  fnt_ghost = font_create(ghost_fnt, NULL);
  font_set_color(fnt_ghost, 170, 140, 110);
  font_set_pen(fnt_ghost, 70, logo_rect.y + sdl_logo->h);
  timer = timer_create();
  timer_reset(timer);
  while (loop)
    {
      while (SDL_PollEvent(&event))
	if (event.type == SDL_MOUSEBUTTONDOWN)
	  loop = 0;
      timer_update(timer);
      timer_reset(timer);
      elapsed_time = timer_elapsed(timer);
      switch (state)
	{
	case 0:
	  alpha += FADE_SPEED * 2.0 * elapsed_time / 1000.0;
	  if (alpha > 255.0)
	    alpha = 255;
	  video_erase(&logo_rect);
	  video_set_alpha(sdl_logo, (Uint8) alpha);
	  video_blit(sdl_logo, NULL, &logo_rect);
	  font_set_alpha(fnt_ghost, alpha);
	  video_erase(&text_rect);
	  font_print(fnt_ghost, txt_version, &text_rect);
	  if (alpha == 255.0)
	    {
	      alpha = 0.0;
	      state = 1;
	      font_set_pen(fnt_ghost,
			   SCREEN_W / 2 - font_calc_width(fnt_ghost,
							  txt_coder) / 2,
			   SCREEN_H - 80);
	      memset(&text_rect, 0, sizeof(SDL_Rect));
	    }
	  break;
	case 1:
	  alpha += FADE_SPEED * elapsed_time / 1000.0;
	  if (alpha > 255.0)
	    {
	      state = 2;
	      alpha = 255.0;
	    }
	  font_set_alpha(fnt_ghost, (Uint8) alpha);
	  video_erase(&text_rect);
	  font_print(fnt_ghost, txt_coder, &text_rect);
	  break;
	case 2:
	  alpha -= FADE_SPEED * elapsed_time / 1000.0;
	  if (alpha < 0.0)
	    {
	      state = 3;
	      alpha = 0.0;
	    }
	  font_set_alpha(fnt_ghost, (Uint8) alpha);
	  video_erase(&text_rect);
	  font_print(fnt_ghost, txt_coder, &text_rect);
	  if (alpha == 0.0)
	    font_set_pen(fnt_ghost,
			 SCREEN_W / 2 - font_calc_width(fnt_ghost,
							txt_gfx) / 2,
			 SCREEN_H - 80);
	  break;
	case 3:
	  alpha += FADE_SPEED * elapsed_time / 1000.0;
	  if (alpha > 255.0)
	    {
	      state = 4;
	      alpha = 255.0;
	    }
	  font_set_alpha(fnt_ghost, (Uint8) alpha);
	  video_erase(&text_rect);
	  font_print(fnt_ghost, txt_gfx, &text_rect);
	  break;
	case 4:
	  alpha -= FADE_SPEED * elapsed_time / 1000.0;
	  if (alpha < 0.0)
	    {
	      state = 5;
	      alpha = 0.0;
	    }
	  font_set_alpha(fnt_ghost, (Uint8) alpha);
	  video_erase(&text_rect);
	  font_print(fnt_ghost, txt_gfx, &text_rect);
	  if (alpha == 0.0)
	    font_set_pen(fnt_ghost,
			 SCREEN_W / 2 - font_calc_width(fnt_ghost,
							txt_coder) / 2,
			 SCREEN_H - 80);
	  break;
	case 5:
	  alpha += elapsed_time / 1000.0;
	  if (alpha > 5.0)
	    {
	      state = 1;
	      alpha = 0.0;
	    }
	  break;
	}
      video_update();
      SDL_Delay(_SLEEP);
    }
  SDL_FreeSurface(sdl_title);
  SDL_FreeSurface(sdl_logo);
  font_free(fnt_ghost);
  timer_free(timer);
}
