/*
	TuxPuck - entity.h
	Copyright (C) 2001-2002 Jacob Kroon

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Jacob Kroon - d00jkr@efd.lth.se
*/

#ifndef _ENTITY_H
#define _ENTITY_H

/* includes */
#include <SDL_types.h>

/* defines */
#define PUCK_STATE_ALIVE	1
#define PUCK_STATE_DEAD		2

/* structs */
typedef struct _Entity Entity;
typedef struct _Puck Puck;
typedef Entity Pad;

/* functions */
void entity_blit(Entity *);
void entity_erase(Entity *);
void entity_move(Entity *, Uint32);
Uint8 entity_move_towards(Entity *, float, float, float, Uint32);
void entity_set_position(Entity *, float, float);
void entity_get_position(Entity *, float *, float *);
void entity_set_velocity(Entity *, float, float);
void entity_get_velocity(Entity *, float *, float *);
void entity_set_alpha(Entity *, Uint8);
Pad *pad_create(Uint8);
void pad_free(Pad *);
Puck *puck_create(void);
void puck_free(Puck *);
void puck_move(Puck *, Uint32);
int puck_will_get_hit_by(Puck *, Pad *, Uint32);
void puck_get_hit_by(Puck *, Pad *, Uint32);
int puck_is_dead(Puck *);
void puck_set_state(Puck *, Uint8);

#endif /* _ENTITY_H */
