/*
	TuxPuck - audio.h
	Copyright (C) 2001-2002 Jacob Kroon

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Jacob Kroon - d00jkr@efd.lth.se
*/

#ifndef _AUDIO_H
#define _AUDIO_H

/* includes */
#include <SDL_types.h>

/* structs */
typedef struct _Sound Sound;

/* functions */
void audio_init(void);
void audio_deinit(void);
Sound *audio_create_sound(Uint8 *, Uint32 *);
void audio_free_sound(Sound *);
void audio_play_sound(Sound *);
void audio_set_mute(Uint8);
void audio_set_single(Sound *, Uint8);

#endif /* _AUDIO_H */
