<?php
/*
 * Copyright 1999 - 2002 by Gero Kohnert
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("resource","overview");
 loadmodule("resource");

 /**
  * show a overview of resources
  */
 class resource_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $result = $this->dbconn->Exec($this->q);
     $n = $result->numrows();
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       $result->free();
       return;
     }
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     echo $this->orderHeader("name",$lang['ResName'],$this->link2);
     echo $this->orderHeader("",$lang['ResDesc'],$this->link2);
     echo "</tr>\n";
     echo "</thead>\n";

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     echo "<tbody>\n";
     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $c = new resource($this->dbconn);
       $c->read_result($result,$a);
       $a++;
       if ( ! $c->see_ok() ) {
         continue;
       }
       echo $this->OverviewRowStart($line);
       echo "<td valign=\"top\">". $c->getLink() ."</td>";
       echo "<td valign=\"top\">". myentities($c->desc) ."</td>";
       echo $this->OverviewRowEnd($line++);
     }
     echo "</tbody>\n";

     echo "<tfoot>\n";
     echo $this->list_navigation($this->link1,2,$this->start,$a,$n);
     echo "</tfoot>\n";

     echo $this->OverviewTableEnd();
     $result->free();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['ResOverview'];

     if ( ! $this->user->feature_ok(useresource,PERM_SEE) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }

     $this->link1 = "resource/resource_overview.php";
     $this->q = "SELECT * FROM ". $this->dbconn->prefix ."resources";
     $pre = " WHERE ";

     if ( isset($_GET['name']) && ($_GET['name'] != "*") && ($_GET['name'] != "") ) {
       $this->q .= $pre . $this->dbconn->Like("name",$_GET['name']);
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"name=". UrlEncode($_GET['name']));
     }

     check_dbacl( $this->q, $this->user->id);

     # sorting
     $xxx = "";
     $this->link2 = $this->link1;
     order_parse($this->q,$this->link1,$xxx,$xxx,"name");

     if ( $this->user->feature_ok(useresource,PERM_NEW) ) {
       $m = array( url => "resource/resource_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['ResCreate'],
                   category => array("resource","new","obj")
                 );
       $this->addMenu($m);
     }
   }
 }


 $l = new resource_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: resource_overview.php,v 1.16.2.1 2004/07/06 08:34:11 tapoueh Exp $
    $Author: tapoueh $
-->
