<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup mailbox
 * @module mailbox_show
 * @package mailbox
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('mailbox','show');
 loadmodule('mailbox');
 loadlayout();
 /**
  * show a overview of mails
  */
 class mailbox_show extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     if ( $this->doask ) {
       $this->obj->ask_password();
       return;
     }
     if ( $this->obj->mbox == "" ) {
       echo $this->error("failed");
       return;
     }


     $this->obj->getfolders();
     echo "<form name=\"folderjump\" method=\"GET\" action=\"mailbox_show.php\">\n";
     echo $lang['MailActionGoto'];
     $this->addHidden("id",$this->obj->id);
     echo "<select name=\"path\">\n";
     @reset($this->obj->allfolders);
     @ksort($this->obj->allfolders);
     while (list ($key, $val) = @each($this->obj->allfolders)) {
       echo "<option value=\"". base64_encode($key) ."\"". ($this->obj->addpath == $key ? " selected":"") .">+". myentities($val) ."</option>\n";
     }
     echo "</select>\n";
     echo "<input type=\"submit\" value=\"". $lang['Enter'] ."\" title=\"OK\">\n";
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";


     $this->obj->check();
     if ( $this->search != "" ) {
       $headers = imap_sort($this->obj->mbox,$this->xf -1,($this->xo -1),SE_UID,'TEXT "'. $this->search .'"');
     } else {
       $headers = imap_sort($this->obj->mbox,$this->xf -1,($this->xo -1),SE_UID);
     }

     $this->obj->errors();
     if ($headers == false) {
       echo "<b>". sprintf($lang['MailCountInfo0'],$this->obj->addpath) ."</b><br>";
       return;
     }

     $cnt = count($headers);
     if ( $this->search ) {
       echo "<b>". sprintf($lang['MailCountInfoS'],$cnt,$this->search) ."</b><br>";
     } else {
       echo "<b>". sprintf($lang['MailCountInfo'],$cnt) ."</b><br>";
     }

     echo $this->actionformStart("mailbox_show.php");
     if ( $this->obj->addpath != "" ) {
       $this->addHidden("path",base64_encode($this->obj->addpath));
     }
     $this->addHidden("search",$this->search);
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     echo " <th colspan=\"7\" class=\"nodeco\">";
     echo  menulink($this->obj->parent->getUrl(),$this->obj->parent->getFullname());
     if ( $this->obj->email != "" ) {
       echo  "&nbsp; mails sent to &nbsp; &lt;". $this->obj->email ."&gt;\n";
     }
     echo " </th>\n";
     echo "</tr>\n";
     if ( $this->obj->addpath != "" ) {
       echo "<tr>\n";
       echo " <th colspan=\"7\">". $this->theme->getImage(folder,'list') ." ". myentities($this->obj->addpath). "</th>\n";
       echo "</tr>\n";
     }
     echo "<tr>\n";
     echo " <th>ID</th>\n";
     echo $this->orderHeader(1+SORTDATE,$lang['MailboxSDate'],$this->link1);
     echo $this->orderHeader(1+SORTSUBJECT,$lang['MailboxSubject'],$this->link1);
     echo $this->orderHeader("",$lang['MailboxSender'],$this->link1);
     echo $this->orderHeader("",$lang['MailboxFlags'],$this->link1);
     echo $this->orderHeader(1+SORTSIZE,$lang['MailSize'],$this->link1);
     echo " <th nowrap><input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll2();\"></th>\n";
     echo "</tr>\n";
     echo "</thead>\n";

     $n = 0;
     if ( $this->start == -1 ) {
       $this->start = $cnt - $tutos[maxshow];
       $end = $cnt;
     } else {
       $end = $this->start + $tutos[maxshow];
     }

     $d = new DateTime();

     echo "<tbody>\n";
     foreach ($headers as $hkey => $hval) {
       flush();
       $n++;
       $sbj = "";
       if ( $n < $this->start ) {
         continue;
       }
       if ( $n > $end ) {
         break;
       }
       $s = "";
       $hdr = imap_headerinfo($this->obj->mbox,imap_msgno($this->obj->mbox,$hval)  );
       $id = $hkey;
       $this->obj->errors("mail headers of mail ". $id);

       $u = trim(imap_uid($this->obj->mbox,$hdr->Msgno));
#      echo $hval ." ". $hkey ." ". $u ."<br>";

       $d->setDateTimeTS($hdr->udate);
       echo $this->OverviewRowStart($n);
       echo " <td nowrap>". makelink("mailbox/mail_show.php?mno=". $u ."&id=". $this->obj->id ."&path=". base64_encode($this->obj->addpath)  ,$this->theme->getImage(mail,'list') . sprintf("%'_6d",$id) ,"") ."</td>\n";
       echo " <td>";
       if ( $hdr->date ) {
         echo $hdr->date;
       } else {
         echo $d->getDateTime();
       }
       echo " </td>\n";
       echo " <td>";
       if ( isset($hdr->subject) ) {
         $s = "";
         $x = imap_mime_header_decode($hdr->subject);
         foreach ($x as $f) {
          $s .= $f->text;
         }
         if ( $this->search ) {
           $s = eregi_replace("(". $this->search .")","<span class=\"found\">\\1</span>",$s);
         }
         echo "&nbsp;". $s;
       } else {
         echo "<i><font size=\"-2\">". $lang['MailNoSubject'] ."</font></i>";
       }
       echo " </td>\n";
       echo " <td>\n";
       $pre = "";
       if ( isset($hdr->from) ) {
         @reset($hdr->from);
         while (list ($key,$val) = @each ($hdr->from)) {
           echo $pre;
           $adr = $this->obj->make_mailto($val);
           $from = "";
           if ( isset($val->personal) ) {
             $x = imap_mime_header_decode($val->personal);
             foreach ($x as $f) {
               $from .=  $f->text;
             }
             echo AsEmail($from,$adr,$from,"Re:". $s);
           } else {
             echo AsEmail($adr,$adr,"","Re:". $s);
           }
           $pre = "<br>\n";
         }
       }
       echo " </td>\n";
       echo " <td>&nbsp;". $hdr->Recent . $hdr->Unseen . $hdr->Answered . $hdr->Deleted . $hdr->Draft . $hdr->Flagged ."</td>\n";
       # pretty format size
       $s = $hdr->Size;
       $x = "Bytes";
       if ($s > 1024) {
         $s = sprintf("%01.2f",$hdr->Size / 1024);
         $x = "kB";
       }
       if ($s > 1024) {
         $s = sprintf("%01.2f",$hdr->Size / (1024*1024));
         $x = "MB";
       }
       echo " <td align=\"right\">". $s ." ". $x ."</td>\n";

       echo " <td><center>\n";
       echo " <input name=\"mark[]\" type=\"checkbox\" value=\"". $u ."\">\n";
       echo " </center></td>\n";
       echo $this->OverviewRowEnd($n);
       flush();
       unset ($hdr);
     }
     echo "</tbody>\n";

     $l = $this->obj->getUrl();
     $l = addUrlParameter($l,"path=".base64_Encode($this->obj->addpath));
     $l = addUrlParameter($l,"xf=". $this->xf);
     $l = addUrlParameter($l,"xo=". $this->xo);
     if ( $this->search ) {
       $l = addUrlParameter($l,"search=".$this->search);
     }

     echo "<tfoot>\n";
     echo $this->list_navigation($l,7,$this->start,$n,$cnt);

     echo $this->UpdateRowStart(4);
     echo sprintf($lang['withmarked'],$lang['Mails']);
     echo "<select name=\"mtarget\">\n";
     echo "<option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
     @reset($this->obj->allfolders);
     @ksort($this->obj->allfolders);
     while (list ($key, $val) = @each($this->obj->allfolders)) {
       if ( $val != $this->obj->addpath ) {
         echo "<option value=\"". base64_encode("+". $key) ."\">". sprintf($lang['MailActionCopy'],$val) ."</option>\n";
       }
     }
     @reset($this->obj->allfolders);
     @ksort($this->obj->allfolders);
     while (list ($key, $val) = @each($this->obj->allfolders)) {
       if ( $val != $this->obj->addpath ) {
         echo "<option value=\"". base64_encode("-". $key) ."\">". sprintf($lang['MailActionMove'],$val) ."</option>\n";
       }
     }
     echo "<option value=\"". base64_encode("TRASH") ."\" selected>". $lang['MailActionDel']."</option>\n";
     echo "<option value=\"". base64_encode("SEEN") ."\" selected>". sprintf($lang['SetTo'],$lang['MailboxFlags'],"SEEN") ."</option>\n";
     echo "<option value=\"". base64_encode("UNSEEN") ."\" selected>". sprintf($lang['SetTo'],$lang['MailboxFlags'],"not SEEN") ."</option>\n";
     echo "<option value=\"". base64_encode("FLAG") ."\" selected>". sprintf($lang['SetTo'],$lang['MailboxFlags'],"FLAGGED") ."</option>\n";
     echo "<option value=\"". base64_encode("UNFLAG") ."\" selected>". sprintf($lang['SetTo'],$lang['MailboxFlags'],"UNFLAGGED") ."</option>\n";
     echo "</select>\n";
     echo $this->UpdateRowEnd(3);


     if ( ereg("imap",$this->obj->type) ) {
       echo "<tr>\n";
       echo " <td colspan=\"3\">". $lang['MailNewFolder'] ."</td>\n";
       echo " <td colspan=\"3\">\n";
       echo "  <input name=\"new\"></input>\n";
       echo " </td>\n";
       echo " <td colspan=\"1\"><input type=\"submit\" value=\"OK\"></td>\n";
       echo "</tr>\n";
     }
     echo "</tfoot>\n";

     echo $this->OverviewTableEnd();
     $this->addHidden("id",$this->obj->id);
     hiddenFormElements();
     echo $this->getHidden();
     echo $this->actionformEnd("mailbox_show.php");
   }
   /**
    * navigate
    */
   Function navigate() {
     global $lang;

     echo "<tr><td>\n";
     if ( ($this->obj->id > 0) && $this->obj->see_ok() ) {
       if ( $this->user->feature_ok(usemailboxes,PERM_SEL) ) {
         $url = "mailbox/mail_select.php?id=". $this->obj->id ;
         $url = addUrlParameter($url,"path=".base64_Encode($this->obj->addpath));
         echo menulink($url ,$lang['Search'],sprintf($lang['MailboxSearch'],$this->obj->getFullname())) ."&nbsp;<br>";
       }
     }

     if ( ($this->obj->id > 0) && ($this->obj->addpath != "") ) {
       echo confirmlink("mailbox/mailbox_show.php?id=". $this->obj->id ."&delfolder=". base64_Encode($this->obj->addpath) ,$lang['Delete'],sprintf($lang['MailDelFolderI'],$this->obj->addpath)) ."&nbsp;<br>";
     }
     echo "</td></tr>\n";
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->obj = new mailbox($this->dbconn);
     $this->name = $lang['MailboxOverview'];
     $this->link1 = "mailbox/mailbox_show.php";
     if ( isset($_GET['xf']) ) {
       $this->xf = $_GET['xf'];
     } else {
       $this->xf = 1+SORTDATE;
     }
     if ( isset($_GET['xo']) ) {
       $this->xo = $_GET['xo'];
     } else {
       $this->xo = 2;
     }
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       $this->link1 = addUrlParameter($this->link1,"id=".UrlEncode($_GET['id']));
     } else if ( isset($_POST['id']) ) {
       $this->obj->read($_POST['id']);
       $this->link1 = addUrlParameter($this->link1,"id=".UrlEncode($_POST['id']));
     } else {
       $this->stop = true;
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
     }
     if ( $this->obj->id < 1 ) {
       $this->stop = true;
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
     } else if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }

     $nopw = ($this->obj->pw == "" );
     $this->doask = false;
     $x = sprintf("mpw%d",$this->obj->id);
     if ( isset($_POST['mbpw']) ) {
       $this->obj->pw = $_POST['mbpw'];
       $_SESSION[$x] = $this->obj->pw;
     } else if ( isset($_SESSION[$x]) ) {
       $this->obj->pw = $_SESSION[$x];
     }
     if ( isset($_GET['path']) ) {
       $this->path = base64_Decode($_GET['path']);
       $this->obj->setPath($this->path);
       $this->link1 = addUrlParameter($this->link1,"path=".UrlEncode($_GET['path']));
     } else {
       $this->path = "";
     }
     if (! isset($_GET['search']) ) {
       $this->search = "";
     } else {
       $this->search = $_GET['search'];
     }

     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array( url => "mailbox/mailbox_new.php?id=". $this->obj->id,
                   text => $lang['Modify'],
                   info => sprintf($lang['MailboxModifyI'],$this->obj->getFullname()),
                   category => array("mailbox","mod","obj")
                 );
       $this->addMenu($x);
     }

     # Open the box
     if ( ($this->stop == false) ) {
#    echo $this->obj->pw ." ". $this->obj->getConnString();
#    flush();
       if (false == $this->obj->open()) {
         if ( $nopw ) {
           $this->doask = true;
         } else {
           $this->stop = true;
         }
         return;
       }
     }

     # actions
     if ( $this->stop == false ) {
       # Delete a mail
       if ( isset($_GET['del']) ) {
         $this->obj->delete_mail($_GET['del']);
         $msg .= $lang['MailDeleted'];
       }
       # Delete a folder
       if ( isset($_GET['delfolder']) ) {
         if ( $_GET['delfolder'] != "" ){
           $this->obj->deletefolder(base64_Decode($_GET['delfolder']));
           $msg .= sprintf($lang['MailFolderDeleted'], base64_Decode($_GET['delfolder']));
         }
       }
       # Create new folder
       if ( isset($_GET['new']) ) {
         if ( $_GET['new'] != "" ){
           $this->obj->createfolder($_GET['new']);
           $msg .= sprintf($lang['MailFolderCreated'], $_GET['new']);
         }
       }
       # Some action
       if ( isset($_GET['mtarget']) ) {
         if ( $_GET['mtarget'] != -1 ) {
           $mtarget = base64_decode($_GET['mtarget']);
           @reset($_GET['mark']);
           while (list ($key,$val) = @each ($_GET['mark'])) {
             if ( $mtarget == "FLAG" ) {
               $this->obj->flag_mail($val,"\\Flagged");
             } else if ( $mtarget == "UNFLAG" ) {
               $this->obj->unflag_mail($val,"\\Flagged");
             } else if ( $mtarget == "SEEN" ) {
               $this->obj->flag_mail($val,"\\Seen");
             } else if ( $mtarget == "UNSEEN" ) {
               $this->obj->unflag_mail($val,"\\Seen");
             } else if ( $mtarget == "TRASH" ) {
               $this->obj->delete_mail($val);
             } else if ( ereg("^\+(.*)",$mtarget,$mm) ) {
               imap_mail_copy($this->obj->mbox,$val,$this->obj->orgpath.$mm[1],FT_UID);
             } else if ( ereg("^-(.*)",$mtarget,$mm) ) {
               imap_mail_move($this->obj->mbox,$val,$this->obj->orgpath.$mm[1],FT_UID);
             }
           }
           $this->obj->mail_expunge();
         }
       }
     }

     $this->addtohistory();

   }
 }

 $l = new mailbox_show($current_user);
 $l->display();
 $l->obj->close();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: mailbox_show.php,v 1.9 2004/01/09 10:22:30 gokohnert Exp $
    $Author: gokohnert $
-->
