<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup company
 * @module company_new
 * @package company
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("company","new");

 /**
  * change/modify a company
  */
 class company_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $tutos,$lang,$table;

     $this->assign('id', $this->obj->id);
     $this->assign('action', 'company_ins.php');

     if( $this->obj->id < 0 )
       $this->assign('title', $lang['CompanyCreate']);
     else
       $this->assign('title', $lang['CompanyModify']);

     $this->assign('acl_link', acl_link($this->obj));

     $this->assign('name',
		   array('id'    => 'name',
			 'name'  => 'name',
			 'label' => $lang['Company'],
			 'value' => myentities($this->obj->name),
			 'size'  => min($table['company']['name'][size],30),
			 'maxl'  => min($table['company']['name'][size])));

     $this->loc->ask_location($this, True);

     /*
     // Fields which companies do not use
     $this->addHidden("department","");
     $this->addHidden("c_id",$this->obj->id);
     $this->addHidden("category",2);
     $this->addHidden("cploc",0);
     $this->addHidden("loc_id",$this->loc->id);

     echo "<tr>\n";
     if ($this->obj->id > 0 ) {
       submit_reset(0,1,1,1,1,1);
     } else {
       submit_reset(0,-1,1,1,1,1);
     }
     echo "</tr>\n";

     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     if ( $this->loc != "" ) {
       echo $this->setfocus("locadd.lname");
     } else {
       echo $this->setfocus("cmpadd.name");
     }
     echo $lang['FldsRequired'] ."\n";
     */

     $this->assign('InputOk',   $lang['InputOk']);
     $this->assign('ChangesOk', $lang['ChangesOk']);
     $this->assign('Enter', $lang['Enter']);
     $this->assign('Reset', $lang['Reset']);

     $this->assign('focus', "cmpadd.name");
     $this->assign('FldsRequired', $lang['FldsRequired']);

     $this->template('company_new');
   }

   /**
    * navigate
    */
   Function navigate() {
     global $lang;

     /*
     echo "<tr><td>\n";

     if ( $this->obj->mod_ok()  ) {
       if (count($this->obj->location) > 0) {
         DoubleTableStart();
         foreach($this->obj->location as $i => $f) {
           echo "<tr><th colspan=\"2\">". sprintf($lang['AdrLocTitle'],$f->lname) ."</th></tr>\n";
           echo "<tr>\n";
           echo " <td>\n";
           if ( $f->mod_ok() ) {
             echo menulink("company_new.php?id=". $this->obj->id ."&loc_id=". $f->id,$lang['Change'],sprintf($lang['ChangeLocInfo'],$f->lname, $this->obj->getFullName()));
           } else {
              echo $lang['Change'];
           }
           echo "</td><td>\n";
           if ( $f->del_ok() ) {
             echo confirmlink("location_del.php?ref=". $this->obj->id ."&id=". $f->id,$lang['Delete'],sprintf($lang['DeleteLocInfo'],$f->lname, $this->obj->getFullName()));
           } else {
             echo $lang['Delete'];
           }
           echo " </td>\n";
           echo "</tr>\n";
         }
         DoubleTableEnd();
       }
       if ( $this->obj->id > 0  ) {
         echo menulink("company_new.php?id=". $this->obj->id ."&loc_id=-1",$lang['AdrLNew'],sprintf($lang['AdrLNewInfo'],$this->obj->getFullName())) ."<br>";
       }
     }
     echo "<br>\n";

     echo "</td></tr>";
     */
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->obj = new company($this->dbconn);
     $this->loc = new location($this->dbconn);

     if ( isset($_GET['id']) && ($_GET['id'] != "-1" )) {
       $this->obj->read($_GET['id']);
       $this->name =
	  $lang['CompanyModify'] .": ".myentities( $this->obj->getFullName());

       if ($this->obj->id < 0) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     }
     else {
       $this->name = $lang['CompanyCreate'];
       $this->obj->name = $lang['PlsChangeName'];
     }
     $this->obj->read_locs_data();

     if ( isset($_GET['loc_id']) && ($_GET['loc_id'] != "-1" )) {
       $loc_id = $_GET['loc_id'];
       $this->loc->read($loc_id);
       $this->loc->lname = $this->obj->loc[$_GET['loc_id']];
     } else if ( isset($_GET['loc_id']) && ($_GET['loc_id'] == "-1" )) {
       # use a empty new location
     } else {
       # if there is no default location use a empty new location
       foreach ($this->obj->location as $loc_id => $this->loc) {
	   }
	 }

     if ( ($this->obj->id < 0)
	  && !$this->user->feature_ok(useaddressbook, PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     else if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }

     if ( isset($_GET['name']) ) {
       $this->obj->name = StripSlashes($_GET['name']);
     }

     // menu
     $x = tutos_address::getSelectLink($this->user,$lang['Search']);
     $this->addMenu($x);
     if ( $this->user->feature_ok(useaddressbook,PERM_NEW) ) {
       $x = array('url'   => "company_new.php",
                  'text'  => $lang['NewEntry'],
                  'info'  => $lang['CompanyCreateInfo'],
		  'image' => 'new',
                  'category' => array("company","new","obj")
                 );
       $this->addMenu($x);
     }

     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array('url'   => $this->obj->getDelURL(),
                  'text'  => $lang['Delete'],
		  'image' => 'delete',
                  'info'  => sprintf($lang['CompanyDelInfo'],
				     $this->obj->getFullName()),
                  'category' => array("company","del","obj"),
                  'confirm' => true
                 );
       $this->addMenu($x);
     }

     if ( $this->obj->id > 0 ) {
       $x = array('url'   => $this->obj->getURL(),
                  'text'  => $lang['AdrSeeEntry'],
                  'info'  => sprintf($lang['AdrSeeEntryI'],
				     $this->obj->getFullName()),
                  'category' => array("company","view")
                 );
       $this->addMenu($x);
     }

     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new company_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: company_new.php,v 1.56.2.2 2004/09/21 16:06:36 tapoueh Exp $
    $Author: tapoueh $
-->
