<?
/**
 * On 2004 10 14 we change the data model of TUTOS bug module.
 *
 * Here's a script for you to manage the data while changing.
 * 
 * !! Remove/Disable this script after running !!
 *
 * $Id: migration.php,v 1.1.2.9 2004/12/13 17:29:13 tapoueh Exp $
 */

$tutos['base'] = "../..";
ini_set("include_path","..");

include_once 'webelements.p3';
include_once 'permission.p3';
include_once 'product.pinc';
include_once 'task.pinc';
include_once 'bug.pinc';
include_once 'timetrack.pinc';

require_once 'layout/layout.pinc';

check_user();
loadmodules("bugtracking", "show");
loadmodule("bugtracking");

/**
 * Migration plan : 
 *  1. extend the timetrack table to provide TEXT description
 *  2. rename existing bug and bugchanges tables
 *  3. drop constraints on bugs and bugchanges tables (or rename them)
 *  4. create new bug and bugchanges tables (with the new scheme)
 *  5. read and parse old bugs data
 *  6. write old data in new format in new tables
 *
 * The function create_temp_tables will do the points 2 and 3.
 *
 * ATTENTION:
 *  . the first point has to be done manually !
 *  . if you don't run postgresql, the 3rd point has also to be done manually
 *
 * Here's the PostgreSQL scenario to handle the change:
 *
 * > alter table timetrack add column new_desc text;
 * > update timetrack set new_desc = description::text;
 * > alter table timetrack drop description;
 * > alter table timetrack rename new_desc to description;
 *
 * If you now how to handle the case with TUTOS database object,
 * please contribute to this code for it to handle this update too.
 *
 * The script won't delete the old tables, letting the oportunity to
 * TUTOS admin to check data or cancel the migration.
 */ 
function create_temp_tables(&$dbconn) {
  global $tutos, $table, $tableidx;

  $nb_errors = 0;

  /**
   * The pg_db.pinc renametable requires the old table definition to
   * be passed in as a reference. As we obviously can't provide that,
   * and it only uses $table['name'], we create then pass in an array.
   *
   * Don't forget to drop the constraints if any
   */
  $bugs_array = array(name => 'bugs');
  $bugc_array = array(name => 'bugchanges');

  // drop constraints if postgresql is used
  if( $dbconn->openfunc == "pg_pconnect" ) {
    $sql = array("alter table bugs drop constraint bugs_pkey",
		 "alter table bugchanges drop constraint bugchanges_pkey");

    foreach( $sql as $q )
      $dbconn->exec($q, 1);
  }

  if( $dbconn->renametable($bugs_array, 'old_bugs') == -1 ) {
    $nb_errors++;
    echo "<tt>".$dbconn->lasterror."</tt><br>\n";
  }

  if( $dbconn->renametable($bugc_array, 'old_bugchanges') == -1 ) {
    $nb_errors++;
    echo "<tt>".$dbconn->lasterror."</tt><br>\n";
  }

  $bugs = $table['bug'];
  $bugchanges = $table['bug3'];

  /*
  echo "<pre>"; print_r($bugs); echo "</pre><br>\n";
  echo "<pre>"; print_r($bugchanges); echo "</pre><br>\n";
  */

  if( $dbconn->createtable($bugs) == -1 ) {
    $nb_errors++;
    echo "<tt>".$dbconn->lasterror."</tt><br>\n";
  }

  if( $dbconn->createtable($bugchanges) == -1 ) {
    $nb_errors++;
    echo "<tt>".$dbconn->lasterror."</tt><br>\n";
  }

  return $nb_errors == 0;
}

/**
 * Internationnal support : we have to look in all the localized files
 * for the state or class label found.
 */
function read_i18n($debug = False) {
  global $tutos, $bug_i18n;

  if( ! isset($bug_i18n) ) {
    /**
     * We read all the lang files and store the information we need
     */
    $bug_i18n = array();
    $path     = getcwd();

    if( $debug )
      echo 'find_label <tt>'.$path."</tt><br>\n";

    if ($handle = opendir($path)) {
      while (false !== ($file = readdir($handle))) { 
	if( preg_match("/^([a-z]{2}(?:-[a-z]*)?)\.p3$/", $file, $matches)  ) {
	  if( $debug )
	    echo $matches[1].": <tt>".$file."</tt><br>\n";

	  $country = $matches[1];
	  // If you use include_once here, you won't get the current
	  // user lang
	  include($path."/".$file);

	  $bug_i18n[$country] = array();
	  $bug_i18n[$country]['BugStates']  = $lang['BugStates'];
	  $bug_i18n[$country]['BugClasses'] = $lang['BugClasses'];

	  $bug_i18n[$country]['BugState'] = $lang['BugState'];
	  $bug_i18n[$country]['BugClass'] = $lang['BugClass'];
	  $bug_i18n[$country]['BugAssignedTo'] = $lang['BugAssignedTo'];
	  $bug_i18n[$country]['BugShort'] = $lang['BugShort'];

	  unset($lang);
	}
      }
    }
  }

  if( $debug ) {
    echo "<pre>"; print_r($bug_i18n); echo "</pre><br>\n";
  }
  return $bug_i18n;
}

/**
 * Given a name or an id, find the address in the data base and return
 * the associated TUTOS object.
 */
function getAddress(&$dbconn, $name) {
  global $current_user;

  if( is_numeric($name) ) {
    $solver = getObject($dbconn, $name);
  }
  else {
    /**
     * Firsts name with accentuated letters make TUTOS
     * webelements check_field function unable to find users.
     *
     * So we only take last name (in caps)...
     */
    $n = explode(" ", $name);
    $solver = check_field($n[1], "solver", "solver", "at");
  }
  
  if( ! is_object($solver) ) {
    echo "TUTOS could not find user ".$name."<br>\n";
    $solver = $current_user;
  }

  return $solver;
}

/**
 * Given the oject property name, returns the $lang field name
 */
function getFieldName($field) {
  $fields = array('state' => 'BugStates',
		  'class' => 'BugClasses');
  
  if( array_key_exists($field, $fields) )
    return $fields[$field];
  else
    return $field;
}


/**
 * Find out the property value in the translated strings,
 * starting with current $lang of course...
 */
function find_label($property, $value, $debug = False) {
  global $lang;

  $bug_i18n = read_i18n($debug);
  $lg_field = getFieldName($property);

  if( $lg_field == $property )
    return $value;

  if( ! ($v = array_search($value, $lang[$lg_field])) === False )
    return $v;
  
  foreach( $bug_i18n as $lg )    
    if( ! ($v = array_search($value, $lg[$lg_field])) === False )
      return $v;

  /**
   * We should not arrive here...
   */
  return $value;
}

/**
 * And we have to find the modified column
 */
function parse_field($field, $old, $new) {
  /**
   * Attention: we have to check i18n here
   *
   * We don't look in current (global) $lang, cause the translated
   * string we have as the field name ($field) could be found
   * associated with a non bug related key, as ProdState for example.
   */
  $bug_i18n = read_i18n(False);
  $known_fields = array('BugState'      => 'state',
			'BugClass'      => 'class',
			'BugAssignedTo' => 'solver',
			'BugShort'      => 'short');

  // default value is given one
  $real_field = $field;

  /**
   * We have to manage an hard-coded situation, where in old bugs you
   * may find a 'Solver changed ...' sentence. The 'Solver' entry seems
   * to have been hard-coded then, I can't find it in any translation
   * file.
   */
  if( $field == "Solver" )
    $real_field = 'solver';
  else
    foreach( $bug_i18n as $lg )
      if( ($f = array_search($field, $lg)) !== False ) {
	$real_field = $known_fields[$f];
	break;
      }

  if( $real_field != $field ) {
    $oldv = find_label($real_field, $old);
    $newv = find_label($real_field, $new);

    return array($real_field, $oldv, $newv);
  }
  return array($field, $old, $new);
}

/**
 * Bugs created before the bug_history table are a big concern, as
 * their historuy is to be found pre-formatted into the description
 * field.
 * Here we parse it to be able to create each entry.
 */
function parse_old_bugs($desc, $debug = False) {
  $hists = array();

  /**
   * With this pattern, we parse lines as :
   *  COLUMN changed from OLD to NEW by NAME
   * or
   * Added by NAME
   *
   * In the former case, the 7th [6] match will be empty
   *
   * We add a match to be able to have good indexes for description
   * retrieval
   */

  $date_pattern =
     "([0-9]{2}(?:\.|/)[0-9]{2}(?:\.|/)[0-9]{4} ".
     "[0-9]{2}:[0-9]{2}(?::[0-9]{2})?(?: [A-Z]{3,4})?)";
  $pattern =
     "%<[Bb]>".$date_pattern." -- ".
     "(?:".

     "([A-Za-z]*) changed from ".
     "<[Ii]>(?:<(?:FONT|font) [^>]*>)?([^<]*)(?:</(?:FONT|font)>)?</[Ii]> ".
     "to <[Ii]>(?:<(?:FONT|font) [^>]*>)?([^<]*)(?:</(?:FONT|font)>)?</[Ii]> ".
     "by ([^<]*)".

     "|".

     "Added by ([^<]*)".
     ")(</[Bb]>)%";

  if( $debug ) {
    echo "<tt>".htmlspecialchars($pattern)."</tt><br>\n";
    echo "<tt>".htmlspecialchars($desc)."</tt><br>\n";
  }

  $n = preg_match_all($pattern, $desc, $matches,
		      PREG_SET_ORDER|PREG_OFFSET_CAPTURE);
  if( $debug ) {
    echo "<pre>"; print_r($matches); echo "</pre><br>\n";  
  }

  if( $n == 0 ) {
    return array($desc, $hists);
  }

  $description = substr($desc, 0, $matches[0][0][1]);

  // We may have less hists entries than matches (same date)
  $h = 0;

  $prev = 0;
  $prev_date = new DateTime;

  /**
   * If true, added_by means the previous match was an  Added by 
   * one
   */
  $added_by = False;

  for($i=0; $i < count($matches); $i++ ) {
    $m    = $matches[$i];
    $hist = array();

    $date = new DateTime($m[1][0]);
    $hist['creation'] = $date;

    if( $m[6][1] == -1 ) {
      $field = $m[2][0];
      $old   = $m[3][0];
      $new   = $m[4][0];
      $by    = $m[5][0];

      // And we have to find the modified column
      $tuple = parse_field($field, $old, $new);
      $hist[$tuple[0]] = array($tuple[1], $tuple[2]);
    }
    else {
      $by       = $m[6][0];
    }

    if( $added_by ) {
      /**
       * We have to get the description associated with the Added by
       * line
       */
      $d = substr($desc, $prev, $m[0][1] - $prev);
      if( $d != "" )
	if( $debug )
	  $hists[$h - 1]['description'] = htmlspecialchars($d);
	else
	  $hists[$h - 1]['description'] = $d;
      
      $added_by = False;
    }
    $added_by = $m[6][1] > -1;

    $hist['creator']  = $by;

    if( $date->datecmp($prev_date) == 0 ) {
      $hists[$h-1] = array_merge($hists[$h-1], $hist);
    }
    else
      $hists[$h++] = $hist;

    // We keep the index of the last char on the previous entry
    // and its date
    $prev      = strlen($m[count($m)-1][0]) + $m[count($m)-1][1];
    $prev_date = $date;
  }

  /**
   * If the last entry was an  Added by  one, we have to get its
   * description
   */
  if( $added_by ) {
    $d = substr($desc, $prev);
    if( $d != "" )
      if( $debug )
	$hists[$h - 1]['description'] = htmlspecialchars($d);
      else
	$hists[$h - 1]['description'] = $d;
  }
  
  $parsed = array($description, $hists);

  if( $debug ) {
    echo "<pre>"; print_r($parsed); echo "</pre><br>\n";  
  }
  return $parsed;
}


/**
 * As the bug changes where previously stored with a description field
 * containing the HTML localized summary, we have to parse it in order
 * to obtain the modified elements.
 *
 * Returns an array of descriptions and changed fields:
 * {'description' => String, 'state' => {OLD, NEW}, ...}
 */
function parse_bug_history($desc, $debug = False) {
  global $lang;

  $hist = array();

  /**
   * Lines containing information changes begins with:
   *  <b>$lang['States']: <i><font>...</b>
   * for example
   *
   * Our pattern implies matches of 3 elements
   *
   * We add another match to count the end of the match elements, or
   * we won't be able to manage properly the indexes of inlined
   * descriptions
   */
  $pattern =
     "|<b>([^:]*): ".
     "<i>(?:<font[^>]*>)?([^<]*)(?:</font>)?</i>[^>]*".
     "<i>(?:<font[^>]*>)?([^<]*)(?:</font>)?(</i></b>)|";

  if( $debug ) {
    echo "<tt>".htmlspecialchars($pattern)."</tt><br>\n";
    $hist['summary'] = $desc;
  }

  $description = "";
  $lines = explode("\r\n", $desc);

  foreach( $lines as $l ) {
    if( $debug )
      echo htmlspecialchars($l)."<br>\n";

    $n = preg_match_all($pattern, $l, $matches,
			PREG_SET_ORDER|PREG_OFFSET_CAPTURE);

    if( $debug ) {
      // echo "<pre>"; print_r($matches); echo "</pre><br>\n";  
    }

    $desc_idx = 0;
    for($i = 0; $i < $n; $i++) {
      $field = $matches[$i][1][0];
      $old   = $matches[$i][2][0];
      $new   = $matches[$i][3][0];

      // And we have to find the modified column
      $tuple = parse_field($field, $old, $new);
      $hist[$tuple[0]] = array($tuple[1], $tuple[2]);

      // We keep only the last index
      $desc_idx = strlen($matches[$i][4][0]) + $matches[$i][4][1];
    }

    $new_desc = substr($l, $desc_idx);   
    if( $description != "" )
      $description .= "\n";

    $description .= $new_desc;
  }

  if( trim($description) != "" ) {
    if( $debug )
      $hist['description'] = htmlspecialchars($description);
    else
      $hist['description'] = $description;
  }

  if( $debug ) {
    echo "<pre>"; print_r($hist); echo "</pre>\n";
    echo "<hr>\n";
  }

  return $hist;
}

/**
 * Get all bugs, then call the good parse function, and return the
 * list of all bugs.
 *
 * the t_bugs and t_bugchanges are the table names where to look for
 * bugs. In the case of migration, those tables will be renamed at the
 * access time.
 */
function parse_all_bugs(&$dbconn,
			$t_bugs = "bugs", $t_bugchanges = "bugchanges")
{
  $q = "SELECT * FROM ".$t_bugs;
  $r = $dbconn->Exec($q);
  $n = $r->numrows();

  $bugs = array();

  for($a = 0; $a < $n; $a++ ) {
    $bugid = $r->get($a, 'id');
    $desc  = $r->get($a, 'description');

    if( $bugid == "" || $bugid < 0 )
      continue;

    $bug = array('id'          => $bugid,
		 'name'        => $r->get($a, 'name'),
		 'short'       => $r->get($a, 'short'),
		 'description' => $desc,
		 'product_id'  => $r->get($a, 'product_id'),
		 'class'       => $r->get($a, 'class'),
		 'state'       => $r->get($a, 'state'),
		 'solver'      => $r->get($a, 'solver'),
		 'solvedate'   => $r->get($a, 'solvedate'),
		 'creator'     => $r->get($a, 'creator'),
		 'creation'    => $r->get($a, 'creation'),
		 );
      
    $qh =
       "SELECT    c.* ".
       "FROM      ".$t_bugs." b, ".$t_bugchanges." c ".
       "WHERE     b.id = ".$bugid." AND b.id = c.bugid ".
       "ORDER BY  c.id, c.creation";
    $rh = $dbconn->Exec($qh);
    $nh = $rh->numrows();

    $hist = array();

    if( $nh == 0 ) {
      // No bug history, parse the description
      $parsed = parse_old_bugs($desc);
      $description = $parsed[0];
      $changeset   = $parsed[1];

      $bug['summary']     = $desc;
      $bug['description'] = $description;

      foreach( $changeset as $c ) {
	$hist[] = array('id'          => '?',
			'bugid'       => $bugid,
			'description' => $c['description'],
			'creator'     => $c['creator'],
			'creation'    => $c['creation']->getDateTime(),
			'changeset'   => $c);
      }
    }
    else {
      for($h = 0; $h < $nh; $h++) {
	// Now we have to split out the description field
	$desc = $rh->get($h, 'description');
	$changeset = parse_bug_history($desc);

	$date = new DateTime($rh->get($h, 'creation'));

	$hist[] = array('id'          => $rh->get($h, 'id'),
			'bugid'       => $rh->get($h, 'bugid'),
			'description' => $desc,
			'creator'     => $rh->get($h, 'creator'),
			'creation'    => $date->getDateTime(),
			'changeset'   => $changeset
			);
      }
    }
    $rh->free();

    $bug['hist'] = $hist;
    $bugs[] = $bug;
  }
  $r->free();

  return $bugs;
}

class migration extends layout {
  /**
   * Parse all the bug data and generate a structure from that, then
   * prepare it for smarty to display
   */
  function see() {
    global $tutos, $lang;

    if( $this->old )
      $bugs = parse_all_bugs($this->dbconn, "old_bugs", "old_bugchanges");
    else
      $bugs = parse_all_bugs($this->dbconn);

    $n = count($bugs);

    $display_bugs = array();

    if ( $this->start == -1 ) {
      $a = $n - $tutos[maxshow];
      $end = $n;
      $this->start = $a;
    }
    else {
      $a = $this->start;
      $end = $this->start + $tutos[maxshow];
    }
    
    // No search filter
    $filter = array();
    $this->assign_navbar($a, $end, $n, $filter);

    $this->assign('Date',          $lang['Date']);
    $this->assign('Bug',           $lang['Bug']);
    $this->assign('BugReference',  $lang['BugReference']);
    $this->assign('BugState',      $lang['BugState']);
    $this->assign('BugClass',      $lang['BugClass']);
    $this->assign('BugShort',      $lang['BugShort']);
    $this->assign('BugLong',       $lang['BugLong']);
    $this->assign('BugCreator',    $lang['BugCreator']);
    $this->assign('BugCreation',   $lang['BugCreation']);
    $this->assign('BugAssignedTo', $lang['BugAssignedTo']);
    $this->assign('BugCreation',   $lang['BugCreation']);

    $exclude_keys = array('creator', 'creation');
    $i18n_fields  = array('state', 'class');

    for(; $a < $n && $a < $end; $a++ ) {
      /**
       * State and class i18n management
       */ 
      $bugs[$a]['class'] = $lang['BugClasses'][$bugs[$a]['class']];
      $bugs[$a]['state'] = $lang['BugStates'][$bugs[$a]['state']];

      $bug  = $bugs[$a];
      $hist = $bug['hist'];

      foreach( $hist as $x => $h ) {
	/**
	 * We have to clean the changeset in order not to have
	 * duplicates informations
	 *
	 * We also do some i18n trick here, to have a better display
	 */

	$changeset = $h['changeset'];
	$changes = array();

	foreach( $changeset as $k => $v ) {
	  if( ! in_array($k, $exclude_keys) ) {
	    if( in_array($k, $i18n_fields) ) {
	      // don't forget $v is array(OLD, NEW)
	      $changes[$k] = array();
	      foreach( $v as $z ) {
		$changes[$k][] = $lang[getFieldName($k)][$z];
	      }
	    }
	    else
	      $changes[$k] = $v;
	  }
	}
	/**
	 * Replace the changeset with the new one.
	 */
	$bug['hist'][$x]['changeset'] = $changes;
      }
      $display_bugs[] = $bug;
    }

    $this->assign('bugs', $display_bugs);
    $this->template('bugtracking/migration');
  }

  /**
   * Get all the bugs data, parse it and store it in the new format,
   * using new code for that (cvs code after editing, so code you have
   * by the time you run this script).
   */
  function migrate() {
    global $current_user;

    if( $this->scheme ) {
      echo 'creating new tables sheme...'."<br>\n";

      // First create the new table
      if( ! create_temp_tables($this->dbconn) ) {
	$this->error("Please correct above errors!");
	return;
      }
    }
    else
      echo "ok, won't care about scheme"."<br>\n";

    echo 'importing and parsing old bugs...'."<br>\n";
    // Then get the bugs in old tables
    $bugs = parse_all_bugs($this->dbconn, "old_bugs", "old_bugchanges");
    
    foreach( $bugs as $b ) {
      $bug = new bug($this->dbconn);

      // This will generate a LOT of output
      $this->debug($b);

      $solvedate = $b['solvedate'];
      $creator   = getAddress($this->dbconn, $b['creator']);
      echo 'creator: '.$creator->getFullName()." (".$b['creator'].")<br>\n";

      $bug->id        = -1;
      $bug->name      = $b['name'];
      $bug->parent    = getObject($this->dbconn, $b['product_id']);
      $bug->short     = $b['short'];
      $bug->creator   = $creator;
      $bug->creation  = new DateTime($b['creation']);

      // Don't overwrite default solvedate if none is given
      if( $solvedate != "" ) $bug->solvedate = new DateTime($solvedate);

      $bug->state     = $b['state'];
      $bug->class     = $b['class'];
      $bug->solver    = getAddress($this->dbconn, $b['solver']);
      $bug->save();

      echo 'bug '.$b['id'].' -> '.$bug->id.'...'."<br>\n";
      echo 'at '.
	$bug->creation->getDateTime().' ['.$b['creation']." ]<br>\n";

      $n = count($b['hist']);

      /**
       * Initial state, class and solver of a bug are to be found on
       * the first changeset, or are the current ones (and have never
       * been changed).
       *
       * So we have to run a first loop over history to find initial
       * values.
       */
      $i_state  = -1;
      $i_class  = -1;
      $i_solver = "";

      foreach( $b['hist'] as $hist ) {
	if( $i_state == -1 && isset($hist['changeset']['state']) )
	  $i_state = $hist['changeset']['state'][0];

	if( $i_class == -1 && isset($hist['changeset']['class']) )
	  $i_class = $hist['changeset']['class'][0];

	if( $i_solver == "" && isset($hist['changeset']['solver']) )
	  $i_solver = getAddress($this->dbconn,
				 $hist['changeset']['solver'][0]);
      }

      /**
       * If no change has been encountered, then the initial values
       * are the same as the final ones, to be found in the bug
       * definition...
       */
      if( $i_state  == -1 )  $i_state  = $bug->state;
      if( $i_class  == -1 )  $i_class  = $bug->class;
      if( $i_solver == "" )  $i_solver = $bug->solver;

      /**
       * After reading all the bug history entries, we are able to set
       * the right state and class elements.
       *
       * And we have to create the first history entry, which is
       * contains partly in bug itself and partly recomposed upon
       * analysis.
       */
      $h = new bugdata($this->dbconn);
      $h->bugid       = $bug->id;
      $h->creator     = $bug->creator;
      $h->creation    = $bug->creation;
      $h->state       = $i_state;
      $h->class       = $i_class;
      $h->solver      = $i_solver;
      $h->description = html_entity_decode($b['description'],
					   ENT_QUOTES, 'ISO8859-15');

      $h->save();
      echo "initial bughistory element ".$h->id." [".$h->bugid."]<br>\n";
      echo 'at '.$h->creation->getDateTime().' ['.$b['creation']." ]<br>\n";

      // Prepare the previous element
      $previous = $h;

      /**
       * In this loop, we create the bug history elements, which are
       * to be found as rows in the bugchanges table, with links to
       * timetracks elements (description, solver).
       */
      for($i = 0; $i < $n; $i++) {
	$hist = &$b['hist'][$i];

	$h = new bugdata($this->dbconn);
	if( $hist['id'] != '?' )
	  $h->id     = $hist['id'];
	$h->bugid    = $bug->id;

	// get creator
	$creator = getAddress($this->dbconn, $hist['creator']);
	$h->creator = $creator;
	echo 'creator: '.$creator->id." ".$creator->getFullName()."<br>\n";

	/**
	 * We read the new class, state and solver from the changeset,
	 * which contains an array of (old, new) values.
	 *
	 * When the value has not been changed, copy previous one.
	 */
	if( isset($hist['changeset']['state']) )
	  $h->state  = $hist['changeset']['state'][1];
	else
	  $h->state = $previous->state;

	if( isset($hist['changeset']['class']) )
	  $h->class  = $hist['changeset']['class'][1];
	else
	  $h->class = $previous->class;

	if( isset($hist['changeset']['solver']) ) {
	  $solver = getAddress($this->dbconn, $hist['changeset']['solver'][1]);
	  echo 'solver : '.$solver->id." ".$solver->getFullName()."<br>\n";
	  $h->solver = $solver;
	}
	else
	  $h->solver = $previous->solver;

	// And we get creation time and description
	$h->creation = new DateTime($hist['creation']);
	$h->description =
	   html_entity_decode($hist['changeset']['description'],
			      ENT_QUOTES, 'ISO8859-15');

	$h->save();
	echo "new bughistory element ".$h->id." [".$h->bugid."]<br>\n";
	echo
	  'at '.$h->creation->getDateTime().' ['.$hist['creation']." ]<br>\n";

	$previous = $h;
	unset($h);
      }
      unset($h);
      echo "<hr>\n";
    }
  }

  function info() {
    switch($this->action) {
    case "migrate":
      $this->migrate();
      break;

    case "test_parse_field":
      {
	$a = parse_field('Assign a', 'toto', 'titi');
	$b = parse_field('tat', 'OUVERT', 'FERM');
	$c = parse_field('Type', 'Lger', 'Grave');
	$d = parse_field('Solver', 'toto', 'titi');
	$e = parse_field('Assigned to', 'toto', 'titi');
	
	echo "<pre>"; print_r($a); echo "</pre><br>\n";
	echo "<pre>"; print_r($b); echo "</pre><br>\n";
	echo "<pre>"; print_r($c); echo "</pre><br>\n";
	echo "<pre>"; print_r($d); echo "</pre><br>\n";
	echo "<pre>"; print_r($e); echo "</pre><br>\n";
	break; 
      }

    default:
      $this->see();
      break;
    }
  }

  function navigate() {
    $this->menuPrint('migration');
  }

  function prepare() {
    $actions = array("see", "migrate", "test_parse_field");
    $this->action = "see";
    $this->old    = false;

    if( isset($_GET['action']) && $_GET['action'] != "" )
      if( in_array($_GET['action'], $actions) ) {
	$this->action = $_GET['action'];
	$this->search['action'] = $this->action;
      }

    $this->assign('actions', $actions);

    if( isset($_GET['old']) && $_GET['old'] != "" && $_GET['old'] == 'yes' )
      $this->old == true;

    if( isset($_GET['start']) && $_GET['start'] != "" )
      $this->start = $_GET['start'];
    else
      $this->start = 0;

    if( isset($_GET['scheme']) && $_GET['scheme'] != "" )
      $this->scheme = in_array($_GET['scheme'], array('1', 'yes'));
    else
      $this->scheme = True;

    foreach( $actions as $action ) {
      $x = array('url'   => "bugtracking/migration.php?action=".$action,
		 'text'  => $action,
		 'info'  => $action,
		 'image' => 'bugs',
		 'category' => array("migration")
		 );
      $this->addMenu($x);
    }
  }
}

$l = new migration($current_user);
// $l->display($withmenu = False);
$l->display();
?>
